/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.wiring;

import java.util.Collections;
import java.util.Map;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleRequirementImpl
implements BundleRequirement {
    private final BundleRevision m_revision;
    private final String m_namespace;
    private final SimpleFilter m_filter;
    private final boolean m_optional;
    private final Map<String, String> m_dirs;
    private final Map<String, Object> m_attrs;

    public BundleRequirementImpl(BundleRevision revision, String namespace, Map<String, String> dirs, Map<String, Object> attrs, SimpleFilter filter) {
        this.m_revision = revision;
        this.m_namespace = namespace;
        this.m_dirs = Collections.unmodifiableMap(dirs);
        this.m_attrs = Collections.unmodifiableMap(attrs);
        this.m_filter = filter;
        boolean optional = false;
        if (this.m_dirs.containsKey("resolution") && this.m_dirs.get("resolution").equals("optional")) {
            optional = true;
        }
        this.m_optional = optional;
    }

    public BundleRequirementImpl(BundleRevision revision, String namespace, Map<String, String> dirs, Map<String, Object> attrs) {
        this(revision, namespace, dirs, Collections.EMPTY_MAP, SimpleFilter.convert(attrs));
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.m_dirs;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.m_attrs;
    }

    @Override
    public BundleRevision getRevision() {
        return this.m_revision;
    }

    @Override
    public boolean matches(BundleCapability cap) {
        return CapabilitySet.matches((BundleCapabilityImpl)cap, this.getFilter());
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public SimpleFilter getFilter() {
        return this.m_filter;
    }

    public String toString() {
        return new StringBuffer().append("[").append(this.m_revision).append("] ").append(this.m_namespace).append("; ").append(this.getFilter().toString()).toString();
    }
}

