/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.grid.shared.CliUtils;

public class GridDocHelper {
    private static List<Option> hubOptions = GridDocHelper.load("org/openqa/grid/common/defaults/HubOptions.json");
    private static List<Option> nodeOptions = GridDocHelper.load("org/openqa/grid/common/defaults/NodeOptions.json");
    private static Map<String, String> hubOptionsMap;

    public static void printHubHelp(String msg) {
        GridDocHelper.printHubHelp(msg, true);
    }

    public static void printHubHelp(String msg, boolean error) {
        GridDocHelper.printHelpInConsole(msg, "hub", hubOptions, error);
        CliUtils.printWrappedLine("", "This synopsis lists options available in hub role only. To get help on the command line options available for other roles run the server with -help name and the corresponding -role name value.");
    }

    public static void printNodeHelp(String msg) {
        GridDocHelper.printNodeHelp(msg, true);
    }

    public static void printNodeHelp(String msg, boolean error) {
        GridDocHelper.printHelpInConsole(msg, "node", nodeOptions, error);
        CliUtils.printWrappedLine("", "This synopsis lists options available in node role only. To get help on the command line options available for other roles run the server with -help name and the corresponding -role name value.");
    }

    public static String getHubParam(String param) {
        if (hubOptionsMap == null) {
            hubOptionsMap = new HashMap<String, String>();
            for (Option option : hubOptions) {
                hubOptionsMap.put(option.name, option.description);
            }
        }
        if (hubOptionsMap.containsKey(param)) {
            return hubOptionsMap.get(param);
        }
        return "No help specified for " + param;
    }

    private static void printHelpInConsole(String msg, String role, List<Option> options, boolean error) {
        String indent = "  ";
        String indent2x = String.valueOf(indent) + indent;
        if (msg != null) {
            if (error) {
                System.out.println("Error building the config :" + msg);
            } else {
                System.out.println(msg);
            }
        }
        System.out.println("Usage: java -jar selenium-server.jar -role " + role + " [options]\n");
        for (Option option : options) {
            System.out.println(String.valueOf(indent) + "-" + option.name + ":");
            CliUtils.printWrappedLine(System.out, indent2x, option.description, true);
            System.out.println("");
        }
    }

    private static List<Option> load(String resource) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        ArrayList<Option> result = new ArrayList<Option>();
        try {
            JsonElement json = new JsonParser().parse((Reader)new InputStreamReader(in));
            for (JsonElement element : json.getAsJsonArray()) {
                JsonArray arr = element.getAsJsonArray();
                result.add(new Option(arr.get(0).getAsString(), arr.get(1).getAsString()));
            }
        }
        catch (JsonIOException jsonIOException) {
            throw new RuntimeException(String.valueOf(resource) + " cannot be loaded.");
        }
        return result;
    }

    private static class Option {
        private final String name;
        private final String description;

        public Option(String option, String description) {
            this.name = option;
            this.description = description;
        }
    }
}

