/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.ior;

import com.sun.corba.se.spi.presentation.rmi.StubAdapter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class StubIORImpl {
    private int hashCode;
    private byte[] typeData;
    private int[] profileTags;
    private byte[][] profileData;

    public StubIORImpl() {
        this.hashCode = 0;
        this.typeData = null;
        this.profileTags = null;
        this.profileData = null;
    }

    public String getRepositoryId() {
        if (this.typeData == null) {
            return null;
        }
        return new String(this.typeData);
    }

    public StubIORImpl(Object object) {
        OutputStream outputStream = StubAdapter.getORB(object).create_output_stream();
        outputStream.write_Object(object);
        InputStream inputStream = outputStream.create_input_stream();
        int n = inputStream.read_long();
        this.typeData = new byte[n];
        inputStream.read_octet_array(this.typeData, 0, n);
        int n2 = inputStream.read_long();
        this.profileTags = new int[n2];
        this.profileData = new byte[n2][];
        for (int i = 0; i < n2; ++i) {
            this.profileTags[i] = inputStream.read_long();
            this.profileData[i] = new byte[inputStream.read_long()];
            inputStream.read_octet_array(this.profileData[i], 0, this.profileData[i].length);
        }
    }

    public Delegate getDelegate(ORB oRB) {
        OutputStream outputStream = oRB.create_output_stream();
        outputStream.write_long(this.typeData.length);
        outputStream.write_octet_array(this.typeData, 0, this.typeData.length);
        outputStream.write_long(this.profileTags.length);
        for (int i = 0; i < this.profileTags.length; ++i) {
            outputStream.write_long(this.profileTags[i]);
            outputStream.write_long(this.profileData[i].length);
            outputStream.write_octet_array(this.profileData[i], 0, this.profileData[i].length);
        }
        InputStream inputStream = outputStream.create_input_stream();
        Object object = inputStream.read_Object();
        return StubAdapter.getDelegate(object);
    }

    public void doRead(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.typeData = new byte[n];
        objectInputStream.readFully(this.typeData);
        int n2 = objectInputStream.readInt();
        this.profileTags = new int[n2];
        this.profileData = new byte[n2][];
        for (int i = 0; i < n2; ++i) {
            this.profileTags[i] = objectInputStream.readInt();
            this.profileData[i] = new byte[objectInputStream.readInt()];
            objectInputStream.readFully(this.profileData[i]);
        }
    }

    public void doWrite(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.typeData.length);
        objectOutputStream.write(this.typeData);
        objectOutputStream.writeInt(this.profileTags.length);
        for (int i = 0; i < this.profileTags.length; ++i) {
            objectOutputStream.writeInt(this.profileTags[i]);
            objectOutputStream.writeInt(this.profileData[i].length);
            objectOutputStream.write(this.profileData[i]);
        }
    }

    public synchronized int hashCode() {
        if (this.hashCode == 0) {
            int n;
            for (n = 0; n < this.typeData.length; ++n) {
                this.hashCode = this.hashCode * 37 + this.typeData[n];
            }
            for (n = 0; n < this.profileTags.length; ++n) {
                this.hashCode = this.hashCode * 37 + this.profileTags[n];
                for (int i = 0; i < this.profileData[n].length; ++i) {
                    this.hashCode = this.hashCode * 37 + this.profileData[n][i];
                }
            }
        }
        return this.hashCode;
    }

    private boolean equalArrays(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equalArrays(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equalArrays(byte[][] byArray, byte[][] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (this.equalArrays(byArray[i], byArray2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(java.lang.Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StubIORImpl)) {
            return false;
        }
        StubIORImpl stubIORImpl = (StubIORImpl)object;
        if (stubIORImpl.hashCode() != this.hashCode()) {
            return false;
        }
        return this.equalArrays(this.typeData, stubIORImpl.typeData) && this.equalArrays(this.profileTags, stubIORImpl.profileTags) && this.equalArrays(this.profileData, stubIORImpl.profileData);
    }

    private void appendByteArray(StringBuffer stringBuffer, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i]));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SimpleIORImpl[");
        String string = new String(this.typeData);
        stringBuffer.append(string);
        for (int i = 0; i < this.profileTags.length; ++i) {
            stringBuffer.append(",(");
            stringBuffer.append(this.profileTags[i]);
            stringBuffer.append(")");
            this.appendByteArray(stringBuffer, this.profileData[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

