/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.PlatformUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;

public class AmbleMapper {
    static FontNameInfo[] fontInfo = new FontNameInfo[]{new FontNameInfo("Amble-Regular.ttf", "Amble-Regular", "Amble", "Amble Regular"), new FontNameInfo("Amble-Bold.ttf", "Amble-Bold", "Amble", "Amble Bold"), new FontNameInfo("Amble-Italic.ttf", "Amble-Italic", "Amble", "Amble Italic"), new FontNameInfo("Amble-BoldItalic.ttf", "Amble-BoldItalic", "Amble", "Amble Bold Italic"), new FontNameInfo("Amble-Condensed.ttf", "Amble-Condensed", "Amble Cn", "Amble Condensed"), new FontNameInfo("Amble-BoldCondensed.ttf", "Amble-BoldCondensed", "Amble Cn", "Amble Bold Condensed"), new FontNameInfo("Amble-CondensedItalic.ttf", "Amble-CondensedItalic", "Amble Cn", "Amble Condensed Italic"), new FontNameInfo("Amble-BoldCondensedItalic.ttf", "Amble-BoldCondensedItalic", "Amble Cn", "Amble Bold Condensed Italic"), new FontNameInfo("Amble-Light.ttf", "Amble-Light", "Amble Lt", "Amble Light"), new FontNameInfo("Amble-LightItalic.ttf", "Amble-LightItalic", "Amble Lt", "Amble Light Italic"), new FontNameInfo("Amble-LightCondensed.ttf", "Amble-LightCondensed", "Amble LtCn", "Amble Light Condensed"), new FontNameInfo("Amble-LightCondensedItalic.ttf", "Amble-LightCondensedItalic", "Amble LtCn", "Amble Light Condensed Italic")};

    static String[] getAllFullNames() {
        String[] stringArray = new String[fontInfo.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = AmbleMapper.fontInfo[i].fullname;
        }
        return stringArray;
    }

    private static InputStream localFileFromRuntimeJar(String string) {
        try {
            return AmbleMapper.class.getResourceAsStream("/com/sun/fonts/" + string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static File extractFileFromRuntimeJar(String string) {
        try {
            int n;
            InputStream inputStream = AmbleMapper.localFileFromRuntimeJar(string);
            if (inputStream == null) {
                return null;
            }
            inputStream = new BufferedInputStream(inputStream);
            File file = new File(AmbleMapper.getUserFontCacheDir());
            if (!file.exists()) {
                file.mkdirs();
            }
            File file2 = File.createTempFile("font", "tmp", file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) > 0) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            }
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
            File file3 = new File(file, string);
            if (!file3.exists()) {
                file2.renameTo(file3);
            }
            return file3;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getUserFontCacheDir() {
        if (PlatformUtil.isWindows()) {
            return System.getProperty("user.home") + File.separator + "Sun" + File.separator + "JavaFX" + File.separator + "fonts";
        }
        return System.getProperty("user.home") + File.separator + ".javafx" + File.separator + "fonts";
    }

    static File getFile(String string) {
        File file;
        FontNameInfo fontNameInfo = FontNameInfo.nameMap.get(string.toLowerCase());
        if (fontNameInfo == null) {
            return null;
        }
        final String string2 = fontNameInfo.filename;
        try {
            file = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    File file = AmbleMapper.locateFile(string2);
                    if (file == null) {
                        file = AmbleMapper.extractFileFromRuntimeJar(string2);
                    }
                    return file;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
        return file;
    }

    static String getFilePath(String string) {
        File file = AmbleMapper.getFile(string);
        if (file == null) {
            return null;
        }
        return file.getPath();
    }

    private static File locateFile(String string) {
        Object object;
        String[] stringArray;
        int n = 0;
        if (PlatformUtil.isMac()) {
            stringArray = new String[5];
            n = 3;
            stringArray[0] = AmbleMapper.getUserFontCacheDir();
            stringArray[1] = "/Library/Fonts/";
            stringArray[2] = "/System/Library/Fonts/";
            String string2 = System.getProperty("java.home");
            if (string2 != null) {
                stringArray[n++] = string2 + "/lib/fonts/";
            }
            if ((object = System.getProperty("user.home")) != null) {
                stringArray[n++] = (String)object + "/Library/Fonts/";
            }
        } else {
            stringArray = new String[1];
            n = 1;
            stringArray[0] = AmbleMapper.getUserFontCacheDir();
        }
        for (int i = 0; i < n; ++i) {
            object = new File(stringArray[i], string);
            if (!((File)object).exists()) continue;
            return object;
        }
        return null;
    }

    static class FontNameInfo {
        boolean failed = false;
        String filename;
        String psName;
        String macFamily;
        String winFamily;
        String fullname;
        static Map<String, FontNameInfo> nameMap = new HashMap<String, FontNameInfo>();

        FontNameInfo(String string, String string2, String string3, String string4) {
            this.filename = string;
            this.psName = string2;
            this.macFamily = "Amble";
            this.winFamily = string3;
            this.fullname = string4;
            nameMap.put(this.psName.toLowerCase(), this);
            nameMap.put(this.fullname.toLowerCase(), this);
        }
    }
}

