/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.ExitDialog;
import org.netbeans.core.NbLoaderPool;
import org.netbeans.core.WindowSystem;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.ModuleLifecycleManager;
import org.netbeans.core.startup.layers.SessionManager;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public final class NbLifecycleManager
extends LifecycleManager {
    private static boolean doingExit = false;
    private static final Runnable DO_EXIT = new ExitActions(0);

    public void saveAll() {
        ArrayList<DataObject> bad = new ArrayList<DataObject>();
        DataObject[] modifs = DataObject.getRegistry().getModified();
        if (modifs.length == 0) {
            return;
        }
        for (DataObject dobj : modifs) {
            try {
                SaveCookie sc = (SaveCookie)dobj.getLookup().lookup(SaveCookie.class);
                if (sc == null) continue;
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbLifecycleManager.class, (String)"CTL_FMT_SavingMessage", (Object)dobj.getName()));
                sc.save();
            }
            catch (IOException ex) {
                Logger.getLogger(NbLifecycleManager.class.getName()).log(Level.WARNING, null, ex);
                bad.add(dobj);
            }
        }
        for (DataObject badDO : bad) {
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(NbLifecycleManager.class, (String)"CTL_Cannot_save", (Object)badDO.getPrimaryFile().getName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbLifecycleManager.class, (String)"MSG_AllSaved"));
    }

    public void exit() {
        Mutex.EVENT.readAccess(DO_EXIT);
    }

    public void exit(int status) {
        ExitActions action = new ExitActions(0, status);
        Mutex.EVENT.readAccess((Runnable)action);
    }

    public static boolean isExiting() {
        return doingExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doExit(int status) {
        block9: {
            if (doingExit) {
                return;
            }
            doingExit = true;
            try {
                if (System.getProperty("netbeans.close") == null && !ExitDialog.showDialog() || !Main.getModuleSystem().shutDown((Runnable)new ExitActions(1, status))) break block9;
                try {
                    try {
                        NbLoaderPool.store();
                    }
                    catch (IOException ioe) {
                        Logger.getLogger(NbLifecycleManager.class.getName()).log(Level.WARNING, null, ioe);
                    }
                    SessionManager.getDefault().close();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    Exceptions.printStackTrace((Throwable)t);
                }
                Task exitTask = new Task((Runnable)new ExitActions(2, status));
                RequestProcessor.getDefault().post((Runnable)exitTask);
                exitTask.waitFinished();
            }
            finally {
                doingExit = false;
            }
        }
    }

    public void markForRestart() throws UnsupportedOperationException {
        new ModuleLifecycleManager().markForRestart();
    }

    private static class ExitActions
    implements Runnable {
        private final int type;
        private final int status;

        ExitActions(int type) {
            this.type = type;
            this.status = 0;
        }

        ExitActions(int type, int status) {
            this.type = type;
            this.status = status;
        }

        @Override
        public void run() {
            switch (this.type) {
                case 0: {
                    NbLifecycleManager.doExit(this.status);
                    break;
                }
                case 1: {
                    CLIHandler.stopServer();
                    WindowSystem windowSystem = (WindowSystem)Lookup.getDefault().lookup(WindowSystem.class);
                    boolean gui = CLIOptions.isGui();
                    if (windowSystem != null && gui) {
                        windowSystem.hide();
                        windowSystem.save();
                    }
                    if (!Boolean.getBoolean("netbeans.close.when.invisible")) break;
                    TopSecurityManager.exit((int)this.status);
                    break;
                }
                case 2: {
                    if (Boolean.getBoolean("netbeans.close.no.exit")) break;
                    TopSecurityManager.exit((int)this.status);
                    break;
                }
                default: {
                    throw new IllegalStateException("Type: " + this.type);
                }
            }
        }
    }
}

