/*
 * Decompiled with CFR 0.152.
 */
package org.shop.tools;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.shop.tools.InsuredOld;

public class S20BinaryLookup
extends PlainDocument {
    JComboBox comboBox;
    ComboBoxModel model;
    JTextComponent editor;
    boolean selecting = false;
    boolean ucase = false;
    Integer cap = 0;
    String criteria = "1111";
    boolean hidePopupOnFocusLoss;
    boolean hitBackspace = false;
    boolean hitDelete = false;
    boolean hitBackspaceOnSelection;

    public S20BinaryLookup(final JComboBox comboBox, String c, Integer i, boolean b) {
        this.ucase = b;
        this.cap = i;
        this.criteria = c;
        this.comboBox = comboBox;
        this.model = comboBox.getModel();
        this.editor = (JTextComponent)comboBox.getEditor().getEditorComponent();
        this.editor.setDocument(this);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!S20BinaryLookup.this.selecting) {
                    S20BinaryLookup.this.highlightCompletedText(0);
                }
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (comboBox.isDisplayable()) {
                    comboBox.setPopupVisible(true);
                }
                S20BinaryLookup.this.hitBackspace = false;
                S20BinaryLookup.this.hitDelete = false;
                switch (e.getKeyCode()) {
                    case 8: {
                        S20BinaryLookup.this.hitBackspace = true;
                        S20BinaryLookup.this.hitBackspaceOnSelection = S20BinaryLookup.this.editor.getSelectionStart() != S20BinaryLookup.this.editor.getSelectionEnd();
                        break;
                    }
                    case 9: {
                        e.consume();
                        break;
                    }
                    case 35: {
                        e.consume();
                        break;
                    }
                    case 10: {
                        JTextComponent editor = (JTextComponent)((JComboBox)((Component)e.getSource()).getParent()).getEditor().getEditorComponent();
                        Object item = S20BinaryLookup.this.binaryLookup(editor.getText(), true);
                        if (item == null) {
                            Object item1 = S20BinaryLookup.this.binaryLookup(editor.getText(), true);
                            item = editor.getText();
                        }
                        S20BinaryLookup.this.setSelectedItem(item);
                        S20BinaryLookup.this.setText(item.toString());
                        e.consume();
                        if (!S20BinaryLookup.this.hidePopupOnFocusLoss) break;
                        comboBox.setPopupVisible(false);
                        break;
                    }
                    case 127: {
                        S20BinaryLookup.this.hitDelete = true;
                        break;
                    }
                    default: {
                        e.consume();
                    }
                }
            }
        });
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                S20BinaryLookup.this.highlightCompletedText(0);
            }

            @Override
            public void focusLost(FocusEvent e) {
                JTextComponent editor;
                Object item;
                if (S20BinaryLookup.this.hidePopupOnFocusLoss) {
                    comboBox.setPopupVisible(false);
                }
                if ((item = S20BinaryLookup.this.binaryLookup((editor = (JTextComponent)((JComboBox)((Component)e.getSource()).getParent()).getEditor().getEditorComponent()).getText(), true)) == null) {
                    item = editor.getText();
                }
                S20BinaryLookup.this.setSelectedItem(item);
                S20BinaryLookup.this.setText(item.toString());
            }
        });
        this.setPrototypeValue();
        Object selected = comboBox.getSelectedItem();
        if (selected != null) {
            this.setText(selected.toString());
        }
        this.highlightCompletedText(0);
    }

    public void setPrototypeValue() {
        JList list = this.getListBox();
        this.setPrototypeValue(this.getPrototypeValue(list), list);
    }

    void setPrototypeValue(Object value, JList list) {
        this.comboBox.setPrototypeDisplayValue(value);
        list.setPrototypeCellValue(value);
    }

    Object getPrototypeValue(JList list) {
        Object prototypeValue = null;
        double prototypeWidth = 0.0;
        ListCellRenderer renderer = this.comboBox.getRenderer();
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object value = this.model.getElementAt(i);
            Component c = renderer.getListCellRendererComponent(list, value, i, false, false);
            double width = c.getPreferredSize().getWidth();
            if (!(width > prototypeWidth)) continue;
            prototypeWidth = width;
            prototypeValue = value;
        }
        return prototypeValue;
    }

    public ComboBoxModel getModel() {
        return this.model;
    }

    public JTextComponent getEditor() {
        return this.editor;
    }

    JList getListBox() {
        JList listBox;
        try {
            Field field = JComponent.class.getDeclaredField("ui");
            field.setAccessible(true);
            BasicComboBoxUI ui = (BasicComboBoxUI)field.get(this.comboBox);
            field = BasicComboBoxUI.class.getDeclaredField("listBox");
            field.setAccessible(true);
            listBox = (JList)field.get(ui);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        return listBox;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        if (this.hitBackspace) {
            this.hitBackspace = false;
            if (offs > 0) {
                if (this.hitBackspaceOnSelection) {
                    --offs;
                    ++len;
                }
                super.remove(offs, len);
                Object item = this.lookupItem(this.getText(0, this.getLength()));
                boolean listContainsSelectedItem = true;
                if (item == null) {
                    item = this.getText(0, this.getLength());
                    listContainsSelectedItem = false;
                }
                this.setSelectedItem(item);
                this.setText(item.toString());
                if (listContainsSelectedItem) {
                    this.highlightCompletedText(offs);
                } else {
                    this.editor.setCaretPosition(offs);
                }
            } else {
                super.remove(offs, len);
            }
        } else if (this.hitDelete) {
            this.hitDelete = false;
            super.remove(offs, len);
            Object item = this.binaryLookup(this.getText(0, this.getLength()), true);
            boolean listContainsSelectedItem = true;
            if (item == null) {
                item = this.getText(0, this.getLength());
                listContainsSelectedItem = false;
            }
            this.setSelectedItem(item);
            this.setText(item.toString());
        } else {
            super.remove(offs, len);
        }
    }

    String filter(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char bit = str.charAt(i);
            if (this.criteria.substring(0, 1).equals("1") && bit >= 'A' && bit <= 'Z') {
                sb.append(bit);
            }
            if (this.criteria.substring(1, 2).equals("1") && bit >= 'a' && bit <= 'z') {
                sb.append(bit);
            }
            if (this.criteria.substring(2, 3).equals("1") && bit >= '0' && bit <= '9') {
                sb.append(bit);
            }
            if (!this.criteria.substring(3, 4).equals("1") || bit != ' ') continue;
            sb.append(bit);
        }
        return sb.toString();
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        str = this.filter(str);
        String string = str = this.ucase ? str.toUpperCase() : str;
        if (this.selecting || this.cap > 0 && this.getLength() >= this.cap || str.length() == 0) {
            return;
        }
        super.insertString(offs, str, a);
        Object item = this.lookupItem(this.getText(0, this.getLength()));
        boolean listContainsSelectedItem = true;
        if (item == null) {
            item = this.getText(0, this.getLength());
            listContainsSelectedItem = false;
        }
        if (offs + 1 == item.toString().length() || item.toString().equals(str)) {
            this.setSelectedItem(item);
        } else {
            this.setSelectedItem(-1);
        }
        this.setText(item.toString());
        if (listContainsSelectedItem) {
            this.highlightCompletedText(offs + str.length());
        } else {
            this.editor.setCaretPosition(offs + str.length());
        }
    }

    private void setText(String text) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void highlightCompletedText(int start) {
        this.editor.setCaretPosition(this.editor.getText().length());
        this.editor.moveCaretPosition(start);
    }

    private void setSelectedItem(Object item) {
        this.selecting = true;
        this.model.setSelectedItem(item);
        InsuredOld topFrame = (InsuredOld)SwingUtilities.getWindowAncestor(this.comboBox);
        topFrame.partial(this.editor.getText(), this.comboBox);
        this.selecting = false;
    }

    void populateComboBox(String search) {
        for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
            if (!search.equals(this.comboBox.getItemAt(i))) continue;
            this.comboBox.setSelectedIndex(i);
            break;
        }
    }

    private Object binaryLookup(String pattern, boolean boo) {
        int i;
        int compare;
        int top;
        int bottom = 0;
        int topInit = top = this.model.getSize() - 1;
        int pos = 0;
        Object item = null;
        while (bottom <= top && (compare = S20BinaryLookup.compareStartIgnoreCase((item = (Object)this.model.getElementAt(pos = bottom + top >> 1)).toString(), pattern)) != 0) {
            if (compare > 0) {
                bottom = pos + 1;
                continue;
            }
            top = pos - 1;
        }
        if (bottom > top) {
            return null;
        }
        if (!boo) {
            for (i = bottom; i <= pos; ++i) {
                Object anItem = this.model.getElementAt(i);
                if (!this.startsWithIgnoreCase(anItem.toString(), pattern)) continue;
                return anItem;
            }
        } else {
            for (i = bottom; i <= topInit; ++i) {
                Object anItem = this.model.getElementAt(i);
                if (!anItem.toString().equals(pattern)) continue;
                return anItem;
            }
            return null;
        }
        return item;
    }

    private Object lookupItem(String pattern) {
        Object selectedItem = this.model.getSelectedItem();
        Object item = this.binaryLookup(pattern, false);
        return item;
    }

    private boolean startsWithIgnoreCase(String str1, String str2) {
        return str1.startsWith(str2);
    }

    private static int compareStartIgnoreCase(String str1, String str2) {
        int n;
        char[] ch1 = str1.toCharArray();
        char[] ch2 = str2.toCharArray();
        int n2 = n = ch2.length < ch1.length ? ch2.length : ch1.length;
        for (int i = 0; i < n; ++i) {
            int diff = ch2[i] - ch1[i];
            if (diff == 0) continue;
            return diff;
        }
        if (ch1.length < ch2.length) {
            return 1;
        }
        return 0;
    }

    private static void createAndShowGUI() {
        Object[] items = new Object[]{"Jordi", "Jordina", "Ester", "Jorge", "JNrre", "Jnrre", "JOrre", "Jpr", "J.pr", "J-pr"};
        Arrays.sort(items);
        JComboBox<Object> comboBox = new JComboBox<Object>(items);
        comboBox.setEditable(true);
        new S20BinaryLookup(comboBox, "111", 0, false);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(comboBox);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                S20BinaryLookup.createAndShowGUI();
            }
        });
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        boolean a = true;
        super.addDocumentListener(listener);
    }
}

