/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HorizBagLayout
implements LayoutManager {
    int hgap;

    public HorizBagLayout() {
        this(0);
    }

    public HorizBagLayout(int n) {
        this.hgap = n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        for (int i = 0; i < container.countComponents(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.minimumSize();
            dimension.width += dimension2.width + this.hgap;
            dimension.height = Math.max(dimension2.height, dimension.height);
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        for (int i = 0; i < container.countComponents(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.preferredSize();
            dimension.width += dimension2.width + this.hgap;
            dimension.height = Math.max(dimension.height, dimension2.height);
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n = insets.top;
        int n2 = container.size().height - insets.bottom;
        int n3 = insets.left;
        int n4 = container.size().width - insets.right;
        for (int i = 0; i < container.countComponents(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            int n5 = component.size().width;
            component.resize(n5, n2 - n);
            Dimension dimension = component.preferredSize();
            component.reshape(n3, n, dimension.width, n2 - n);
            n3 += dimension.width + this.hgap;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + "]";
    }
}

