/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.web.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.skin.FXVK;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import com.sun.javafx.scene.web.behavior.HTMLEditorBehavior;
import com.sun.javafx.scene.web.skin.ColorPicker;
import com.sun.javafx.scene.web.skin.PopupButton;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.platform.event.WCFocusEvent;
import com.sun.webpane.sg.Accessor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.web.HTMLEditor;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;

public class HTMLEditorSkin
extends SkinBase<HTMLEditor, HTMLEditorBehavior>
implements TraverseListener {
    private GridPane gridPane;
    private ToolBar toolbar1;
    private ToolBar toolbar2;
    private Button cutButton;
    private Button copyButton;
    private Button pasteButton;
    private Button insertHorizontalRuleButton;
    private ToggleGroup alignmentToggleGroup;
    private ToggleButton alignLeftButton;
    private ToggleButton alignCenterButton;
    private ToggleButton alignRightButton;
    private ToggleButton alignJustifyButton;
    private ToggleButton bulletsButton;
    private ToggleButton numbersButton;
    private Button indentButton;
    private Button outdentButton;
    private ComboBox formatComboBox;
    private Map<String, String> formatStyleMap;
    private Map<String, String> styleFormatMap;
    private ComboBox fontFamilyComboBox;
    private ComboBox fontSizeComboBox;
    private Map<String, String> fontSizeMap;
    private Map<String, String> sizeFontMap;
    private ToggleButton boldButton;
    private ToggleButton italicButton;
    private ToggleButton underlineButton;
    private ToggleButton strikethroughButton;
    private PopupButton fgColorButton;
    private PopupButton bgColorButton;
    private ColorPicker fgColorPicker;
    private ColorPicker bgColorPicker;
    private Rectangle fgColorRect;
    private Rectangle bgColorRect;
    private WebView webView;
    private WebPage webPage;
    public static final String CUT_COMMAND = "cut";
    public static final String COPY_COMMAND = "copy";
    public static final String PASTE_COMMAND = "paste";
    public static final String UNDO_COMMAND = "undo";
    public static final String REDO_COMMAND = "redo";
    public static final String INSERT_HORIZONTAL_RULE_COMMAND = "inserthorizontalrule";
    public static final String ALIGN_LEFT_COMMAND = "justifyleft";
    public static final String ALIGN_CENTER_COMMAND = "justifycenter";
    public static final String ALIGN_RIGHT_COMMAND = "justifyright";
    public static final String ALIGN_JUSTIFY_COMMAND = "justifyfull";
    public static final String BULLETS_COMMAND = "insertUnorderedList";
    public static final String NUMBERS_COMMAND = "insertOrderedList";
    public static final String INDENT_COMMAND = "indent";
    public static final String OUTDENT_COMMAND = "outdent";
    public static final String FORMAT_COMMAND = "formatblock";
    public static final String FONT_FAMILY_COMMAND = "fontname";
    public static final String FONT_SIZE_COMMAND = "fontsize";
    public static final String BOLD_COMMAND = "bold";
    public static final String ITALIC_COMMAND = "italic";
    public static final String UNDERLINE_COMMAND = "underline";
    public static final String STRIKETHROUGH_COMMAND = "strikethrough";
    public static final String FOREGROUND_COLOR_COMMAND = "forecolor";
    public static final String BACKGROUND_COLOR_COMMAND = "backcolor";
    private static final Color DEFAULT_BG_COLOR = Color.WHITE;
    private static final Color DEFAULT_FG_COLOR = Color.BLACK;
    private static final String FORMAT_PARAGRAPH = "<p>";
    private static final String FORMAT_HEADING_1 = "<h1>";
    private static final String FORMAT_HEADING_2 = "<h2>";
    private static final String FORMAT_HEADING_3 = "<h3>";
    private static final String FORMAT_HEADING_4 = "<h4>";
    private static final String FORMAT_HEADING_5 = "<h5>";
    private static final String FORMAT_HEADING_6 = "<h6>";
    private static final String SIZE_XX_SMALL = "1";
    private static final String SIZE_X_SMALL = "2";
    private static final String SIZE_SMALL = "3";
    private static final String SIZE_MEDIUM = "4";
    private static final String SIZE_LARGE = "5";
    private static final String SIZE_X_LARGE = "6";
    private static final String SIZE_XX_LARGE = "7";
    private static final String INSERT_NEW_LINE_COMMAND = "insertnewline";
    private static final String INSERT_TAB_COMMAND = "inserttab";
    private static final String[][] DEFAULT_FORMAT_MAPPINGS = new String[][]{{"<p>", "", "3"}, {"<h1>", "bold", "6"}, {"<h2>", "bold", "5"}, {"<h3>", "bold", "4"}, {"<h4>", "bold", "3"}, {"<h5>", "bold", "2"}, {"<h6>", "bold", "1"}};
    private static final String[] DEFAULT_WINDOWS_7_MAPPINGS = new String[]{"Windows 7", "Segoe UI", "12px", "", "120"};
    private static final String[][] DEFAULT_OS_MAPPINGS = new String[][]{{"Windows XP", "Tahoma", "12px", "", "96"}, {"Windows Vista", "Segoe UI", "12px", "", "96"}, DEFAULT_WINDOWS_7_MAPPINGS, {"Mac OS X", "Lucida Grande", "12px", "", "72"}, {"Linux", "Lucida Sans", "12px", "", "96"}};
    private static final String DEFAULT_OS_FONT = HTMLEditorSkin.getOSMappings()[1];
    private TraversalEngine engine;
    private boolean resetToolbarState = false;
    private boolean formatChanged = false;
    private String cachedHTMLText = "<html><body></body></html>";
    ResourceBundle resources;
    private static final int FORMAT_MENUBUTTON_WIDTH = 100;
    private static final int FONT_FAMILY_MENUBUTTON_WIDTH = 150;
    private static final int FONT_FAMILY_MENU_WIDTH = 100;
    private static final int FONT_FAMILY_MENUBUTTON_HEIGHT = 21;
    private static final int FONT_SIZE_MENUBUTTON_WIDTH = 80;

    private static String[] getOSMappings() {
        String string = System.getProperty("os.name");
        for (int i = 0; i < DEFAULT_OS_MAPPINGS.length; ++i) {
            if (!string.equals(DEFAULT_OS_MAPPINGS[i][0])) continue;
            return DEFAULT_OS_MAPPINGS[i];
        }
        return DEFAULT_WINDOWS_7_MAPPINGS;
    }

    public HTMLEditorSkin(HTMLEditor hTMLEditor) {
        super(hTMLEditor, new HTMLEditorBehavior(hTMLEditor));
        this.getChildren().clear();
        this.gridPane = new GridPane();
        this.gridPane.getStyleClass().add("html-editor");
        this.getChildren().addAll((Node[])new Node[]{this.gridPane});
        this.toolbar1 = new ToolBar();
        this.toolbar1.getStyleClass().add("top-toolbar");
        this.gridPane.add(this.toolbar1, 0, 0);
        this.toolbar2 = new ToolBar();
        this.toolbar2.getStyleClass().add("bottom-toolbar");
        this.gridPane.add(this.toolbar2, 0, 1);
        this.populateToolbars();
        this.webView = new WebView();
        this.gridPane.add(this.webView, 0, 2);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().add(columnConstraints);
        this.webPage = Accessor.getPageFor(this.webView.getEngine());
        this.webView.addEventHandler(MouseEvent.ANY, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        HTMLEditorSkin.this.updateToolbarState(true);
                    }
                });
            }
        });
        this.webView.addEventHandler(KeyEvent.KEY_PRESSED, new EventHandler<KeyEvent>(){

            @Override
            public void handle(final KeyEvent keyEvent) {
                HTMLEditorSkin.this.applyTextFormatting();
                if (keyEvent.getCode() == KeyCode.CONTROL || keyEvent.getCode() == KeyCode.META) {
                    return;
                }
                if (keyEvent.getCode() == KeyCode.TAB && !keyEvent.isControlDown()) {
                    if (!keyEvent.isShiftDown()) {
                        if (HTMLEditorSkin.this.getCommandState(HTMLEditorSkin.BULLETS_COMMAND) || HTMLEditorSkin.this.getCommandState(HTMLEditorSkin.NUMBERS_COMMAND)) {
                            HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.INDENT_COMMAND, null);
                        } else {
                            HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.INSERT_TAB_COMMAND, null);
                        }
                    } else if (HTMLEditorSkin.this.getCommandState(HTMLEditorSkin.BULLETS_COMMAND) || HTMLEditorSkin.this.getCommandState(HTMLEditorSkin.NUMBERS_COMMAND)) {
                        HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.OUTDENT_COMMAND, null);
                    }
                    return;
                }
                if (HTMLEditorSkin.this.fgColorButton != null && HTMLEditorSkin.this.fgColorButton.isShowing() || HTMLEditorSkin.this.bgColorButton != null && HTMLEditorSkin.this.bgColorButton.isShowing()) {
                    return;
                }
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        if (HTMLEditorSkin.this.webPage.getClientSelectedText().isEmpty()) {
                            if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN || keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.HOME || keyEvent.getCode() == KeyCode.END) {
                                HTMLEditorSkin.this.updateToolbarState(true);
                            } else if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                                if (keyEvent.getCode() == KeyCode.B) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.BOLD_COMMAND);
                                } else if (keyEvent.getCode() == KeyCode.I) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.ITALIC_COMMAND);
                                } else if (keyEvent.getCode() == KeyCode.U) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.UNDERLINE_COMMAND);
                                }
                                HTMLEditorSkin.this.updateToolbarState(true);
                            } else {
                                HTMLEditorSkin.this.resetToolbarState = keyEvent.getCode() == KeyCode.ENTER;
                                if (HTMLEditorSkin.this.resetToolbarState && HTMLEditorSkin.this.getCommandState(HTMLEditorSkin.BOLD_COMMAND) != HTMLEditorSkin.this.boldButton.selectedProperty().getValue()) {
                                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.BOLD_COMMAND, HTMLEditorSkin.this.boldButton.selectedProperty().getValue().toString());
                                }
                                HTMLEditorSkin.this.updateToolbarState(false);
                            }
                            HTMLEditorSkin.this.resetToolbarState = false;
                        } else if (keyEvent.isShiftDown() && (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN || keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.RIGHT)) {
                            HTMLEditorSkin.this.updateToolbarState(true);
                        }
                    }
                });
            }
        });
        this.webView.addEventHandler(KeyEvent.KEY_RELEASED, new EventHandler<KeyEvent>(){

            @Override
            public void handle(final KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.CONTROL || keyEvent.getCode() == KeyCode.META) {
                    return;
                }
                if (HTMLEditorSkin.this.fgColorButton != null && HTMLEditorSkin.this.fgColorButton.isShowing() || HTMLEditorSkin.this.bgColorButton != null && HTMLEditorSkin.this.bgColorButton.isShowing()) {
                    return;
                }
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        if (HTMLEditorSkin.this.webPage.getClientSelectedText().isEmpty()) {
                            if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN || keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.HOME || keyEvent.getCode() == KeyCode.END) {
                                HTMLEditorSkin.this.updateToolbarState(true);
                            } else if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                                if (keyEvent.getCode() == KeyCode.B) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.BOLD_COMMAND);
                                } else if (keyEvent.getCode() == KeyCode.I) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.ITALIC_COMMAND);
                                } else if (keyEvent.getCode() == KeyCode.U) {
                                    HTMLEditorSkin.this.keyboardShortcuts(HTMLEditorSkin.UNDERLINE_COMMAND);
                                }
                                HTMLEditorSkin.this.updateToolbarState(true);
                            } else {
                                HTMLEditorSkin.this.resetToolbarState = keyEvent.getCode() == KeyCode.ENTER;
                                if (!HTMLEditorSkin.this.resetToolbarState) {
                                    HTMLEditorSkin.this.updateToolbarState(false);
                                }
                            }
                            HTMLEditorSkin.this.resetToolbarState = false;
                        }
                    }
                });
            }
        });
        ((HTMLEditor)this.getSkinnable()).focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, final Boolean bl2) {
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        if (bl2.booleanValue()) {
                            HTMLEditorSkin.this.webView.requestFocus();
                        }
                    }
                });
            }
        });
        this.webView.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, final Boolean bl2) {
                if (bl2.booleanValue()) {
                    HTMLEditorSkin.this.webPage.dispatchFocusEvent(new WCFocusEvent(2, 0));
                    HTMLEditorSkin.this.enableToolbar(true);
                } else {
                    HTMLEditorSkin.this.webPage.dispatchFocusEvent(new WCFocusEvent(3, 0));
                    HTMLEditorSkin.this.enableToolbar(false);
                }
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        HTMLEditorSkin.this.updateToolbarState(true);
                    }
                });
                if (PlatformUtil.isEmbedded()) {
                    Platform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            if (bl2.booleanValue()) {
                                FXVK.attach(HTMLEditorSkin.this.webView);
                            } else if (HTMLEditorSkin.this.getScene() == null || HTMLEditorSkin.this.getScene().getWindow() == null || !HTMLEditorSkin.this.getScene().getWindow().isFocused() || !(HTMLEditorSkin.this.getScene().getFocusOwner() instanceof TextInputControl)) {
                                FXVK.detach();
                            }
                        }
                    });
                }
            }
        });
        this.webView.getEngine().getLoadWorker().workDoneProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        HTMLEditorSkin.this.webView.requestLayout();
                    }
                });
                double d = HTMLEditorSkin.this.webView.getEngine().getLoadWorker().getTotalWork();
                if (number2.doubleValue() == d) {
                    HTMLEditorSkin.this.cachedHTMLText = null;
                    Platform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            HTMLEditorSkin.this.setContentEditable(true);
                            HTMLEditorSkin.this.updateToolbarState(true);
                        }
                    });
                }
            }
        });
        this.enableToolbar(true);
        this.setHTMLText(this.cachedHTMLText);
        this.engine = new TraversalEngine(this, false);
        this.engine.addTraverseListener(this);
        this.engine.reg(this.toolbar1);
        this.setImpl_traversalEngine(this.engine);
        this.webView.setFocusTraversable(true);
    }

    public final String getHTMLText() {
        return this.cachedHTMLText != null ? this.cachedHTMLText : this.webPage.getHtml(this.webPage.getMainFrame());
    }

    public final void setHTMLText(String string) {
        this.cachedHTMLText = string;
        this.webPage.load(this.webPage.getMainFrame(), string, "text/html");
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                HTMLEditorSkin.this.updateToolbarState(true);
            }
        });
    }

    private void populateToolbars() {
        this.resources = ResourceBundle.getBundle(this.getClass().getName());
        this.cutButton = this.addButton(this.toolbar1, this.resources.getString("cutIcon"), this.resources.getString(CUT_COMMAND), CUT_COMMAND);
        this.copyButton = this.addButton(this.toolbar1, this.resources.getString("copyIcon"), this.resources.getString(COPY_COMMAND), COPY_COMMAND);
        this.pasteButton = this.addButton(this.toolbar1, this.resources.getString("pasteIcon"), this.resources.getString(PASTE_COMMAND), PASTE_COMMAND);
        this.toolbar1.getItems().add(new Separator());
        this.alignmentToggleGroup = new ToggleGroup();
        this.alignLeftButton = this.addToggleButton(this.toolbar1, this.alignmentToggleGroup, this.resources.getString("alignLeftIcon"), this.resources.getString("alignLeft"), ALIGN_LEFT_COMMAND);
        this.alignCenterButton = this.addToggleButton(this.toolbar1, this.alignmentToggleGroup, this.resources.getString("alignCenterIcon"), this.resources.getString("alignCenter"), ALIGN_CENTER_COMMAND);
        this.alignRightButton = this.addToggleButton(this.toolbar1, this.alignmentToggleGroup, this.resources.getString("alignRightIcon"), this.resources.getString("alignRight"), ALIGN_RIGHT_COMMAND);
        this.alignJustifyButton = this.addToggleButton(this.toolbar1, this.alignmentToggleGroup, this.resources.getString("alignJustifyIcon"), this.resources.getString("alignJustify"), ALIGN_JUSTIFY_COMMAND);
        this.toolbar1.getItems().add(new Separator());
        this.outdentButton = this.addButton(this.toolbar1, this.resources.getString("outdentIcon"), this.resources.getString(OUTDENT_COMMAND), OUTDENT_COMMAND);
        this.indentButton = this.addButton(this.toolbar1, this.resources.getString("indentIcon"), this.resources.getString(INDENT_COMMAND), INDENT_COMMAND);
        this.toolbar1.getItems().add(new Separator());
        ToggleGroup toggleGroup = new ToggleGroup();
        this.bulletsButton = this.addToggleButton(this.toolbar1, toggleGroup, this.resources.getString("bulletsIcon"), this.resources.getString("bullets"), BULLETS_COMMAND);
        this.numbersButton = this.addToggleButton(this.toolbar1, toggleGroup, this.resources.getString("numbersIcon"), this.resources.getString("numbers"), NUMBERS_COMMAND);
        this.toolbar1.getItems().add(new Separator());
        this.formatComboBox = new ComboBox();
        this.formatComboBox.getStyleClass().add("font-menu-button");
        this.formatComboBox.setMinWidth(100.0);
        this.formatComboBox.setPrefWidth(100.0);
        this.formatComboBox.setMaxWidth(100.0);
        this.formatComboBox.setFocusTraversable(false);
        this.toolbar2.getItems().add(this.formatComboBox);
        this.formatStyleMap = new HashMap<String, String>();
        this.styleFormatMap = new HashMap<String, String>();
        this.createFormatMenuItem(FORMAT_PARAGRAPH, this.resources.getString("paragraph"));
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                HTMLEditorSkin.this.formatComboBox.setValue(HTMLEditorSkin.this.resources.getString("paragraph"));
            }
        });
        this.createFormatMenuItem(FORMAT_HEADING_1, this.resources.getString("heading1"));
        this.createFormatMenuItem(FORMAT_HEADING_2, this.resources.getString("heading2"));
        this.createFormatMenuItem(FORMAT_HEADING_3, this.resources.getString("heading3"));
        this.createFormatMenuItem(FORMAT_HEADING_4, this.resources.getString("heading4"));
        this.createFormatMenuItem(FORMAT_HEADING_5, this.resources.getString("heading5"));
        this.createFormatMenuItem(FORMAT_HEADING_6, this.resources.getString("heading6"));
        this.formatComboBox.setCellFactory(new Callback<ListView<String>, ListCell<String>>(){

            @Override
            public ListCell<String> call(ListView<String> listView) {
                ListCell<String> listCell = new ListCell<String>(){

                    @Override
                    public void updateItem(String string, boolean bl) {
                        super.updateItem(string, bl);
                        if (string != null) {
                            this.setText(string);
                        }
                    }
                };
                return listCell;
            }
        });
        this.formatComboBox.setTooltip(new Tooltip(this.resources.getString("format")));
        this.formatComboBox.valueProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (string2 == null) {
                    HTMLEditorSkin.this.formatComboBox.setValue(null);
                } else {
                    HTMLEditorSkin.this.formatChanged = true;
                    String string3 = (String)HTMLEditorSkin.this.formatStyleMap.get(string2);
                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.FORMAT_COMMAND, string3);
                    HTMLEditorSkin.this.updateToolbarState(false);
                    for (int i = 0; i < DEFAULT_FORMAT_MAPPINGS.length; ++i) {
                        String[] stringArray = DEFAULT_FORMAT_MAPPINGS[i];
                        if (!stringArray[0].equalsIgnoreCase(string3)) continue;
                        HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.FONT_SIZE_COMMAND, stringArray[2]);
                        HTMLEditorSkin.this.updateToolbarState(false);
                        break;
                    }
                }
            }
        });
        this.fontFamilyComboBox = new ComboBox();
        this.fontFamilyComboBox.getStyleClass().add("font-menu-button");
        this.fontFamilyComboBox.setMinWidth(150.0);
        this.fontFamilyComboBox.setPrefWidth(150.0);
        this.fontFamilyComboBox.setMaxWidth(150.0);
        this.fontFamilyComboBox.setMaxHeight(21.0);
        this.fontFamilyComboBox.setPrefHeight(21.0);
        this.fontFamilyComboBox.setMinHeight(21.0);
        this.fontFamilyComboBox.setFocusTraversable(false);
        this.fontFamilyComboBox.setTooltip(new Tooltip(this.resources.getString("fontFamily")));
        this.toolbar2.getItems().add(this.fontFamilyComboBox);
        this.fontFamilyComboBox.setCellFactory(new Callback<ListView<String>, ListCell<String>>(){

            @Override
            public ListCell<String> call(ListView<String> listView) {
                ListCell<String> listCell = new ListCell<String>(){

                    @Override
                    public void updateItem(String string, boolean bl) {
                        super.updateItem(string, bl);
                        if (string != null) {
                            this.setText(string);
                        }
                    }
                };
                listCell.setMinWidth(100.0);
                listCell.setPrefWidth(100.0);
                listCell.setMaxWidth(100.0);
                return listCell;
            }
        });
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                ObservableList<String> observableList = FXCollections.observableArrayList(Font.getFamilies());
                for (String string : observableList) {
                    if (DEFAULT_OS_FONT.equals(string)) {
                        HTMLEditorSkin.this.fontFamilyComboBox.setValue(string);
                    }
                    HTMLEditorSkin.this.fontFamilyComboBox.setItems(observableList);
                }
            }
        });
        this.fontFamilyComboBox.valueProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.FONT_FAMILY_COMMAND, string2);
            }
        });
        this.fontSizeComboBox = new ComboBox();
        this.fontSizeComboBox.getStyleClass().add("font-menu-button");
        this.fontSizeComboBox.setMinWidth(80.0);
        this.fontSizeComboBox.setPrefWidth(80.0);
        this.fontSizeComboBox.setMaxWidth(80.0);
        this.fontSizeComboBox.setFocusTraversable(false);
        this.toolbar2.getItems().add(this.fontSizeComboBox);
        this.fontSizeMap = new HashMap<String, String>();
        this.sizeFontMap = new HashMap<String, String>();
        ObservableList observableList = this.fontSizeComboBox.getItems();
        this.createFontSizeMenuItem(SIZE_XX_SMALL, this.resources.getString("extraExtraSmall"));
        this.createFontSizeMenuItem(SIZE_X_SMALL, this.resources.getString("extraSmall"));
        this.createFontSizeMenuItem(SIZE_SMALL, this.resources.getString("small"));
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                HTMLEditorSkin.this.fontSizeComboBox.setValue(HTMLEditorSkin.this.resources.getString("small"));
            }
        });
        this.createFontSizeMenuItem(SIZE_MEDIUM, this.resources.getString("medium"));
        this.createFontSizeMenuItem(SIZE_LARGE, this.resources.getString("large"));
        this.createFontSizeMenuItem(SIZE_X_LARGE, this.resources.getString("extraLarge"));
        this.createFontSizeMenuItem(SIZE_XX_LARGE, this.resources.getString("extraExtraLarge"));
        this.fontSizeComboBox.setTooltip(new Tooltip(this.resources.getString("fontSize")));
        this.fontSizeComboBox.setCellFactory(new Callback<ListView<String>, ListCell<String>>(){

            @Override
            public ListCell<String> call(ListView<String> listView) {
                ListCell<String> listCell = new ListCell<String>(){

                    @Override
                    public void updateItem(String string, boolean bl) {
                        super.updateItem(string, bl);
                        if (string != null) {
                            this.setText(string);
                        }
                    }
                };
                return listCell;
            }
        });
        this.fontSizeComboBox.valueProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                String string3 = HTMLEditorSkin.this.getCommandValue(HTMLEditorSkin.FONT_SIZE_COMMAND);
                if (!string2.equals(string3)) {
                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.FONT_SIZE_COMMAND, (String)HTMLEditorSkin.this.fontSizeMap.get(string2));
                }
            }
        });
        this.toolbar2.getItems().add(new Separator());
        this.boldButton = this.addToggleButton(this.toolbar2, null, this.resources.getString("boldIcon"), this.resources.getString(BOLD_COMMAND), BOLD_COMMAND);
        this.boldButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                if (HTMLEditorSkin.FORMAT_PARAGRAPH.equals(HTMLEditorSkin.this.formatStyleMap.get(HTMLEditorSkin.this.formatComboBox.getValue()))) {
                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.BOLD_COMMAND, HTMLEditorSkin.this.boldButton.selectedProperty().getValue().toString());
                }
            }
        });
        this.italicButton = this.addToggleButton(this.toolbar2, null, this.resources.getString("italicIcon"), this.resources.getString(ITALIC_COMMAND), ITALIC_COMMAND);
        this.underlineButton = this.addToggleButton(this.toolbar2, null, this.resources.getString("underlineIcon"), this.resources.getString(UNDERLINE_COMMAND), UNDERLINE_COMMAND);
        this.strikethroughButton = this.addToggleButton(this.toolbar2, null, this.resources.getString("strikethroughIcon"), this.resources.getString(STRIKETHROUGH_COMMAND), STRIKETHROUGH_COMMAND);
        this.toolbar2.getItems().add(new Separator());
        this.insertHorizontalRuleButton = this.addButton(this.toolbar2, this.resources.getString("insertHorizontalRuleIcon"), this.resources.getString("insertHorizontalRule"), INSERT_HORIZONTAL_RULE_COMMAND);
        this.insertHorizontalRuleButton.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.INSERT_NEW_LINE_COMMAND, null);
                HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.INSERT_HORIZONTAL_RULE_COMMAND, null);
                HTMLEditorSkin.this.updateToolbarState(false);
            }
        });
        this.fgColorButton = new PopupButton();
        this.fgColorButton.setFocusTraversable(false);
        this.toolbar1.getItems().add(this.fgColorButton);
        Image image = AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return new Image(HTMLEditorSkin.class.getResource(HTMLEditorSkin.this.resources.getString("foregroundColorIcon")).toString());
            }
        });
        this.fgColorRect = new Rectangle(0.0, 10.0, 16.0, 5.0);
        Group group = new Group();
        group.getChildren().addAll((Node[])new Node[]{this.fgColorRect, new ImageView(image)});
        this.fgColorButton.setGraphic(group);
        this.fgColorPicker = new ColorPicker();
        this.fgColorPicker.setColor(DEFAULT_FG_COLOR);
        this.fgColorButton.setContent(this.fgColorPicker);
        this.fgColorButton.setTooltip(new Tooltip(this.resources.getString("foregroundColor")));
        this.fgColorPicker.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                Color color = HTMLEditorSkin.this.fgColorPicker.getColor();
                if (color != null) {
                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.FOREGROUND_COLOR_COMMAND, ColorPicker.colorValueToHex(color));
                    HTMLEditorSkin.this.fgColorButton.hide();
                    HTMLEditorSkin.this.fgColorRect.setFill(color);
                }
            }
        });
        this.bgColorButton = new PopupButton();
        this.bgColorButton.setFocusTraversable(false);
        this.toolbar1.getItems().add(this.bgColorButton);
        Image image2 = AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return new Image(HTMLEditorSkin.class.getResource(HTMLEditorSkin.this.resources.getString("backgroundColorIcon")).toString());
            }
        });
        this.bgColorRect = new Rectangle(0.0, 10.0, 16.0, 5.0);
        this.bgColorRect.setFill(DEFAULT_BG_COLOR);
        Group group2 = new Group();
        group2.getChildren().addAll((Node[])new Node[]{this.bgColorRect, new ImageView(image2)});
        this.bgColorButton.setGraphic(group2);
        this.bgColorPicker = new ColorPicker();
        this.bgColorPicker.setColor(DEFAULT_BG_COLOR);
        this.bgColorButton.setContent(this.bgColorPicker);
        this.bgColorButton.setTooltip(new Tooltip(this.resources.getString("backgroundColor")));
        this.bgColorPicker.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                Color color = HTMLEditorSkin.this.bgColorPicker.getColor();
                if (color != null) {
                    HTMLEditorSkin.this.executeCommand(HTMLEditorSkin.BACKGROUND_COLOR_COMMAND, ColorPicker.colorValueToHex(color));
                    HTMLEditorSkin.this.bgColorButton.hide();
                    HTMLEditorSkin.this.bgColorRect.setFill(color);
                }
            }
        });
    }

    private Button addButton(ToolBar toolBar, final String string, String string2, final String string3) {
        Button button = new Button();
        button.setFocusTraversable(false);
        toolBar.getItems().add(button);
        Image image = AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return new Image(HTMLEditorSkin.class.getResource(string).toString());
            }
        });
        button.setGraphic(new ImageView(image));
        button.setTooltip(new Tooltip(string2));
        button.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                HTMLEditorSkin.this.executeCommand(string3, null);
                HTMLEditorSkin.this.updateToolbarState(false);
            }
        });
        return button;
    }

    private ToggleButton addToggleButton(ToolBar toolBar, ToggleGroup toggleGroup, final String string, String string2, final String string3) {
        ToggleButton toggleButton = new ToggleButton();
        toggleButton.setUserData(string3);
        toggleButton.setFocusTraversable(false);
        toolBar.getItems().add(toggleButton);
        if (toggleGroup != null) {
            toggleButton.setToggleGroup(toggleGroup);
        }
        Image image = AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return new Image(HTMLEditorSkin.class.getResource(string).toString());
            }
        });
        toggleButton.setGraphic(new ImageView(image));
        toggleButton.setTooltip(new Tooltip(string2));
        if (!BOLD_COMMAND.equals(string3)) {
            toggleButton.selectedProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (HTMLEditorSkin.this.getCommandState(string3) != bl2) {
                        HTMLEditorSkin.this.executeCommand(string3, null);
                    }
                }
            });
        }
        return toggleButton;
    }

    private void createFormatMenuItem(String string, String string2) {
        this.formatComboBox.getItems().add(string2);
        this.formatStyleMap.put(string2, string);
        this.styleFormatMap.put(string, string2);
    }

    private void createFontSizeMenuItem(String string, String string2) {
        this.fontSizeComboBox.getItems().add(string2);
        this.fontSizeMap.put(string2, string);
        this.sizeFontMap.put(string, string2);
    }

    private void updateToolbarState(boolean bl) {
        Object object;
        Object object2;
        Object object3;
        String string;
        String string2;
        String string3;
        if (!this.webView.isFocused()) {
            return;
        }
        this.copyButton.setDisable(!this.isCommandEnabled(CUT_COMMAND));
        this.cutButton.setDisable(!this.isCommandEnabled(COPY_COMMAND));
        this.pasteButton.setDisable(!this.isCommandEnabled(PASTE_COMMAND));
        this.insertHorizontalRuleButton.setDisable(!this.isCommandEnabled(INSERT_HORIZONTAL_RULE_COMMAND));
        if (bl) {
            this.alignLeftButton.setDisable(!this.isCommandEnabled(ALIGN_LEFT_COMMAND));
            this.alignLeftButton.setSelected(this.getCommandState(ALIGN_LEFT_COMMAND));
            this.alignCenterButton.setDisable(!this.isCommandEnabled(ALIGN_CENTER_COMMAND));
            this.alignCenterButton.setSelected(this.getCommandState(ALIGN_CENTER_COMMAND));
            this.alignRightButton.setDisable(!this.isCommandEnabled(ALIGN_RIGHT_COMMAND));
            this.alignRightButton.setSelected(this.getCommandState(ALIGN_RIGHT_COMMAND));
            this.alignJustifyButton.setDisable(!this.isCommandEnabled(ALIGN_JUSTIFY_COMMAND));
            this.alignJustifyButton.setSelected(this.getCommandState(ALIGN_JUSTIFY_COMMAND));
        } else if (this.alignmentToggleGroup.getSelectedToggle() != null && !this.getCommandState(string3 = this.alignmentToggleGroup.getSelectedToggle().getUserData().toString())) {
            this.executeCommand(string3, null);
        }
        if (this.alignmentToggleGroup.getSelectedToggle() == null) {
            this.alignmentToggleGroup.selectToggle(this.alignLeftButton);
        }
        this.bulletsButton.setDisable(!this.isCommandEnabled(BULLETS_COMMAND));
        this.bulletsButton.setSelected(this.getCommandState(BULLETS_COMMAND));
        this.numbersButton.setDisable(!this.isCommandEnabled(NUMBERS_COMMAND));
        this.numbersButton.setSelected(this.getCommandState(NUMBERS_COMMAND));
        this.indentButton.setDisable(!this.isCommandEnabled(INDENT_COMMAND));
        this.outdentButton.setDisable(!this.isCommandEnabled(OUTDENT_COMMAND));
        this.formatComboBox.setDisable(!this.isCommandEnabled(FORMAT_COMMAND));
        string3 = this.getCommandValue(FORMAT_COMMAND);
        if (string3 instanceof String) {
            string2 = "<" + string3 + ">";
            string = this.styleFormatMap.get(string2);
            if (this.resetToolbarState || string2.equals("<>") || string2.equalsIgnoreCase("<div>")) {
                this.formatComboBox.setValue(this.resources.getString("paragraph"));
            } else if (!((String)this.formatComboBox.getValue()).equalsIgnoreCase(string)) {
                this.formatComboBox.setValue(string);
            }
        }
        this.fontFamilyComboBox.setDisable(!this.isCommandEnabled(FONT_FAMILY_COMMAND));
        string2 = this.getCommandValue(FONT_FAMILY_COMMAND);
        if (string2 instanceof String) {
            string = string2;
            if (string.startsWith("'")) {
                string = string.substring(1);
            }
            if (string.endsWith("'")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((object3 = this.fontFamilyComboBox.getValue()) instanceof String && !object3.equals(string)) {
                object2 = this.fontFamilyComboBox.getItems();
                object = null;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (string4.equals(string)) {
                        object = string4;
                        break;
                    }
                    if (!string4.equals(DEFAULT_OS_FONT) || !string.equals("Dialog")) continue;
                    object = string4;
                    break;
                }
                if (object != null) {
                    this.fontFamilyComboBox.setValue(object);
                }
            }
        }
        this.fontSizeComboBox.setDisable(!this.isCommandEnabled(FONT_SIZE_COMMAND));
        string = this.getCommandValue(FONT_SIZE_COMMAND);
        if (this.resetToolbarState) {
            this.fontSizeComboBox.setValue(this.sizeFontMap.get(SIZE_SMALL));
        } else if (string instanceof String) {
            if (!this.fontSizeComboBox.getValue().equals(this.sizeFontMap.get(string))) {
                this.fontSizeComboBox.setValue(this.sizeFontMap.get(string));
            }
        } else if (!this.fontSizeComboBox.getValue().equals(this.sizeFontMap.get(SIZE_SMALL))) {
            this.fontSizeComboBox.setValue(this.sizeFontMap.get(SIZE_SMALL));
        }
        this.boldButton.setDisable(!this.isCommandEnabled(BOLD_COMMAND));
        if (string3 instanceof String && !this.resetToolbarState && ("p".equals(string3) || "div".equals(string3))) {
            this.boldButton.setSelected(this.getCommandState(BOLD_COMMAND));
        }
        this.italicButton.setDisable(!this.isCommandEnabled(ITALIC_COMMAND));
        this.italicButton.setSelected(this.getCommandState(ITALIC_COMMAND));
        this.underlineButton.setDisable(!this.isCommandEnabled(UNDERLINE_COMMAND));
        this.underlineButton.setSelected(this.getCommandState(UNDERLINE_COMMAND));
        this.strikethroughButton.setDisable(!this.isCommandEnabled(STRIKETHROUGH_COMMAND));
        this.strikethroughButton.setSelected(this.getCommandState(STRIKETHROUGH_COMMAND));
        this.fgColorButton.setDisable(!this.isCommandEnabled(FOREGROUND_COLOR_COMMAND));
        object3 = this.getCommandValue(FOREGROUND_COLOR_COMMAND);
        if (object3 instanceof String) {
            object2 = Color.web(HTMLEditorSkin.rgbToHex((String)object3));
            this.fgColorPicker.setColor((Color)object2);
            this.fgColorRect.setFill((Paint)object2);
        }
        this.bgColorButton.setDisable(!this.isCommandEnabled(BACKGROUND_COLOR_COMMAND));
        object2 = this.getCommandValue(BACKGROUND_COLOR_COMMAND);
        if (object2 instanceof String) {
            object = Color.web(HTMLEditorSkin.rgbToHex((String)object2));
            this.bgColorPicker.setColor((Color)object);
            this.bgColorRect.setFill((Paint)object);
        }
    }

    private void enableToolbar(final boolean bl) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    HTMLEditorSkin.this.copyButton.setDisable(!HTMLEditorSkin.this.isCommandEnabled(HTMLEditorSkin.COPY_COMMAND));
                    HTMLEditorSkin.this.cutButton.setDisable(!HTMLEditorSkin.this.isCommandEnabled(HTMLEditorSkin.CUT_COMMAND));
                    HTMLEditorSkin.this.pasteButton.setDisable(!HTMLEditorSkin.this.isCommandEnabled(HTMLEditorSkin.PASTE_COMMAND));
                } else {
                    HTMLEditorSkin.this.copyButton.setDisable(true);
                    HTMLEditorSkin.this.cutButton.setDisable(true);
                    HTMLEditorSkin.this.pasteButton.setDisable(true);
                }
                HTMLEditorSkin.this.insertHorizontalRuleButton.setDisable(!bl);
                HTMLEditorSkin.this.alignLeftButton.setDisable(!bl);
                HTMLEditorSkin.this.alignCenterButton.setDisable(!bl);
                HTMLEditorSkin.this.alignRightButton.setDisable(!bl);
                HTMLEditorSkin.this.alignJustifyButton.setDisable(!bl);
                HTMLEditorSkin.this.bulletsButton.setDisable(!bl);
                HTMLEditorSkin.this.numbersButton.setDisable(!bl);
                HTMLEditorSkin.this.indentButton.setDisable(!bl);
                HTMLEditorSkin.this.outdentButton.setDisable(!bl);
                HTMLEditorSkin.this.formatComboBox.setDisable(!bl);
                HTMLEditorSkin.this.fontFamilyComboBox.setDisable(!bl);
                HTMLEditorSkin.this.fontSizeComboBox.setDisable(!bl);
                HTMLEditorSkin.this.boldButton.setDisable(!bl);
                HTMLEditorSkin.this.italicButton.setDisable(!bl);
                HTMLEditorSkin.this.underlineButton.setDisable(!bl);
                HTMLEditorSkin.this.strikethroughButton.setDisable(!bl);
                HTMLEditorSkin.this.fgColorButton.setDisable(!bl);
                HTMLEditorSkin.this.bgColorButton.setDisable(!bl);
            }
        });
    }

    private boolean executeCommand(String string, String string2) {
        return this.webPage.executeCommand(string, string2);
    }

    private boolean isCommandEnabled(String string) {
        return this.webPage.queryCommandEnabled(string);
    }

    private void setContentEditable(boolean bl) {
        HTMLDocument hTMLDocument = (HTMLDocument)this.webPage.getDocument(this.webPage.getMainFrame());
        HTMLElement hTMLElement = (HTMLElement)hTMLDocument.getDocumentElement();
        HTMLElement hTMLElement2 = (HTMLElement)hTMLElement.getElementsByTagName("body").item(0);
        hTMLElement2.setAttribute("contenteditable", Boolean.toString(bl));
    }

    private boolean getCommandState(String string) {
        return this.webPage.queryCommandState(string);
    }

    private String getCommandValue(String string) {
        return this.webPage.queryCommandValue(string);
    }

    private static String rgbToHex(String string) {
        if (string.startsWith("rgba")) {
            String[] stringArray = string.substring(string.indexOf(40) + 1, string.lastIndexOf(41)).split(",");
            string = String.format("#%02X%02X%02X%02X", Integer.parseInt(stringArray[0].trim()), Integer.parseInt(stringArray[1].trim()), Integer.parseInt(stringArray[2].trim()), Integer.parseInt(stringArray[3].trim()));
            if ("#00000000".equals(string)) {
                return "#FFFFFFFF";
            }
        } else if (string.startsWith("rgb")) {
            String[] stringArray = string.substring(string.indexOf(40) + 1, string.lastIndexOf(41)).split(",");
            string = String.format("#%02X%02X%02X", Integer.parseInt(stringArray[0].trim()), Integer.parseInt(stringArray[1].trim()), Integer.parseInt(stringArray[2].trim()));
        }
        return string;
    }

    private void applyTextFormatting() {
        if (this.getCommandState(BULLETS_COMMAND) || this.getCommandState(NUMBERS_COMMAND)) {
            return;
        }
        if (this.webPage.getClientCommittedTextLength() == 0) {
            String string = this.formatStyleMap.get(this.formatComboBox.getValue());
            String string2 = this.fontFamilyComboBox.getValue().toString();
            this.executeCommand(FORMAT_COMMAND, string);
            this.executeCommand(FONT_FAMILY_COMMAND, string2);
        }
    }

    public void keyboardShortcuts(String string) {
        if (BOLD_COMMAND.equals(string)) {
            this.boldButton.fire();
        } else if (ITALIC_COMMAND.equals(string)) {
            this.italicButton.setSelected(!this.italicButton.isSelected());
        } else if (UNDERLINE_COMMAND.equals(string)) {
            this.underlineButton.setSelected(!this.underlineButton.isSelected());
        }
    }

    @Override
    public void onTraverse(Node node, Bounds bounds) {
        this.cutButton.requestFocus();
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        double d = Math.max(this.toolbar1.prefWidth(-1.0), this.toolbar2.prefWidth(-1.0));
        this.toolbar1.setMinWidth(d);
        this.toolbar1.setPrefWidth(d);
        this.toolbar2.setMinWidth(d);
        this.toolbar2.setPrefWidth(d);
    }
}

