/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSManagerImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.ProviderList;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class GSSNameImpl
implements GSSName {
    static final Oid oldHostbasedServiceName;
    private GSSManagerImpl gssManager = null;
    private String appNameStr = null;
    private byte[] appNameBytes = null;
    private Oid appNameType = null;
    private String printableName = null;
    private Oid printableNameType = null;
    private HashMap<Oid, GSSNameSpi> elements = null;
    private GSSNameSpi mechElement = null;

    static GSSNameImpl wrapElement(GSSManagerImpl gSSManagerImpl, GSSNameSpi gSSNameSpi) throws GSSException {
        return gSSNameSpi == null ? null : new GSSNameImpl(gSSManagerImpl, gSSNameSpi);
    }

    GSSNameImpl(GSSManagerImpl gSSManagerImpl, GSSNameSpi gSSNameSpi) {
        this.gssManager = gSSManagerImpl;
        this.appNameStr = this.printableName = gSSNameSpi.toString();
        this.appNameType = this.printableNameType = gSSNameSpi.getStringNameType();
        this.mechElement = gSSNameSpi;
        this.elements = new HashMap(1);
        this.elements.put(gSSNameSpi.getMechanism(), this.mechElement);
    }

    GSSNameImpl(GSSManagerImpl gSSManagerImpl, Object object, Oid oid) throws GSSException {
        this(gSSManagerImpl, object, oid, null);
    }

    GSSNameImpl(GSSManagerImpl gSSManagerImpl, Object object, Oid oid, Oid oid2) throws GSSException {
        if (oldHostbasedServiceName.equals(oid)) {
            oid = GSSName.NT_HOSTBASED_SERVICE;
        }
        if (object == null) {
            throw new GSSExceptionImpl(3, "Cannot import null name");
        }
        if (oid2 == null) {
            oid2 = ProviderList.DEFAULT_MECH_OID;
        }
        if (NT_EXPORT_NAME.equals(oid)) {
            this.importName(gSSManagerImpl, object);
        } else {
            this.init(gSSManagerImpl, object, oid, oid2);
        }
    }

    private void init(GSSManagerImpl gSSManagerImpl, Object object, Oid oid, Oid oid2) throws GSSException {
        this.gssManager = gSSManagerImpl;
        this.elements = new HashMap(gSSManagerImpl.getMechs().length);
        if (object instanceof String) {
            this.appNameStr = (String)object;
            if (oid != null) {
                this.printableName = this.appNameStr;
                this.printableNameType = oid;
            }
        } else {
            this.appNameBytes = (byte[])object;
        }
        this.appNameType = oid;
        this.mechElement = this.getElement(oid2);
        if (this.printableName == null) {
            this.printableName = this.mechElement.toString();
            this.printableNameType = this.mechElement.getStringNameType();
        }
    }

    private void importName(GSSManagerImpl gSSManagerImpl, Object object) throws GSSException {
        Object object2;
        int n = 0;
        byte[] byArray = null;
        if (object instanceof String) {
            try {
                byArray = ((String)object).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            byArray = (byte[])object;
        }
        if (byArray[n++] != 4 || byArray[n++] != 1) {
            throw new GSSExceptionImpl(3, "Exported name token id is corrupted!");
        }
        int n2 = (0xFF & byArray[n++]) << 8 | 0xFF & byArray[n++];
        ObjectIdentifier objectIdentifier = null;
        try {
            object2 = new DerInputStream(byArray, n, n2);
            objectIdentifier = new ObjectIdentifier((DerInputStream)object2);
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(3, "Exported name Object identifier is corrupted!");
        }
        object2 = new Oid(objectIdentifier.toString());
        n += n2;
        int n3 = (0xFF & byArray[n++]) << 24 | (0xFF & byArray[n++]) << 16 | (0xFF & byArray[n++]) << 8 | 0xFF & byArray[n++];
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n3);
        this.init(gSSManagerImpl, byArray2, NT_EXPORT_NAME, (Oid)object2);
    }

    @Override
    public GSSName canonicalize(Oid oid) throws GSSException {
        if (oid == null) {
            oid = ProviderList.DEFAULT_MECH_OID;
        }
        return GSSNameImpl.wrapElement(this.gssManager, this.getElement(oid));
    }

    @Override
    public boolean equals(GSSName gSSName) throws GSSException {
        if (this.isAnonymous() || gSSName.isAnonymous()) {
            return false;
        }
        if (gSSName == this) {
            return true;
        }
        if (!(gSSName instanceof GSSNameImpl)) {
            return this.equals(this.gssManager.createName(gSSName.toString(), gSSName.getStringNameType()));
        }
        GSSNameImpl gSSNameImpl = (GSSNameImpl)gSSName;
        GSSNameSpi gSSNameSpi = this.mechElement;
        GSSNameSpi gSSNameSpi2 = gSSNameImpl.mechElement;
        if (gSSNameSpi == null && gSSNameSpi2 != null) {
            gSSNameSpi = this.getElement(gSSNameSpi2.getMechanism());
        } else if (gSSNameSpi != null && gSSNameSpi2 == null) {
            gSSNameSpi2 = gSSNameImpl.getElement(gSSNameSpi.getMechanism());
        }
        if (gSSNameSpi != null && gSSNameSpi2 != null) {
            return gSSNameSpi.equals(gSSNameSpi2);
        }
        if (this.appNameType != null && gSSNameImpl.appNameType != null) {
            if (!this.appNameType.equals(gSSNameImpl.appNameType)) {
                return false;
            }
            byte[] byArray = null;
            byte[] byArray2 = null;
            try {
                byArray = this.appNameStr != null ? this.appNameStr.getBytes("UTF-8") : this.appNameBytes;
                byArray2 = gSSNameImpl.appNameStr != null ? gSSNameImpl.appNameStr.getBytes("UTF-8") : gSSNameImpl.appNameBytes;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return Arrays.equals(byArray, byArray2);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        try {
            if (object instanceof GSSName) {
                return this.equals((GSSName)object);
            }
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public byte[] export() throws GSSException {
        if (this.mechElement == null) {
            this.mechElement = this.getElement(ProviderList.DEFAULT_MECH_OID);
        }
        byte[] byArray = this.mechElement.export();
        byte[] byArray2 = null;
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier(this.mechElement.getMechanism().toString());
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(11, "Invalid OID String ");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putOID(objectIdentifier);
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(11, "Could not ASN.1 Encode " + objectIdentifier.toString());
        }
        byArray2 = derOutputStream.toByteArray();
        byte[] byArray3 = new byte[4 + byArray2.length + 4 + byArray.length];
        int n = 0;
        byArray3[n++] = 4;
        byArray3[n++] = 1;
        byArray3[n++] = (byte)(byArray2.length >>> 8);
        byArray3[n++] = (byte)byArray2.length;
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        n += byArray2.length;
        byArray3[n++] = (byte)(byArray.length >>> 24);
        byArray3[n++] = (byte)(byArray.length >>> 16);
        byArray3[n++] = (byte)(byArray.length >>> 8);
        byArray3[n++] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray3, n, byArray.length);
        return byArray3;
    }

    @Override
    public String toString() {
        return this.printableName;
    }

    @Override
    public Oid getStringNameType() throws GSSException {
        return this.printableNameType;
    }

    @Override
    public boolean isAnonymous() {
        if (this.printableNameType == null) {
            return false;
        }
        return GSSName.NT_ANONYMOUS.equals(this.printableNameType);
    }

    @Override
    public boolean isMN() {
        return true;
    }

    public synchronized GSSNameSpi getElement(Oid oid) throws GSSException {
        GSSNameSpi gSSNameSpi = this.elements.get(oid);
        if (gSSNameSpi == null) {
            gSSNameSpi = this.appNameStr != null ? this.gssManager.getNameElement(this.appNameStr, this.appNameType, oid) : this.gssManager.getNameElement(this.appNameBytes, this.appNameType, oid);
            this.elements.put(oid, gSSNameSpi);
        }
        return gSSNameSpi;
    }

    Set<GSSNameSpi> getElements() {
        return new HashSet<GSSNameSpi>(this.elements.values());
    }

    private static String getNameTypeStr(Oid oid) {
        if (oid == null) {
            return "(NT is null)";
        }
        if (oid.equals(NT_USER_NAME)) {
            return "NT_USER_NAME";
        }
        if (oid.equals(NT_HOSTBASED_SERVICE)) {
            return "NT_HOSTBASED_SERVICE";
        }
        if (oid.equals(NT_EXPORT_NAME)) {
            return "NT_EXPORT_NAME";
        }
        if (oid.equals(GSSUtil.NT_GSS_KRB5_PRINCIPAL)) {
            return "NT_GSS_KRB5_PRINCIPAL";
        }
        return "Unknown";
    }

    static {
        Oid oid = null;
        try {
            oid = new Oid("1.3.6.1.5.6.2");
        }
        catch (Exception exception) {
            // empty catch block
        }
        oldHostbasedServiceName = oid;
    }
}

