/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.OrderedHashSet;
import com.sun.deploy.util.Property;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLNodeBuilder;
import com.sun.deploy.xml.XMLable;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class ResourcesDesc
implements ResourceType {
    private ArrayList _list = new ArrayList();
    private LaunchDesc _parent = null;
    private boolean _pack200Enabled = false;
    private boolean _versionEnabled = false;
    private int _concurrentDownloads = 0;

    public void setPack200Enabled() {
        this._pack200Enabled = true;
    }

    public void setVersionEnabled() {
        this._versionEnabled = true;
    }

    public boolean isPack200Enabled() {
        if (Config.isJavaVersionAtLeast15()) {
            return this._pack200Enabled;
        }
        return false;
    }

    public boolean isVersionEnabled() {
        return this._versionEnabled;
    }

    public void setConcurrentDownloads(int n) {
        this._concurrentDownloads = n;
    }

    public int getConcurrentDownloads() {
        if (this._concurrentDownloads <= 0) {
            return Property.CONCURRENT_DOWNLOADS_DEF;
        }
        if (this._concurrentDownloads > 10) {
            return 10;
        }
        return this._concurrentDownloads;
    }

    public LaunchDesc getParent() {
        return this._parent;
    }

    void setParent(LaunchDesc launchDesc) {
        this._parent = launchDesc;
        for (int i = 0; i < this._list.size(); ++i) {
            JREDesc jREDesc;
            Object e = this._list.get(i);
            if (!(e instanceof JREDesc) || (jREDesc = (JREDesc)e).getNestedResources() == null) continue;
            jREDesc.getNestedResources().setParent(launchDesc);
        }
    }

    public void addResource(ResourceType resourceType) {
        if (resourceType != null) {
            this._list.add(resourceType);
        }
    }

    boolean isEmpty() {
        return this._list.isEmpty();
    }

    public JREDesc getSelectedJRE() {
        for (int i = 0; i < this._list.size(); ++i) {
            Object e = this._list.get(i);
            if (!(e instanceof JREDesc) || !((JREDesc)e).isSelected()) continue;
            return (JREDesc)e;
        }
        return null;
    }

    public JARDesc[] getLocalJarDescs() {
        ArrayList arrayList = new ArrayList(this._list.size());
        for (int i = 0; i < this._list.size(); ++i) {
            Object e = this._list.get(i);
            if (!(e instanceof JARDesc)) continue;
            arrayList.add(e);
        }
        return this.toJARDescArray(arrayList);
    }

    public ExtensionDesc[] getExtensionDescs() {
        final ArrayList arrayList = new ArrayList();
        ExtensionDesc[] extensionDescArray = new ExtensionDesc[]{};
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                ResourcesDesc.this.addExtToList(arrayList);
            }
        });
        return arrayList.toArray(extensionDescArray);
    }

    public JARDesc[] getEagerOrAllJarDescs(boolean bl) {
        final HashSet hashSet = new HashSet();
        if (!bl) {
            this.visit(new ResourceVisitor(){

                public void visitJARDesc(JARDesc jARDesc) {
                    if (!jARDesc.isLazyDownload() && jARDesc.getPartName() != null) {
                        hashSet.add(jARDesc.getPartName());
                    }
                }
            });
        }
        ArrayList arrayList = new ArrayList();
        this.addJarsToList(arrayList, hashSet, bl, true);
        return this.toJARDescArray(arrayList);
    }

    private void addExtToList(final ArrayList arrayList) {
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                ResourcesDesc resourcesDesc;
                if (extensionDesc.getExtensionDesc() != null && (resourcesDesc = extensionDesc.getExtensionDesc().getResources()) != null) {
                    resourcesDesc.addExtToList(arrayList);
                }
                arrayList.add(extensionDesc);
            }
        });
    }

    private void addJarsToList(final ArrayList arrayList, final HashSet hashSet, final boolean bl, final boolean bl2) {
        this.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
                if (bl || bl2 && !jARDesc.isLazyDownload() || hashSet.contains(jARDesc.getPartName())) {
                    arrayList.add(jARDesc);
                }
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                ResourcesDesc resourcesDesc;
                HashSet hashSet2 = extensionDesc.getExtensionPackages(hashSet, bl2);
                if (extensionDesc.getExtensionDesc() != null && (resourcesDesc = extensionDesc.getExtensionDesc().getResources()) != null) {
                    resourcesDesc.addJarsToList(arrayList, hashSet2, bl, bl2);
                }
            }

            public void visitJREDesc(JREDesc jREDesc) {
                if (jREDesc.isSelected()) {
                    ResourcesDesc resourcesDesc;
                    ResourcesDesc resourcesDesc2 = jREDesc.getNestedResources();
                    if (resourcesDesc2 != null) {
                        resourcesDesc2.addJarsToList(arrayList, hashSet, bl, bl2);
                    }
                    if (jREDesc.getExtensionDesc() != null && (resourcesDesc = jREDesc.getExtensionDesc().getResources()) != null) {
                        resourcesDesc.addJarsToList(arrayList, new HashSet(), bl, bl2);
                    }
                }
            }
        });
    }

    public JARDesc[] getPartJars(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        ArrayList arrayList = new ArrayList();
        this.addJarsToList(arrayList, hashSet, false, false);
        return this.toJARDescArray(arrayList);
    }

    public JARDesc[] getPartJars(String string) {
        return this.getPartJars(new String[]{string});
    }

    public JARDesc[] getResource(final URL uRL, final String string) {
        final JARDesc[] jARDescArray = new JARDesc[1];
        this.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
                if (URLUtil.sameURLs((URL)jARDesc.getLocation(), (URL)uRL)) {
                    VersionString versionString;
                    VersionString versionString2 = versionString = jARDesc.getVersion() != null ? new VersionString(jARDesc.getVersion()) : null;
                    if (string == null && versionString == null) {
                        jARDescArray[0] = jARDesc;
                    } else if (versionString.contains(string)) {
                        jARDescArray[0] = jARDesc;
                    }
                }
            }
        });
        if (jARDescArray[0] == null) {
            return null;
        }
        if (jARDescArray[0].getPartName() != null) {
            return this.getPartJars(jARDescArray[0].getPartName());
        }
        return jARDescArray;
    }

    public JARDesc[] getExtensionPart(URL uRL, String string, String[] stringArray) {
        ExtensionDesc extensionDesc = this.findExtension(uRL, string);
        if (extensionDesc == null) {
            return null;
        }
        ResourcesDesc resourcesDesc = extensionDesc.getExtensionResources();
        if (resourcesDesc == null) {
            return null;
        }
        return resourcesDesc.getPartJars(stringArray);
    }

    private ExtensionDesc findExtension(final URL uRL, final String string) {
        final ExtensionDesc[] extensionDescArray = new ExtensionDesc[1];
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (extensionDescArray[0] == null) {
                    if (URLUtil.sameURLs((URL)extensionDesc.getLocation(), (URL)uRL) && (string == null || new VersionString(string).contains(extensionDesc.getVersion()))) {
                        extensionDescArray[0] = extensionDesc;
                    } else {
                        LaunchDesc launchDesc = extensionDesc.getExtensionDesc();
                        if (launchDesc != null && launchDesc.getResources() != null) {
                            extensionDescArray[0] = launchDesc.getResources().findExtension(uRL, string);
                        }
                    }
                }
            }
        });
        return extensionDescArray[0];
    }

    public JARDesc getProgressJar() {
        final JARDesc[] jARDescArray = new JARDesc[2];
        jARDescArray[0] = null;
        this.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
                if (jARDesc.isProgressJar()) {
                    jARDescArray[0] = jARDesc;
                }
            }
        });
        return jARDescArray[0];
    }

    public JARDesc getMainJar(boolean bl) {
        final JARDesc[] jARDescArray = new JARDesc[2];
        String string = System.getProperty("java.version");
        final VersionID versionID = new VersionID(string);
        this.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
                if (jARDesc.isJavaFile()) {
                    if (jARDescArray[0] == null) {
                        jARDescArray[0] = jARDesc;
                    }
                    if (jARDesc.isMainJarFile()) {
                        jARDescArray[1] = jARDesc;
                    }
                }
            }

            public void visitJREDesc(JREDesc jREDesc) {
                ResourcesDesc resourcesDesc;
                VersionID versionID2 = new VersionID(jREDesc.getVersion());
                if (versionID2.match(versionID) && (resourcesDesc = jREDesc.getNestedResources()) != null) {
                    resourcesDesc.visit(this);
                }
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                ResourcesDesc resourcesDesc;
                LaunchDesc launchDesc;
                if (jARDescArray[1] == null && !extensionDesc.isInstaller() && (launchDesc = extensionDesc.getExtensionDesc()) != null && launchDesc.isLibrary() && (resourcesDesc = launchDesc.getResources()) != null) {
                    resourcesDesc.visit(this);
                }
            }
        });
        JARDesc jARDesc = jARDescArray[0];
        JARDesc jARDesc2 = jARDescArray[1];
        return this._parent.isLibrary() || jARDesc2 == null && bl ? jARDesc : jARDesc2;
    }

    public JARDesc[] getPart(final String string) {
        final ArrayList arrayList = new ArrayList();
        this.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
                if (string.equals(jARDesc.getPartName())) {
                    arrayList.add(jARDesc);
                }
            }
        });
        return this.toJARDescArray(arrayList);
    }

    public JARDesc[] getExtensionPart(final URL uRL, final String string, final String string2) {
        final JARDesc[][] jARDescArray = new JARDesc[1][];
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (URLUtil.sameURLs((URL)extensionDesc.getLocation(), (URL)uRL)) {
                    if (string == null) {
                        if (extensionDesc.getVersion() == null && extensionDesc.getExtensionResources() != null) {
                            jARDescArray[0] = extensionDesc.getExtensionResources().getPart(string2);
                        }
                    } else if (string.equals(extensionDesc.getVersion()) && extensionDesc.getExtensionResources() != null) {
                        jARDescArray[0] = extensionDesc.getExtensionResources().getPart(string2);
                    }
                }
            }
        });
        return jARDescArray[0];
    }

    private JARDesc[] toJARDescArray(ArrayList arrayList) {
        JARDesc[] jARDescArray = new JARDesc[arrayList.size()];
        return arrayList.toArray(jARDescArray);
    }

    public Properties getResourceProperties() {
        final Properties properties = new Properties();
        this.visit(new ResourceVisitor(){

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
                properties.setProperty(propertyDesc.getKey(), propertyDesc.getValue());
            }
        });
        return properties;
    }

    public List getResourcePropertyList() {
        final OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.visit(new ResourceVisitor(){

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
                orderedHashSet.add((Object)new Property(propertyDesc.getKey(), propertyDesc.getValue()));
            }
        });
        return orderedHashSet.toList();
    }

    public PackageInformation getPackageInformation(String string) {
        if ((string = string.replace('/', '.')).endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
        }
        return ResourcesDesc.visitPackageElements(this.getParent(), string);
    }

    public boolean isPackagePart(final String string) {
        final boolean[] blArray = new boolean[]{false};
        this.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (!extensionDesc.isInstaller()) {
                    LaunchDesc launchDesc = extensionDesc.getExtensionDesc();
                    if (!blArray[0] && launchDesc != null && launchDesc.isLibrary() && launchDesc.getResources() != null) {
                        blArray[0] = launchDesc.getResources().isPackagePart(string);
                    }
                }
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
                if (packageDesc.getPart().equals(string)) {
                    blArray[0] = true;
                }
            }
        });
        return blArray[0];
    }

    private static PackageInformation visitPackageElements(final LaunchDesc launchDesc, final String string) {
        final PackageInformation[] packageInformationArray = new PackageInformation[1];
        launchDesc.getResources().visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                if (!extensionDesc.isInstaller()) {
                    LaunchDesc launchDesc2 = extensionDesc.getExtensionDesc();
                    if (packageInformationArray[0] == null && launchDesc2 != null && launchDesc2.isLibrary() && launchDesc2.getResources() != null) {
                        packageInformationArray[0] = ResourcesDesc.visitPackageElements(launchDesc2, string);
                    }
                }
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
                if (packageInformationArray[0] == null && packageDesc.match(string)) {
                    packageInformationArray[0] = new PackageInformation(launchDesc, packageDesc.getPart());
                }
            }
        });
        return packageInformationArray[0];
    }

    public void visit(ResourceVisitor resourceVisitor) {
        for (int i = 0; i < this._list.size(); ++i) {
            ResourceType resourceType = (ResourceType)this._list.get(i);
            resourceType.visit(resourceVisitor);
        }
    }

    public XMLNode asXML() {
        XMLNodeBuilder xMLNodeBuilder = new XMLNodeBuilder("resources", null);
        for (int i = 0; i < this._list.size(); ++i) {
            ResourceType resourceType = (ResourceType)this._list.get(i);
            xMLNodeBuilder.add((XMLable)resourceType);
        }
        return xMLNodeBuilder.getNode();
    }

    public void addNested(ResourcesDesc resourcesDesc) {
        if (resourcesDesc != null) {
            resourcesDesc.visit(new ResourceVisitor(){

                public void visitJARDesc(JARDesc jARDesc) {
                    ResourcesDesc.this._list.add(jARDesc);
                }

                public void visitPropertyDesc(PropertyDesc propertyDesc) {
                    ResourcesDesc.this._list.add(propertyDesc);
                }

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    ResourcesDesc.this._list.add(extensionDesc);
                }
            });
        }
    }

    public static class PackageInformation {
        private LaunchDesc _launchDesc;
        private String _part;

        PackageInformation(LaunchDesc launchDesc, String string) {
            this._launchDesc = launchDesc;
            this._part = string;
        }

        public LaunchDesc getLaunchDesc() {
            return this._launchDesc;
        }

        public String getPart() {
            return this._part;
        }
    }
}

