/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.FullyQualifyPathExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateStatement
extends AbstractExpression {
    private boolean hasSpaceAfterUpdateClause;
    private UpdateClause updateClause;
    private AbstractExpression whereClause;

    UpdateStatement(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getUpdateClause().accept(visitor);
        this.getWhereClause().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getUpdateClause());
        children.add(this.getWhereClause());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.updateClause);
        if (this.hasSpaceAfterUpdateClause) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.whereClause != null) {
            children.add(this.whereClause);
        }
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return UpdateStatement.queryBNF("update_statement");
    }

    public UpdateClause getUpdateClause() {
        return this.updateClause;
    }

    public Expression getWhereClause() {
        if (this.whereClause == null) {
            this.whereClause = this.buildNullExpression();
        }
        return this.whereClause;
    }

    public boolean hasSpaceAfterUpdateClause() {
        return this.hasSpaceAfterUpdateClause;
    }

    public boolean hasWhereClause() {
        return this.whereClause != null && !this.whereClause.isNull();
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        this.updateClause = new UpdateClause(this);
        this.updateClause.parse(wordParser, tolerant);
        boolean bl = this.hasSpaceAfterUpdateClause = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("WHERE")) {
            this.whereClause = new WhereClause(this);
            this.whereClause.parse(wordParser, tolerant);
        }
        this.accept(FullyQualifyPathExpressionVisitor.instance());
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        this.updateClause.toParsedText(writer, includeVirtual);
        if (this.hasSpaceAfterUpdateClause) {
            writer.append(' ');
        }
        if (this.whereClause != null) {
            this.whereClause.toParsedText(writer, includeVirtual);
        }
    }
}

