/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class Translator
extends AccessibleContext
implements Accessible,
AccessibleComponent {
    protected Object source;

    protected static Class getTranslatorClass(Class clazz) {
        Class<?> clazz2 = null;
        if (clazz == null) {
            return null;
        }
        try {
            clazz2 = Class.forName("com.sun.java.accessibility.util." + clazz.getName() + "Translator");
            return clazz2;
        }
        catch (Exception exception) {
            return Translator.getTranslatorClass(clazz.getSuperclass());
        }
    }

    public static Accessible getAccessible(Object object) {
        Accessible accessible = null;
        if (object == null) {
            return null;
        }
        if (object instanceof Accessible) {
            accessible = (Accessible)object;
        } else {
            Class clazz = Translator.getTranslatorClass(object.getClass());
            if (clazz != null) {
                try {
                    Translator translator = (Translator)clazz.newInstance();
                    translator.setSource(object);
                    accessible = translator;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (accessible == null) {
            accessible = new Translator(object);
        }
        return accessible;
    }

    public Translator() {
    }

    public Translator(Object object) {
        this.source = object;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public boolean equals(Object object) {
        return this.source.equals(object);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this;
    }

    @Override
    public String getAccessibleName() {
        if (this.source instanceof MenuItem) {
            return ((MenuItem)this.source).getLabel();
        }
        if (this.source instanceof Component) {
            return ((Component)this.source).getName();
        }
        return null;
    }

    @Override
    public void setAccessibleName(String string) {
        if (this.source instanceof MenuItem) {
            ((MenuItem)this.source).setLabel(string);
        } else if (this.source instanceof Component) {
            ((Component)this.source).setName(string);
        }
    }

    @Override
    public String getAccessibleDescription() {
        return null;
    }

    @Override
    public void setAccessibleDescription(String string) {
    }

    @Override
    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.UNKNOWN;
    }

    @Override
    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
        if (this.source instanceof Component) {
            Component component = (Component)this.source;
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof Window) || ((Window)container).getFocusOwner() != component) continue;
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
        }
        if (this.isEnabled()) {
            accessibleStateSet.add(AccessibleState.ENABLED);
        }
        if (this.isFocusTraversable()) {
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
        }
        if (this.source instanceof MenuItem) {
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
        }
        return accessibleStateSet;
    }

    @Override
    public Accessible getAccessibleParent() {
        if (this.accessibleParent != null) {
            return this.accessibleParent;
        }
        if (this.source instanceof Component) {
            return Translator.getAccessible(((Component)this.source).getParent());
        }
        return null;
    }

    @Override
    public int getAccessibleIndexInParent() {
        Container container;
        if (this.source instanceof Component && (container = ((Component)this.source).getParent()) != null) {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!this.source.equals(componentArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int getAccessibleChildrenCount() {
        if (this.source instanceof Container) {
            Component[] componentArray = ((Container)this.source).getComponents();
            int n = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                Accessible accessible = Translator.getAccessible(componentArray[i]);
                if (accessible == null) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    @Override
    public Accessible getAccessibleChild(int n) {
        if (this.source instanceof Container) {
            Component[] componentArray = ((Container)this.source).getComponents();
            int n2 = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                Accessible accessible = Translator.getAccessible(componentArray[i]);
                if (accessible == null) continue;
                if (n2 == n) {
                    AccessibleContext accessibleContext = accessible.getAccessibleContext();
                    if (accessibleContext != null) {
                        accessibleContext.setAccessibleParent(this);
                    }
                    return accessible;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public Locale getLocale() throws IllegalComponentStateException {
        if (this.source instanceof Component) {
            return ((Component)this.source).getLocale();
        }
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public Color getBackground() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getBackground();
        }
        return null;
    }

    @Override
    public void setBackground(Color color) {
        if (this.source instanceof Component) {
            ((Component)this.source).setBackground(color);
        }
    }

    @Override
    public Color getForeground() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getForeground();
        }
        return null;
    }

    @Override
    public void setForeground(Color color) {
        if (this.source instanceof Component) {
            ((Component)this.source).setForeground(color);
        }
    }

    @Override
    public Cursor getCursor() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getCursor();
        }
        return null;
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.source instanceof Component) {
            ((Component)this.source).setCursor(cursor);
        }
    }

    @Override
    public Font getFont() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getFont();
        }
        if (this.source instanceof MenuComponent) {
            return ((MenuComponent)this.source).getFont();
        }
        return null;
    }

    @Override
    public void setFont(Font font) {
        if (this.source instanceof Component) {
            ((Component)this.source).setFont(font);
        } else if (this.source instanceof MenuComponent) {
            ((MenuComponent)this.source).setFont(font);
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (this.source instanceof Component) {
            return ((Component)this.source).getFontMetrics(font);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isEnabled();
        }
        if (this.source instanceof MenuItem) {
            return ((MenuItem)this.source).isEnabled();
        }
        return true;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.source instanceof Component) {
            ((Component)this.source).setEnabled(bl);
        } else if (this.source instanceof MenuItem) {
            ((MenuItem)this.source).setEnabled(bl);
        }
    }

    @Override
    public boolean isVisible() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isVisible();
        }
        return false;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.source instanceof Component) {
            ((Component)this.source).setVisible(bl);
        }
    }

    @Override
    public boolean isShowing() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isShowing();
        }
        return false;
    }

    @Override
    public boolean contains(Point point) {
        if (this.source instanceof Component) {
            return ((Component)this.source).contains(point);
        }
        return false;
    }

    @Override
    public Point getLocationOnScreen() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getLocationOnScreen();
        }
        return null;
    }

    @Override
    public Point getLocation() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getLocation();
        }
        return null;
    }

    @Override
    public void setLocation(Point point) {
        if (this.source instanceof Component) {
            ((Component)this.source).setLocation(point);
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getBounds();
        }
        return null;
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        if (this.source instanceof Component) {
            ((Component)this.source).setBounds(rectangle);
        }
    }

    @Override
    public Dimension getSize() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getSize();
        }
        return null;
    }

    @Override
    public void setSize(Dimension dimension) {
        if (this.source instanceof Component) {
            ((Component)this.source).setSize(dimension);
        }
    }

    @Override
    public Accessible getAccessibleAt(Point point) {
        Component component;
        if (this.source instanceof Component && (component = ((Component)this.source).getComponentAt(point)) != null) {
            return Translator.getAccessible(component);
        }
        return null;
    }

    @Override
    public boolean isFocusTraversable() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isFocusTraversable();
        }
        return false;
    }

    @Override
    public void requestFocus() {
        if (this.source instanceof Component) {
            ((Component)this.source).requestFocus();
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener focusListener) {
        if (this.source instanceof Component) {
            ((Component)this.source).addFocusListener(focusListener);
        }
    }

    @Override
    public synchronized void removeFocusListener(FocusListener focusListener) {
        if (this.source instanceof Component) {
            ((Component)this.source).removeFocusListener(focusListener);
        }
    }
}

