/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;

final class P11RSAKeyFactory
extends P11KeyFactory {
    P11RSAKeyFactory(Token token, String string) {
        super(token, string);
    }

    @Override
    PublicKey implTranslatePublicKey(PublicKey publicKey) throws InvalidKeyException {
        try {
            if (publicKey instanceof RSAPublicKey) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
                return this.generatePublic(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            if ("X.509".equals(publicKey.getFormat())) {
                byte[] byArray = publicKey.getEncoded();
                publicKey = new RSAPublicKeyImpl(byArray);
                return this.implTranslatePublicKey(publicKey);
            }
            throw new InvalidKeyException("PublicKey must be instance of RSAPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not create RSA public key", pKCS11Exception);
        }
    }

    @Override
    PrivateKey implTranslatePrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        try {
            if (privateKey instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
                return this.generatePrivate(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            }
            if (privateKey instanceof RSAPrivateKey) {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
                return this.generatePrivate(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            }
            if ("PKCS#8".equals(privateKey.getFormat())) {
                byte[] byArray = privateKey.getEncoded();
                privateKey = RSAPrivateCrtKeyImpl.newKey((byte[])byArray);
                return this.implTranslatePrivateKey(privateKey);
            }
            throw new InvalidKeyException("Private key must be instance of RSAPrivate(Crt)Key or have PKCS#8 encoding");
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not create RSA private key", pKCS11Exception);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                RSAPublicKeyImpl rSAPublicKeyImpl = new RSAPublicKeyImpl(byArray);
                return this.implTranslatePublicKey(rSAPublicKeyImpl);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException("Could not create RSA public key", invalidKeyException);
            }
        }
        if (!(keySpec instanceof RSAPublicKeySpec)) {
            throw new InvalidKeySpecException("Only RSAPublicKeySpec and X509EncodedKeySpec supported for RSA public keys");
        }
        try {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
            return this.generatePublic(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeySpecException("Could not create RSA public key", pKCS11Exception);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Could not create RSA public key", invalidKeyException);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                RSAPrivateKey rSAPrivateKey = RSAPrivateCrtKeyImpl.newKey((byte[])byArray);
                return this.implTranslatePrivateKey(rSAPrivateKey);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidKeySpecException("Could not create RSA private key", generalSecurityException);
            }
        }
        try {
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                return this.generatePrivate(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
                return this.generatePrivate(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
            }
            throw new InvalidKeySpecException("Only RSAPrivate(Crt)KeySpec and PKCS8EncodedKeySpec supported for RSA private keys");
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeySpecException("Could not create RSA private key", pKCS11Exception);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Could not create RSA private key", invalidKeyException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generatePublic(BigInteger bigInteger, BigInteger bigInteger2) throws PKCS11Exception, InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(bigInteger.bitLength(), bigInteger2, -1, 65536);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(288L, bigInteger), new CK_ATTRIBUTE(290L, bigInteger2)};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 2L, 0L, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long l = this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            PublicKey publicKey = P11Key.publicKey(session, l, "RSA", bigInteger.bitLength(), cK_ATTRIBUTEArray);
            return publicKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger bigInteger, BigInteger bigInteger2) throws PKCS11Exception, InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(bigInteger.bitLength(), null, -1, 65536);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(288L, bigInteger), new CK_ATTRIBUTE(291L, bigInteger2)};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 3L, 0L, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long l = this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            PrivateKey privateKey = P11Key.privateKey(session, l, "RSA", bigInteger.bitLength(), cK_ATTRIBUTEArray);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws PKCS11Exception, InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(bigInteger.bitLength(), bigInteger2, -1, 65536);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(288L, bigInteger), new CK_ATTRIBUTE(290L, bigInteger2), new CK_ATTRIBUTE(291L, bigInteger3), new CK_ATTRIBUTE(292L, bigInteger4), new CK_ATTRIBUTE(293L, bigInteger5), new CK_ATTRIBUTE(294L, bigInteger6), new CK_ATTRIBUTE(295L, bigInteger7), new CK_ATTRIBUTE(296L, bigInteger8)};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 3L, 0L, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long l = this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            PrivateKey privateKey = P11Key.privateKey(session, l, "RSA", bigInteger.bitLength(), cK_ATTRIBUTEArray);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    @Override
    KeySpec implGetPublicKeySpec(P11Key p11Key, Class clazz, Session[] sessionArray) throws PKCS11Exception, InvalidKeySpecException {
        if (RSAPublicKeySpec.class.isAssignableFrom(clazz)) {
            sessionArray[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(290L)};
            this.token.p11.C_GetAttributeValue(sessionArray[0].id(), p11Key.keyID, cK_ATTRIBUTEArray);
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(cK_ATTRIBUTEArray[0].getBigInteger(), cK_ATTRIBUTEArray[1].getBigInteger());
            return rSAPublicKeySpec;
        }
        throw new InvalidKeySpecException("Only RSAPublicKeySpec and X509EncodedKeySpec supported for RSA public keys");
    }

    @Override
    KeySpec implGetPrivateKeySpec(P11Key p11Key, Class clazz, Session[] sessionArray) throws PKCS11Exception, InvalidKeySpecException {
        if (RSAPrivateCrtKeySpec.class.isAssignableFrom(clazz)) {
            sessionArray[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(290L), new CK_ATTRIBUTE(291L), new CK_ATTRIBUTE(292L), new CK_ATTRIBUTE(293L), new CK_ATTRIBUTE(294L), new CK_ATTRIBUTE(295L), new CK_ATTRIBUTE(296L)};
            this.token.p11.C_GetAttributeValue(sessionArray[0].id(), p11Key.keyID, cK_ATTRIBUTEArray);
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(cK_ATTRIBUTEArray[0].getBigInteger(), cK_ATTRIBUTEArray[1].getBigInteger(), cK_ATTRIBUTEArray[2].getBigInteger(), cK_ATTRIBUTEArray[3].getBigInteger(), cK_ATTRIBUTEArray[4].getBigInteger(), cK_ATTRIBUTEArray[5].getBigInteger(), cK_ATTRIBUTEArray[6].getBigInteger(), cK_ATTRIBUTEArray[7].getBigInteger());
            return rSAPrivateCrtKeySpec;
        }
        if (RSAPrivateKeySpec.class.isAssignableFrom(clazz)) {
            sessionArray[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(291L)};
            this.token.p11.C_GetAttributeValue(sessionArray[0].id(), p11Key.keyID, cK_ATTRIBUTEArray);
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(cK_ATTRIBUTEArray[0].getBigInteger(), cK_ATTRIBUTEArray[1].getBigInteger());
            return rSAPrivateKeySpec;
        }
        throw new InvalidKeySpecException("Only RSAPrivate(Crt)KeySpec and PKCS8EncodedKeySpec supported for RSA private keys");
    }

    @Override
    KeyFactory implGetSoftwareFactory() throws GeneralSecurityException {
        return KeyFactory.getInstance("RSA", P11Util.getSunRsaSignProvider());
    }
}

