/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.Histogram;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

class Coding
implements Comparable,
CodingMethod,
Histogram.BitMetric {
    public static final int B_MAX = 5;
    public static final int H_MAX = 256;
    public static final int S_MAX = 2;
    private final int B;
    private final int H;
    private final int L;
    private final int S;
    private final int del;
    private final int min;
    private final int max;
    private final int umin;
    private final int umax;
    private final int[] byteMin;
    private final int[] byteMax;
    private static Map<Coding, Coding> codeMap;
    private static final byte[] byteBitWidths;
    static boolean verboseStringForDebug;

    private static int saturate32(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    private static long codeRangeLong(int n, int n2) {
        return Coding.codeRangeLong(n, n2, n);
    }

    private static long codeRangeLong(int n, int n2, int n3) {
        assert (n3 >= 0 && n3 <= n);
        assert (n >= 1 && n <= 5);
        assert (n2 >= 1 && n2 <= 256);
        if (n3 == 0) {
            return 0L;
        }
        if (n == 1) {
            return n2;
        }
        int n4 = 256 - n2;
        long l = 0L;
        long l2 = 1L;
        for (int i = 1; i <= n3; ++i) {
            l += l2;
            l2 *= (long)n2;
        }
        l *= (long)n4;
        if (n3 == n) {
            l += l2;
        }
        return l;
    }

    public static int codeMax(int n, int n2, int n3, int n4) {
        long l = Coding.codeRangeLong(n, n2, n4);
        if (l == 0L) {
            return -1;
        }
        if (n3 == 0 || l >= 0x100000000L) {
            return Coding.saturate32(l - 1L);
        }
        long l2 = l - 1L;
        while (Coding.isNegativeCode(l2, n3)) {
            --l2;
        }
        if (l2 < 0L) {
            return -1;
        }
        int n5 = Coding.decodeSign32(l2, n3);
        if (n5 < 0) {
            return Integer.MAX_VALUE;
        }
        return n5;
    }

    public static int codeMin(int n, int n2, int n3, int n4) {
        long l = Coding.codeRangeLong(n, n2, n4);
        if (l >= 0x100000000L && n4 == n) {
            return Integer.MIN_VALUE;
        }
        if (n3 == 0) {
            return 0;
        }
        long l2 = l - 1L;
        while (!Coding.isNegativeCode(l2, n3)) {
            --l2;
        }
        if (l2 < 0L) {
            return 0;
        }
        return Coding.decodeSign32(l2, n3);
    }

    private static long toUnsigned32(int n) {
        return (long)n << 32 >>> 32;
    }

    private static boolean isNegativeCode(long l, int n) {
        assert (n > 0);
        assert (l >= -1L);
        int n2 = (1 << n) - 1;
        return ((int)l + 1 & n2) == 0;
    }

    private static boolean hasNegativeCode(int n, int n2) {
        assert (n2 > 0);
        return 0 > n && n >= ~(-1 >>> n2);
    }

    private static int decodeSign32(long l, int n) {
        assert (l == Coding.toUnsigned32((int)l)) : Long.toHexString(l);
        if (n == 0) {
            return (int)l;
        }
        int n2 = Coding.isNegativeCode(l, n) ? ~((int)l >>> n) : (int)l - ((int)l >>> n);
        assert (n != 1 || n2 == ((int)l >>> 1 ^ -((int)l & 1)));
        return n2;
    }

    private static long encodeSign32(int n, int n2) {
        if (n2 == 0) {
            return Coding.toUnsigned32(n);
        }
        int n3 = (1 << n2) - 1;
        long l = !Coding.hasNegativeCode(n, n2) ? (long)n + Coding.toUnsigned32(n) / (long)n3 : (long)((-n << n2) - 1);
        l = Coding.toUnsigned32((int)l);
        assert (n == Coding.decodeSign32(l, n2)) : Long.toHexString(l) + " -> " + Integer.toHexString(n) + " != " + Integer.toHexString(Coding.decodeSign32(l, n2));
        return l;
    }

    public static void writeInt(byte[] byArray, int[] nArray, int n, int n2, int n3, int n4) {
        long l = Coding.encodeSign32(n, n4);
        assert (l == Coding.toUnsigned32((int)l));
        assert (l < Coding.codeRangeLong(n2, n3)) : Long.toHexString(l);
        int n5 = 256 - n3;
        long l2 = l;
        int n6 = nArray[0];
        for (int i = 0; i < n2 - 1 && l2 >= (long)n5; l2 /= (long)n3, ++i) {
            int n7 = (int)((long)n5 + (l2 -= (long)n5) % (long)n3);
            byArray[n6++] = (byte)n7;
        }
        byArray[n6++] = (byte)l2;
        nArray[0] = n6;
    }

    public static int readInt(byte[] byArray, int[] nArray, int n, int n2, int n3) {
        int n4 = 256 - n2;
        long l = 0L;
        long l2 = 1L;
        int n5 = nArray[0];
        for (int i = 0; i < n; ++i) {
            int n6 = byArray[n5++] & 0xFF;
            l += (long)n6 * l2;
            l2 *= (long)n2;
            if (n6 < n4) break;
        }
        nArray[0] = n5;
        return Coding.decodeSign32(l, n3);
    }

    public static int readIntFrom(InputStream inputStream, int n, int n2, int n3) throws IOException {
        int n4 = 256 - n2;
        long l = 0L;
        long l2 = 1L;
        for (int i = 0; i < n; ++i) {
            int n5 = inputStream.read();
            if (n5 < 0) {
                throw new RuntimeException("unexpected EOF");
            }
            l += (long)n5 * l2;
            l2 *= (long)n2;
            if (n5 < n4) break;
        }
        assert (l >= 0L && l < Coding.codeRangeLong(n, n2));
        return Coding.decodeSign32(l, n3);
    }

    private Coding(int n, int n2, int n3) {
        this(n, n2, n3, 0);
    }

    private Coding(int n, int n2, int n3, int n4) {
        this.B = n;
        this.H = n2;
        this.L = 256 - n2;
        this.S = n3;
        this.del = n4;
        this.min = Coding.codeMin(n, n2, n3, n);
        this.max = Coding.codeMax(n, n2, n3, n);
        this.umin = Coding.codeMin(n, n2, 0, n);
        this.umax = Coding.codeMax(n, n2, 0, n);
        this.byteMin = new int[n];
        this.byteMax = new int[n];
        for (int i = 1; i <= n; ++i) {
            this.byteMin[i - 1] = Coding.codeMin(n, n2, n3, i);
            this.byteMax[i - 1] = Coding.codeMax(n, n2, n3, i);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Coding)) {
            return false;
        }
        Coding coding = (Coding)object;
        if (this.B != coding.B) {
            return false;
        }
        if (this.H != coding.H) {
            return false;
        }
        if (this.S != coding.S) {
            return false;
        }
        return this.del == coding.del;
    }

    public int hashCode() {
        return (this.del << 14) + (this.S << 11) + (this.B << 8) + (this.H << 0);
    }

    private static synchronized Coding of(int n, int n2, int n3, int n4) {
        Coding coding;
        Coding coding2;
        if (codeMap == null) {
            codeMap = new HashMap<Coding, Coding>();
        }
        if ((coding2 = codeMap.get(coding = new Coding(n, n2, n3, n4))) == null) {
            coding2 = coding;
            codeMap.put(coding, coding2);
        }
        return coding2;
    }

    public static Coding of(int n, int n2) {
        return Coding.of(n, n2, 0, 0);
    }

    public static Coding of(int n, int n2, int n3) {
        return Coding.of(n, n2, n3, 0);
    }

    public boolean canRepresentValue(int n) {
        if (this.isSubrange()) {
            return this.canRepresentUnsigned(n);
        }
        return this.canRepresentSigned(n);
    }

    public boolean canRepresentSigned(int n) {
        return n >= this.min && n <= this.max;
    }

    public boolean canRepresentUnsigned(int n) {
        return n >= this.umin && n <= this.umax;
    }

    public int readFrom(byte[] byArray, int[] nArray) {
        return Coding.readInt(byArray, nArray, this.B, this.H, this.S);
    }

    public void writeTo(byte[] byArray, int[] nArray, int n) {
        Coding.writeInt(byArray, nArray, n, this.B, this.H, this.S);
    }

    public int readFrom(InputStream inputStream) throws IOException {
        return Coding.readIntFrom(inputStream, this.B, this.H, this.S);
    }

    public void writeTo(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[this.B];
        int[] nArray = new int[1];
        Coding.writeInt(byArray, nArray, n, this.B, this.H, this.S);
        outputStream.write(byArray, 0, nArray[0]);
    }

    @Override
    public void readArrayFrom(InputStream inputStream, int[] nArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = n; n3 < n2; ++n3) {
            nArray[n3] = this.readFrom(inputStream);
        }
        for (n3 = 0; n3 < this.del; ++n3) {
            long l = 0L;
            for (int i = n; i < n2; ++i) {
                l += (long)nArray[i];
                if (this.isSubrange()) {
                    l = this.reduceToUnsignedRange(l);
                }
                nArray[i] = (int)l;
            }
        }
    }

    @Override
    public void writeArrayTo(OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        if (n2 <= n) {
            return;
        }
        for (int i = 0; i < this.del; ++i) {
            int[] nArray2 = !this.isSubrange() ? Coding.makeDeltas(nArray, n, n2, 0, 0) : Coding.makeDeltas(nArray, n, n2, this.min, this.max);
            nArray = nArray2;
            n = 0;
            n2 = nArray2.length;
        }
        byte[] byArray = new byte[256];
        int n3 = byArray.length - this.B;
        int[] nArray3 = new int[]{0};
        int n4 = n;
        while (n4 < n2) {
            while (nArray3[0] <= n3) {
                this.writeTo(byArray, nArray3, nArray[n4++]);
                if (n4 < n2) continue;
            }
            outputStream.write(byArray, 0, nArray3[0]);
            nArray3[0] = 0;
        }
    }

    boolean isSubrange() {
        return this.max < Integer.MAX_VALUE && (long)this.max - (long)this.min + 1L <= Integer.MAX_VALUE;
    }

    boolean isFullRange() {
        return this.max == Integer.MAX_VALUE && this.min == Integer.MIN_VALUE;
    }

    int getRange() {
        assert (this.isSubrange());
        return this.max - this.min + 1;
    }

    Coding setB(int n) {
        return Coding.of(n, this.H, this.S, this.del);
    }

    Coding setH(int n) {
        return Coding.of(this.B, n, this.S, this.del);
    }

    Coding setS(int n) {
        return Coding.of(this.B, this.H, n, this.del);
    }

    Coding setL(int n) {
        return this.setH(256 - n);
    }

    Coding setD(int n) {
        return Coding.of(this.B, this.H, this.S, n);
    }

    Coding getDeltaCoding() {
        return this.setD(this.del + 1);
    }

    Coding getValueCoding() {
        if (this.isDelta()) {
            return Coding.of(this.B, this.H, 0, this.del - 1);
        }
        return this;
    }

    int reduceToUnsignedRange(long l) {
        if (l == (long)((int)l) && this.canRepresentUnsigned((int)l)) {
            return (int)l;
        }
        int n = this.getRange();
        assert (n > 0);
        if ((l %= (long)n) < 0L) {
            l += (long)n;
        }
        assert (this.canRepresentUnsigned((int)l));
        return (int)l;
    }

    int reduceToSignedRange(int n) {
        if (this.canRepresentSigned(n)) {
            return n;
        }
        return Coding.reduceToSignedRange(n, this.min, this.max);
    }

    static int reduceToSignedRange(int n, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        assert (n4 > 0);
        int n5 = n;
        if ((n -= n2) < 0 && n5 >= 0) assert ((n -= n4) >= 0);
        if ((n %= n4) < 0) {
            n += n4;
        }
        assert (n2 <= (n += n2) && n <= n3);
        return n;
    }

    boolean isSigned() {
        return this.min < 0;
    }

    boolean isDelta() {
        return this.del != 0;
    }

    public int B() {
        return this.B;
    }

    public int H() {
        return this.H;
    }

    public int L() {
        return this.L;
    }

    public int S() {
        return this.S;
    }

    public int del() {
        return this.del;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public int umin() {
        return this.umin;
    }

    public int umax() {
        return this.umax;
    }

    public int byteMin(int n) {
        return this.byteMin[n - 1];
    }

    public int byteMax(int n) {
        return this.byteMax[n - 1];
    }

    public int compareTo(Object object) {
        Coding coding = (Coding)object;
        int n = this.del - coding.del;
        if (n == 0) {
            n = this.B - coding.B;
        }
        if (n == 0) {
            n = this.H - coding.H;
        }
        if (n == 0) {
            n = this.S - coding.S;
        }
        return n;
    }

    public int distanceFrom(Coding coding) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.del - coding.del;
        if (n5 < 0) {
            n5 = -n5;
        }
        if ((n4 = this.S - coding.S) < 0) {
            n4 = -n4;
        }
        if ((n3 = this.B - coding.B) < 0) {
            n3 = -n3;
        }
        if (this.H == coding.H) {
            n2 = 0;
        } else {
            n = this.getHL();
            int n6 = coding.getHL();
            n2 = (n *= n) > (n6 *= n6) ? Coding.ceil_lg2(1 + (n - 1) / n6) : Coding.ceil_lg2(1 + (n6 - 1) / n);
        }
        n = 5 * (n5 + n4 + n3) + n2;
        assert (n != 0 || this.compareTo(coding) == 0);
        return n;
    }

    private int getHL() {
        if (this.H <= 128) {
            return this.H;
        }
        if (this.L >= 1) {
            return 16384 / this.L;
        }
        return 32768;
    }

    static int ceil_lg2(int n) {
        assert (n - 1 >= 0);
        --n;
        int n2 = 0;
        while (n != 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }

    static int bitWidth(int n) {
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        int n2 = 0;
        int n3 = n;
        if (n3 < byteBitWidths.length) {
            return byteBitWidths[n3];
        }
        int n4 = n3 >>> 16;
        if (n4 != 0) {
            n3 = n4;
            n2 += 16;
        }
        if ((n4 = n3 >>> 8) != 0) {
            n3 = n4;
            n2 += 8;
        }
        return n2 += byteBitWidths[n3];
    }

    static int[] makeDeltas(int[] nArray, int n, int n2, int n3, int n4) {
        assert (n4 >= n3);
        int n5 = n2 - n;
        int[] nArray2 = new int[n5];
        int n6 = 0;
        if (n3 == n4) {
            for (int i = 0; i < n5; ++i) {
                int n7 = nArray[n + i];
                nArray2[i] = n7 - n6;
                n6 = n7;
            }
        } else {
            for (int i = 0; i < n5; ++i) {
                int n8 = nArray[n + i];
                assert (n8 >= 0 && n8 + n3 <= n4);
                int n9 = n8 - n6;
                assert ((long)n9 == (long)n8 - (long)n6);
                n6 = n8;
                nArray2[i] = n9 = Coding.reduceToSignedRange(n9, n3, n4);
            }
        }
        return nArray2;
    }

    boolean canRepresent(int n, int n2) {
        assert (n <= n2);
        if (this.del > 0) {
            if (this.isSubrange()) {
                return this.canRepresentUnsigned(n2) && this.canRepresentUnsigned(n);
            }
            return this.isFullRange();
        }
        return this.canRepresentSigned(n2) && this.canRepresentSigned(n);
    }

    boolean canRepresent(int[] nArray, int n, int n2) {
        int n3;
        int n4 = n2 - n;
        if (n4 == 0) {
            return true;
        }
        if (this.isFullRange()) {
            return true;
        }
        int n5 = n3 = nArray[n];
        for (int i = 1; i < n4; ++i) {
            int n6 = nArray[n + i];
            if (n3 < n6) {
                n3 = n6;
            }
            if (n5 <= n6) continue;
            n5 = n6;
        }
        return this.canRepresent(n5, n3);
    }

    @Override
    public double getBitLength(int n) {
        return (double)this.getLength(n) * 8.0;
    }

    public int getLength(int n) {
        if (this.isDelta() && this.isSubrange()) {
            if (!this.canRepresentUnsigned(n)) {
                return Integer.MAX_VALUE;
            }
            n = this.reduceToSignedRange(n);
        }
        if (n >= 0) {
            for (int i = 0; i < this.B; ++i) {
                if (n > this.byteMax[i]) continue;
                return i + 1;
            }
        } else {
            for (int i = 0; i < this.B; ++i) {
                if (n < this.byteMin[i]) continue;
                return i + 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    public int getLength(int[] nArray, int n, int n2) {
        int n3 = n2 - n;
        if (this.B == 1) {
            return n3;
        }
        if (this.L == 0) {
            return n3 * this.B;
        }
        if (this.isDelta()) {
            int[] nArray2 = !this.isSubrange() ? Coding.makeDeltas(nArray, n, n2, 0, 0) : Coding.makeDeltas(nArray, n, n2, this.min, this.max);
            nArray = nArray2;
            n = 0;
        }
        int n4 = n3;
        for (int i = 1; i <= this.B; ++i) {
            int n5 = this.byteMax[i - 1];
            int n6 = this.byteMin[i - 1];
            int n7 = 0;
            for (int j = 0; j < n3; ++j) {
                int n8 = nArray[n + j];
                if (n8 >= 0) {
                    if (n8 <= n5) continue;
                    ++n7;
                    continue;
                }
                if (n8 >= n6) continue;
                ++n7;
            }
            if (n7 == 0) break;
            if (i == this.B) {
                return Integer.MAX_VALUE;
            }
            n4 += n7;
        }
        return n4;
    }

    @Override
    public byte[] getMetaCoding(Coding coding) {
        if (coding == this) {
            return new byte[]{0};
        }
        int n = BandStructure.indexOf(this);
        if (n > 0) {
            return new byte[]{(byte)n};
        }
        return new byte[]{116, (byte)(this.del + 2 * this.S + 8 * (this.B - 1)), (byte)(this.H - 1)};
    }

    public static int parseMetaCoding(byte[] byArray, int n, Coding coding, CodingMethod[] codingMethodArray) {
        int n2;
        if (1 <= (n2 = byArray[n++] & 0xFF) && n2 <= 115) {
            Coding coding2 = BandStructure.codingForIndex(n2);
            assert (coding2 != null);
            codingMethodArray[0] = coding2;
            return n;
        }
        if (n2 == 116) {
            int n3 = byArray[n++] & 0xFF;
            int n4 = byArray[n++] & 0xFF;
            int n5 = n3 % 2;
            int n6 = n3 / 2 % 4;
            int n7 = n3 / 8 + 1;
            int n8 = n4 + 1;
            if (1 > n7 || n7 > 5 || 0 > n6 || n6 > 2 || 1 > n8 || n8 > 256 || 0 > n5 || n5 > 1 || n7 == 1 && n8 != 256 || n7 == 5 && n8 == 256) {
                throw new RuntimeException("Bad arb. coding: (" + n7 + "," + n8 + "," + n6 + "," + n5);
            }
            codingMethodArray[0] = Coding.of(n7, n8, n6, n5);
            return n;
        }
        return n - 1;
    }

    public String keyString() {
        return "(" + this.B + "," + this.H + "," + this.S + "," + this.del + ")";
    }

    public String toString() {
        String string = "Coding" + this.keyString();
        return string;
    }

    String stringForDebug() {
        String string = this.min == Integer.MIN_VALUE ? "min" : "" + this.min;
        String string2 = this.max == Integer.MAX_VALUE ? "max" : "" + this.max;
        String string3 = this.keyString() + " L=" + this.L + " r=[" + string + "," + string2 + "]";
        if (this.isSubrange()) {
            string3 = string3 + " subrange";
        } else if (!this.isFullRange()) {
            string3 = string3 + " MIDRANGE";
        }
        if (verboseStringForDebug) {
            string3 = string3 + " {";
            int n = 0;
            for (int i = 1; i <= this.B; ++i) {
                int n2 = Coding.saturate32((long)this.byteMax[i - 1] - (long)this.byteMin[i - 1] + 1L);
                assert (n2 == Coding.saturate32(Coding.codeRangeLong(this.B, this.H, i)));
                n = n2 -= n;
                String string4 = n2 == Integer.MAX_VALUE ? "max" : "" + n2;
                string3 = string3 + " #" + i + "=" + string4;
            }
            string3 = string3 + " }";
        }
        return string3;
    }

    static {
        int n;
        byteBitWidths = new byte[256];
        for (n = 0; n < byteBitWidths.length; ++n) {
            Coding.byteBitWidths[n] = (byte)Coding.ceil_lg2(n + 1);
        }
        n = 10;
        while (n >= 0) {
            assert (Coding.bitWidth(n) == Coding.ceil_lg2(n + 1));
            n = (n << 1) - (n >> 3);
        }
        verboseStringForDebug = false;
    }
}

