/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.robot.impl.FXRobotHelper;
import com.sun.javafx.tk.Toolkit;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class KeyEvent
extends InputEvent {
    public static final EventType<KeyEvent> ANY = new EventType<InputEvent>(InputEvent.ANY, "KEY");
    public static final EventType<KeyEvent> KEY_PRESSED = new EventType<KeyEvent>(ANY, "KEY_PRESSED");
    public static final EventType<KeyEvent> KEY_RELEASED = new EventType<KeyEvent>(ANY, "KEY_RELEASED");
    public static final EventType<KeyEvent> KEY_TYPED = new EventType<KeyEvent>(ANY, "KEY_TYPED");
    public static final String CHAR_UNDEFINED;
    private String character;
    private String text;
    private KeyCode code;
    private boolean shiftDown;
    private boolean controlDown;
    private boolean altDown;
    private boolean metaDown;

    private KeyEvent(EventType<? extends KeyEvent> eventType) {
        super((EventType<? extends InputEvent>)eventType);
    }

    private KeyEvent(Object object, EventTarget eventTarget, EventType<? extends KeyEvent> eventType) {
        super(object, eventTarget, (EventType<? extends InputEvent>)eventType);
    }

    @Deprecated
    public static KeyEvent impl_copy(EventTarget eventTarget, KeyEvent keyEvent) {
        return (KeyEvent)keyEvent.copyFor(keyEvent.source, eventTarget);
    }

    @Deprecated
    public static KeyEvent impl_keyEvent(EventTarget eventTarget, String string, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, EventType<? extends KeyEvent> eventType) {
        boolean bl5 = eventType == KEY_TYPED;
        KeyEvent keyEvent = new KeyEvent((Object)null, eventTarget, eventType);
        keyEvent.character = bl5 ? string : CHAR_UNDEFINED;
        keyEvent.text = bl5 ? "" : string2;
        keyEvent.code = bl5 ? KeyCode.UNDEFINED : KeyCode.impl_valueOf(n);
        keyEvent.shiftDown = bl;
        keyEvent.controlDown = bl2;
        keyEvent.altDown = bl3;
        keyEvent.metaDown = bl4;
        return keyEvent;
    }

    static KeyEvent testKeyEvent(EventTarget eventTarget, String string, KeyCode keyCode, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        KeyEvent keyEvent = new KeyEvent((Object)null, eventTarget, (EventType<? extends KeyEvent>)KEY_PRESSED);
        keyEvent.character = string;
        keyEvent.code = keyCode;
        keyEvent.shiftDown = bl;
        keyEvent.controlDown = bl2;
        keyEvent.altDown = bl3;
        keyEvent.metaDown = bl4;
        return keyEvent;
    }

    public final String getCharacter() {
        return this.character;
    }

    public final String getText() {
        return this.text;
    }

    public final KeyCode getCode() {
        return this.code;
    }

    public final boolean isShiftDown() {
        return this.shiftDown;
    }

    public final boolean isControlDown() {
        return this.controlDown;
    }

    public final boolean isAltDown() {
        return this.altDown;
    }

    public final boolean isMetaDown() {
        return this.metaDown;
    }

    public final boolean isShortcutDown() {
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT: {
                return this.shiftDown;
            }
            case CONTROL: {
                return this.controlDown;
            }
            case ALT: {
                return this.altDown;
            }
            case META: {
                return this.metaDown;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("KeyEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(this.getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", character = ").append(this.getCharacter());
        stringBuilder.append(", text = ").append(this.getText());
        stringBuilder.append(", code = ").append((Object)this.getCode());
        if (this.isShiftDown()) {
            stringBuilder.append(", shiftDown");
        }
        if (this.isControlDown()) {
            stringBuilder.append(", controlDown");
        }
        if (this.isAltDown()) {
            stringBuilder.append(", altDown");
        }
        if (this.isMetaDown()) {
            stringBuilder.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            stringBuilder.append(", shortcutDown");
        }
        return stringBuilder.append("]").toString();
    }

    static {
        FXRobotHelper.FXRobotInputAccessor fXRobotInputAccessor = new FXRobotHelper.FXRobotInputAccessor(){

            @Override
            public int getCodeForKeyCode(KeyCode keyCode) {
                return keyCode.code;
            }

            @Override
            public KeyCode getKeyCodeForCode(int n) {
                return KeyCode.impl_valueOf(n);
            }

            @Override
            public KeyEvent createKeyEvent(EventType<? extends KeyEvent> eventType, KeyCode keyCode, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
                KeyEvent keyEvent = new KeyEvent(eventType);
                keyEvent.character = string;
                keyEvent.code = keyCode;
                keyEvent.text = string2;
                keyEvent.shiftDown = bl;
                keyEvent.controlDown = bl2;
                keyEvent.altDown = bl3;
                keyEvent.metaDown = bl4;
                return keyEvent;
            }

            @Override
            public MouseEvent createMouseEvent(EventType<? extends MouseEvent> eventType, int n, int n2, int n3, int n4, MouseButton mouseButton, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
                return MouseEvent.impl_mouseEvent(n, n2, n3, n4, mouseButton, n5, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, false, eventType);
            }

            @Override
            public ScrollEvent createScrollEvent(EventType<? extends ScrollEvent> eventType, int n, int n2, ScrollEvent.HorizontalTextScrollUnits horizontalTextScrollUnits, int n3, ScrollEvent.VerticalTextScrollUnits verticalTextScrollUnits, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
                return ScrollEvent.impl_scrollEvent(ScrollEvent.SCROLL, n, n2, 0.0, 0.0, horizontalTextScrollUnits, n3, verticalTextScrollUnits, n4, 0, n5, n6, n7, n8, bl, bl2, bl3, bl4, false, false);
            }
        };
        FXRobotHelper.setInputAccessor(fXRobotInputAccessor);
        CHAR_UNDEFINED = KeyCode.UNDEFINED.ch;
    }
}

