/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.internal.jpql.AbstractVisitor;
import org.eclipse.persistence.jpa.internal.jpql.DefaultJPQLQueryProblem;
import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.spi.IPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidator
extends AbstractVisitor {
    private BypassChildCollectionExpressionVisitor bypassChildCollectionExpressionVisitor;
    private BypassParentSubExpressionVisitor bypassParentSubExpressionVisitor;
    private ChildrenCollectorVisitor childrenCollectorVisitor;
    private OwningClauseVisitor owningClauseVisitor;
    private List<JPQLQueryProblem> problems;
    private Map<String, ExpressionValidator> validators;

    protected AbstractValidator(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    protected final void addProblem(Expression expression, int startIndex, int endIndex, String messageKey, String ... messageArguments) {
        this.problems.add(this.buildProblem(expression, startIndex, endIndex, messageKey, messageArguments));
    }

    protected final void addProblem(Expression expression, String messageKey) {
        this.addProblem(expression, messageKey, ExpressionTools.EMPTY_STRING_ARRAY);
    }

    protected final void addProblem(Expression expression, String messageKey, String ... arguments) {
        int startPosition = this.position(expression);
        int endPosition = startPosition + this.length(expression);
        this.addProblem(expression, startPosition, endPosition, messageKey, arguments);
    }

    protected final ExpressionValidator buildExpressionValidator(String ... queryBNFs) {
        JPQLQueryBNF[] bnfs = new JPQLQueryBNF[queryBNFs.length];
        int index = queryBNFs.length;
        while (--index >= 0) {
            bnfs[index] = AbstractExpression.queryBNF(queryBNFs[index]);
        }
        return new ExpressionValidator(bnfs);
    }

    private JPQLQueryProblem buildProblem(Expression expression, int startIndex, int endIndex, String messageKey, String ... messageArguments) {
        return new DefaultJPQLQueryProblem(this.queryContext.getQuery(), expression, startIndex, endIndex, messageKey, messageArguments);
    }

    protected final BypassChildCollectionExpressionVisitor bypassChildCollectionExpressionVisitor() {
        if (this.bypassChildCollectionExpressionVisitor == null) {
            this.bypassChildCollectionExpressionVisitor = new BypassChildCollectionExpressionVisitor();
        }
        return this.bypassChildCollectionExpressionVisitor;
    }

    protected final BypassParentSubExpressionVisitor bypassParentSubExpressionVisitor() {
        if (this.bypassParentSubExpressionVisitor == null) {
            this.bypassParentSubExpressionVisitor = new BypassParentSubExpressionVisitor();
        }
        return this.bypassParentSubExpressionVisitor;
    }

    private int calculatePosition(Expression expression, int position) {
        AbstractExpression parent = (AbstractExpression)expression.getParent();
        if (parent == null) {
            return position;
        }
        ListIterator<StringExpression> iter = parent.orderedChildren();
        while (iter.hasNext()) {
            StringExpression childExpression = (StringExpression)iter.next();
            if (childExpression == expression) {
                return this.calculatePosition(parent, position);
            }
            position += childExpression.toParsedText().length();
        }
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Collection<Expression> children(Expression expression) {
        ChildrenCollectorVisitor visitor = this.childrenCollectorVisitor();
        try {
            visitor.expressions = new ArrayList<Expression>();
            expression.accept(visitor);
            List<Expression> list = visitor.expressions;
            return list;
        }
        finally {
            visitor.expressions = null;
        }
    }

    private ChildrenCollectorVisitor childrenCollectorVisitor() {
        if (this.childrenCollectorVisitor == null) {
            this.childrenCollectorVisitor = new ChildrenCollectorVisitor();
        }
        return this.childrenCollectorVisitor;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.problems = null;
    }

    protected final ExpressionValidator expressionValidator(String queryBNF) {
        ExpressionValidator validator = this.validators.get(queryBNF);
        if (validator == null) {
            validator = new ExpressionValidator((JPQLQueryBNF)AbstractExpression.queryBNF(queryBNF));
            this.validators.put(queryBNF, validator);
        }
        return validator;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.validators = new HashMap<String, ExpressionValidator>();
    }

    protected final ExpressionValidator internalOrderByItemBNFValidator(IPlatform platform) {
        if (platform == IPlatform.ECLIPSE_LINK) {
            return this.buildExpressionValidator("internal_orderby_item");
        }
        return this.buildExpressionValidator("state_field_path_expression", "identification_variable", "result_variable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isOwnedByConditionalClause(Expression expression) {
        OwningClauseVisitor visitor = this.owningClauseVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.whereClause != null || visitor.havingClause != null;
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isOwnedByFromClause(Expression expression) {
        OwningClauseVisitor visitor = this.owningClauseVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.fromClause != null;
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isOwnedBySubFromClause(Expression expression) {
        OwningClauseVisitor visitor = this.owningClauseVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.simpleFromClause != null;
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isValid(Expression expression, String queryBNF) {
        ExpressionValidator validator = this.expressionValidator(queryBNF);
        try {
            expression.accept(validator);
            boolean bl = validator.valid;
            return bl;
        }
        finally {
            validator.valid = false;
        }
    }

    protected final boolean isValidJavaIdentifier(String variable) {
        int count = variable.length();
        for (int index = 0; index < count; ++index) {
            char character = variable.charAt(index);
            if (index == 0 && !Character.isJavaIdentifierStart((int)character)) {
                return false;
            }
            if (index <= 0 || Character.isJavaIdentifierPart((int)character)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isValidWithChildCollectionBypass(Expression expression, String queryBNF) {
        ExpressionValidator validator = this.expressionValidator(queryBNF);
        BypassChildCollectionExpressionVisitor bypassValidator = this.bypassChildCollectionExpressionVisitor();
        try {
            bypassValidator.visitor = validator;
            expression.accept(bypassValidator);
            boolean bl = validator.valid;
            return bl;
        }
        finally {
            bypassValidator.visitor = null;
            validator.valid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isValidWithFindQueryBNF(AbstractExpression expression, String queryBNF) {
        ExpressionValidator validator = this.expressionValidator(queryBNF);
        try {
            JPQLQueryBNF childQueryBNF = expression.getParent().findQueryBNF(expression);
            validator.validate(childQueryBNF);
            boolean bl = validator.valid;
            return bl;
        }
        finally {
            validator.valid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isValidWithParentSubExpressionBypass(Expression expression, String queryBNF) {
        ExpressionValidator validator = this.expressionValidator(queryBNF);
        BypassParentSubExpressionVisitor bypassValidator = this.bypassParentSubExpressionVisitor();
        try {
            bypassValidator.visitor = validator;
            expression.accept(bypassValidator);
            boolean bl = validator.valid;
            return bl;
        }
        finally {
            bypassValidator.visitor = null;
            validator.valid = false;
        }
    }

    protected final int length(Expression expression) {
        return expression.toParsedText().length();
    }

    protected final OwningClauseVisitor owningClauseVisitor() {
        if (this.owningClauseVisitor == null) {
            this.owningClauseVisitor = new OwningClauseVisitor();
        }
        return this.owningClauseVisitor;
    }

    protected final int position(Expression expression) {
        return this.calculatePosition(expression, 0);
    }

    public final void setProblems(List<JPQLQueryProblem> problems) {
        this.problems = problems;
    }

    @Override
    protected void visit(Expression expression) {
        expression.acceptChildren(this);
    }

    protected static final class BypassChildCollectionExpressionVisitor
    extends AnonymousExpressionVisitor {
        public ExpressionValidator visitor;

        public void visit(CollectionExpression expression) {
            for (Expression child : expression.getChildren()) {
                child.accept(this);
                if (!this.visitor.valid) break;
            }
        }

        protected void visit(Expression expression) {
            expression.accept(this.visitor);
        }

        public void visit(NullExpression expression) {
        }
    }

    protected static final class BypassParentSubExpressionVisitor
    extends AnonymousExpressionVisitor {
        public ExpressionVisitor visitor;

        protected void visit(Expression expression) {
            expression.accept(this.visitor);
        }

        public void visit(SubExpression expression) {
            expression.getParent().accept(this);
        }
    }

    private static class ChildrenCollectorVisitor
    extends AnonymousExpressionVisitor {
        List<Expression> expressions;

        private ChildrenCollectorVisitor() {
        }

        public void visit(CollectionExpression expression) {
            this.expressions.addAll(Arrays.asList(expression.getChildren()));
        }

        protected void visit(Expression expression) {
            this.expressions.add(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExpressionValidator
    extends AnonymousExpressionVisitor {
        private JPQLQueryBNF queryBNF;
        private JPQLQueryBNF[] queryBNFs;
        public boolean valid;

        protected ExpressionValidator(JPQLQueryBNF queryBNF) {
            this.queryBNF = queryBNF;
        }

        protected ExpressionValidator(JPQLQueryBNF ... queryBNFs) {
            this.queryBNFs = queryBNFs;
        }

        private void allJPQLQueryBNFs(Set<JPQLQueryBNF> queryBNFs, JPQLQueryBNF queryBNF) {
            if (queryBNFs.add(queryBNF) && !queryBNF.isCompound()) {
                for (JPQLQueryBNF childQueryBNF : queryBNF.nonCompoundChildren()) {
                    this.allJPQLQueryBNFs(queryBNFs, childQueryBNF);
                }
            }
        }

        private void validate(JPQLQueryBNF queryBNF) {
            this.valid = false;
            if (this.queryBNFs != null) {
                this.valid = Arrays.asList(this.queryBNFs).contains(queryBNF);
            } else {
                HashSet<JPQLQueryBNF> allQueryBNFs = new HashSet<JPQLQueryBNF>();
                this.allJPQLQueryBNFs(allQueryBNFs, this.queryBNF);
                this.valid = allQueryBNFs.contains(queryBNF);
            }
        }

        @Override
        public void visit(BadExpression expression) {
        }

        @Override
        protected void visit(Expression expression) {
            this.validate(((AbstractExpression)expression).getQueryBNF());
        }

        @Override
        public void visit(NullExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(SubExpression expression) {
            if (expression.hasExpression()) {
                AbstractExpression childExpression = (AbstractExpression)expression.getExpression();
                this.validate(childExpression.getQueryBNF());
            }
        }

        @Override
        public void visit(UnknownExpression expression) {
        }
    }

    protected static final class OwningClauseVisitor
    extends AbstractTraverseParentVisitor {
        public DeleteClause deleteClause;
        public FromClause fromClause;
        public GroupByClause groupByClause;
        public HavingClause havingClause;
        public OrderByClause orderByClause;
        public SelectClause selectClause;
        public SimpleFromClause simpleFromClause;
        public SimpleSelectClause simpleSelectClause;
        public UpdateClause updateClause;
        public WhereClause whereClause;

        protected void dispose() {
            this.deleteClause = null;
            this.fromClause = null;
            this.groupByClause = null;
            this.havingClause = null;
            this.orderByClause = null;
            this.selectClause = null;
            this.simpleFromClause = null;
            this.simpleSelectClause = null;
            this.updateClause = null;
            this.whereClause = null;
        }

        public void visit(DeleteClause expression) {
            this.deleteClause = expression;
        }

        public void visit(FromClause expression) {
            this.fromClause = expression;
        }

        public void visit(GroupByClause expression) {
            this.groupByClause = expression;
        }

        public void visit(HavingClause expression) {
            this.havingClause = expression;
        }

        public void visit(OrderByClause expression) {
            this.orderByClause = expression;
        }

        public void visit(SelectClause expression) {
            this.selectClause = expression;
        }

        public void visit(SimpleFromClause expression) {
            this.simpleFromClause = expression;
        }

        public void visit(SimpleSelectClause expression) {
            this.simpleSelectClause = expression;
        }

        public void visit(UpdateClause expression) {
            this.updateClause = expression;
        }

        public void visit(WhereClause expression) {
            this.whereClause = expression;
        }
    }
}

