/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers.locators;

import org.openqa.selenium.browserlaunchers.locators.SingleBrowserLocator;
import org.openqa.selenium.os.WindowsUtils;

public class InternetExplorerLocator
extends SingleBrowserLocator {
    private static final String[] USUAL_WINDOWS_LAUNCHER_LOCATIONS = new String[]{String.valueOf(WindowsUtils.getProgramFilesPath()) + "\\Internet Explorer"};

    @Override
    protected String browserName() {
        return "Internet Explorer";
    }

    @Override
    protected String seleniumBrowserName() {
        return "iexplore";
    }

    @Override
    protected String[] standardlauncherFilenames() {
        return new String[]{"iexplore.exe"};
    }

    @Override
    protected String browserPathOverridePropertyName() {
        return "internetExplorerDefaultPath";
    }

    @Override
    protected String[] usualLauncherLocations() {
        return WindowsUtils.thisIsWindows() ? USUAL_WINDOWS_LAUNCHER_LOCATIONS : new String[]{};
    }
}

