/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregateFunction
extends AbstractSingleEncapsulatedExpression {
    private boolean hasDistinct;
    private boolean hasSpaceAfterDistinct;

    AggregateFunction(AbstractExpression parent) {
        super(parent);
    }

    @Override
    void addOrderedEncapsulatedExpressionTo(List<StringExpression> children) {
        if (this.hasDistinct) {
            children.add(this.buildStringExpression("DISTINCT"));
        }
        if (this.hasSpaceAfterDistinct) {
            children.add(this.buildStringExpression(' '));
        }
        super.addOrderedEncapsulatedExpressionTo(children);
    }

    AbstractExpression buildEncapsulatedExpression(WordParser wordParser, String word) {
        return new StateFieldPathExpression((AbstractExpression)this, word);
    }

    @Override
    public String encapsulatedExpressionBNF() {
        return "scalar_expression";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return AggregateFunction.queryBNF("aggregate_expression");
    }

    public final boolean hasDistinct() {
        return this.hasDistinct;
    }

    public final boolean hasSpaceAfterDistinct() {
        return this.hasSpaceAfterDistinct;
    }

    @Override
    final void parseEncapsulatedExpression(WordParser wordParser, boolean tolerant) {
        this.hasDistinct = wordParser.startsWithIdentifier("DISTINCT");
        if (this.hasDistinct) {
            wordParser.moveForward("DISTINCT");
            this.hasSpaceAfterDistinct = wordParser.skipLeadingWhitespace() > 0;
        }
        super.parseEncapsulatedExpression(wordParser, tolerant);
    }

    @Override
    void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean includeVirtual) {
        if (this.hasDistinct) {
            writer.append("DISTINCT");
        }
        if (this.hasSpaceAfterDistinct) {
            writer.append(' ');
        }
        super.toParsedTextEncapsulatedExpression(writer, includeVirtual);
    }
}

