/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.font.FontManager;
import sun.font.FontUtilities;

public final class FontManagerFactory {
    private static FontManager instance = null;
    private static final String DEFAULT_CLASS = FontUtilities.isWindows ? "sun.awt.Win32FontManager" : (FontUtilities.isMacOSX ? "sun.font.CFontManager" : "sun.awt.X11FontManager");

    public static synchronized FontManager getInstance() {
        if (instance != null) {
            return instance;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    String string = System.getProperty("sun.font.fontmanager", DEFAULT_CLASS);
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    Class<?> clazz = Class.forName(string, true, classLoader);
                    instance = (FontManager)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    InternalError internalError = new InternalError();
                    internalError.initCause(classNotFoundException);
                    throw internalError;
                }
                catch (InstantiationException instantiationException) {
                    InternalError internalError = new InternalError();
                    internalError.initCause(instantiationException);
                    throw internalError;
                }
                catch (IllegalAccessException illegalAccessException) {
                    InternalError internalError = new InternalError();
                    internalError.initCause(illegalAccessException);
                    throw internalError;
                }
                return null;
            }
        });
        return instance;
    }
}

