/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableIntegerProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class TilePane
extends Pane {
    private static final String MARGIN_CONSTRAINT = "tilepane-margin";
    private static final String ALIGNMENT_CONSTRAINT = "tilepane-alignment";
    private double computedTileWidth = -1.0;
    private double computedTileHeight = -1.0;
    private ObjectProperty<Orientation> orientation;
    private IntegerProperty prefRows;
    private IntegerProperty prefColumns;
    private DoubleProperty prefTileWidth;
    private DoubleProperty prefTileHeight;
    private ReadOnlyDoubleWrapper tileWidth;
    private ReadOnlyDoubleWrapper tileHeight;
    private DoubleProperty hgap;
    private DoubleProperty vgap;
    private ObjectProperty<Pos> alignment;
    private ObjectProperty<Pos> tileAlignment;
    private int actualRows = 0;
    private int actualColumns = 0;

    public static void setAlignment(Node node, Pos pos) {
        TilePane.setConstraint(node, ALIGNMENT_CONSTRAINT, (Object)pos);
    }

    public static Pos getAlignment(Node node) {
        return (Pos)((Object)TilePane.getConstraint(node, ALIGNMENT_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets insets) {
        TilePane.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)TilePane.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        TilePane.setAlignment(node, null);
        TilePane.setMargin(node, null);
    }

    public TilePane() {
    }

    public TilePane(Orientation orientation) {
        this.setOrientation(orientation);
    }

    public TilePane(double d, double d2) {
        this.setHgap(d);
        this.setVgap(d2);
    }

    public TilePane(Orientation orientation, double d, double d2) {
        this();
        this.setOrientation(orientation);
        this.setHgap(d);
        this.setVgap(d2);
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty((Object)Orientation.HORIZONTAL){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ORIENTATION;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)((Object)this.orientation.get());
    }

    public final IntegerProperty prefRowsProperty() {
        if (this.prefRows == null) {
            this.prefRows = new StyleableIntegerProperty(5){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.PREF_ROWS;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "prefRows";
                }
            };
        }
        return this.prefRows;
    }

    public final void setPrefRows(int n) {
        this.prefRowsProperty().set(n);
    }

    public final int getPrefRows() {
        return this.prefRows == null ? 5 : this.prefRows.get();
    }

    public final IntegerProperty prefColumnsProperty() {
        if (this.prefColumns == null) {
            this.prefColumns = new StyleableIntegerProperty(5){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.PREF_COLUMNS;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "prefColumns";
                }
            };
        }
        return this.prefColumns;
    }

    public final void setPrefColumns(int n) {
        this.prefColumnsProperty().set(n);
    }

    public final int getPrefColumns() {
        return this.prefColumns == null ? 5 : this.prefColumns.get();
    }

    public final DoubleProperty prefTileWidthProperty() {
        if (this.prefTileWidth == null) {
            this.prefTileWidth = new StyleableDoubleProperty(-1.0){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.PREF_TILE_WIDTH;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "prefTileWidth";
                }
            };
        }
        return this.prefTileWidth;
    }

    public final void setPrefTileWidth(double d) {
        this.prefTileWidthProperty().set(d);
    }

    public final double getPrefTileWidth() {
        return this.prefTileWidth == null ? -1.0 : this.prefTileWidth.get();
    }

    public final DoubleProperty prefTileHeightProperty() {
        if (this.prefTileHeight == null) {
            this.prefTileHeight = new StyleableDoubleProperty(-1.0){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.PREF_TILE_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "prefTileHeight";
                }
            };
        }
        return this.prefTileHeight;
    }

    public final void setPrefTileHeight(double d) {
        this.prefTileHeightProperty().set(d);
    }

    public final double getPrefTileHeight() {
        return this.prefTileHeight == null ? -1.0 : this.prefTileHeight.get();
    }

    public final ReadOnlyDoubleProperty tileWidthProperty() {
        return this.tileWidthPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper tileWidthPropertyImpl() {
        if (this.tileWidth == null) {
            this.tileWidth = new ReadOnlyDoubleWrapper(this, "tileWidth", 0.0);
        }
        return this.tileWidth;
    }

    private void setTileWidth(double d) {
        this.tileWidthPropertyImpl().set(d);
    }

    public final double getTileWidth() {
        return this.tileWidth == null ? 0.0 : this.tileWidth.get();
    }

    public final ReadOnlyDoubleProperty tileHeightProperty() {
        return this.tileHeightPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper tileHeightPropertyImpl() {
        if (this.tileHeight == null) {
            this.tileHeight = new ReadOnlyDoubleWrapper(this, "tileHeight", 0.0);
        }
        return this.tileHeight;
    }

    private void setTileHeight(double d) {
        this.tileHeightPropertyImpl().set(d);
    }

    public final double getTileHeight() {
        return this.tileHeight == null ? 0.0 : this.tileHeight.get();
    }

    public final DoubleProperty hgapProperty() {
        if (this.hgap == null) {
            this.hgap = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.HGAP;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "hgap";
                }
            };
        }
        return this.hgap;
    }

    public final void setHgap(double d) {
        this.hgapProperty().set(d);
    }

    public final double getHgap() {
        return this.hgap == null ? 0.0 : this.hgap.get();
    }

    public final DoubleProperty vgapProperty() {
        if (this.vgap == null) {
            this.vgap = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.VGAP;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "vgap";
                }
            };
        }
        return this.vgap;
    }

    public final void setVgap(double d) {
        this.vgapProperty().set(d);
    }

    public final double getVgap() {
        return this.vgap == null ? 0.0 : this.vgap.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    public final ObjectProperty<Pos> tileAlignmentProperty() {
        if (this.tileAlignment == null) {
            this.tileAlignment = new StyleableObjectProperty<Pos>(Pos.CENTER){

                @Override
                public void invalidated() {
                    TilePane.this.requestLayout();
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.TILE_ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return TilePane.this;
                }

                @Override
                public String getName() {
                    return "tileAlignment";
                }
            };
        }
        return this.tileAlignment;
    }

    public final void setTileAlignment(Pos pos) {
        this.tileAlignmentProperty().set(pos);
    }

    public final Pos getTileAlignment() {
        return this.tileAlignment == null ? Pos.CENTER : (Pos)((Object)this.tileAlignment.get());
    }

    @Override
    public Orientation getContentBias() {
        return this.getOrientation();
    }

    @Override
    public void requestLayout() {
        this.computedTileWidth = -1.0;
        this.computedTileHeight = -1.0;
        super.requestLayout();
    }

    @Override
    protected double computeMinWidth(double d) {
        if (this.getContentBias() == Orientation.HORIZONTAL) {
            return this.getInsets().getLeft() + this.computeTileWidth(this.getManagedChildren()) + this.getInsets().getRight();
        }
        return this.computePrefWidth(d);
    }

    @Override
    protected double computeMinHeight(double d) {
        if (this.getContentBias() == Orientation.VERTICAL) {
            return this.getInsets().getTop() + this.computeTileHeight(this.getManagedChildren()) + this.getInsets().getBottom();
        }
        return this.computePrefHeight(d);
    }

    @Override
    protected double computePrefWidth(double d) {
        List<Node> list = this.getManagedChildren();
        Insets insets = this.getInsets();
        this.setTileWidth(this.computeTileWidth(list));
        int n = 0;
        if (d != -1.0) {
            this.setTileHeight(this.computeTileHeight(list));
            int n2 = this.computeRows(d - this.snapSpace(insets.getTop()) - this.snapSpace(insets.getBottom()), this.getTileHeight());
            n = this.computeOther(list.size(), n2);
        } else {
            n = this.getOrientation() == Orientation.HORIZONTAL ? this.getPrefColumns() : this.computeOther(list.size(), this.getPrefRows());
        }
        return this.snapSpace(insets.getLeft()) + this.computeContentWidth(n, this.getTileWidth()) + this.snapSpace(insets.getRight());
    }

    @Override
    protected double computePrefHeight(double d) {
        List<Node> list = this.getManagedChildren();
        Insets insets = this.getInsets();
        this.setTileHeight(this.computeTileHeight(list));
        int n = 0;
        if (d != -1.0) {
            this.setTileWidth(this.computeTileWidth(list));
            int n2 = this.computeColumns(d - this.snapSpace(insets.getLeft()) - this.snapSpace(insets.getRight()), this.getTileWidth());
            n = this.computeOther(list.size(), n2);
        } else {
            n = this.getOrientation() == Orientation.HORIZONTAL ? this.computeOther(list.size(), this.getPrefColumns()) : this.getPrefRows();
        }
        return this.snapSpace(insets.getTop()) + this.computeContentHeight(n, this.getTileHeight()) + this.snapSpace(insets.getBottom());
    }

    private Insets[] getMargins(List<Node> list) {
        Insets[] insetsArray = new Insets[list.size()];
        for (int i = 0; i < insetsArray.length; ++i) {
            insetsArray[i] = TilePane.getMargin(list.get(i));
        }
        return insetsArray;
    }

    private double computeTileWidth(List<Node> list) {
        double d = this.getPrefTileWidth();
        if (d == -1.0) {
            if (this.computedTileWidth == -1.0) {
                Insets[] insetsArray = this.getMargins(list);
                double d2 = -1.0;
                boolean bl = false;
                for (Node node : list) {
                    if (node.getContentBias() != Orientation.VERTICAL) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    d2 = this.computeMaxPrefAreaHeight(list, insetsArray, -1.0, this.getTileAlignment().getVpos());
                }
                this.computedTileWidth = this.computeMaxPrefAreaWidth(list, insetsArray, d2, this.getTileAlignment().getHpos());
            }
            return this.snapSize(this.computedTileWidth);
        }
        return this.snapSize(d);
    }

    private double computeTileHeight(List<Node> list) {
        double d = this.getPrefTileHeight();
        if (d == -1.0) {
            if (this.computedTileHeight == -1.0) {
                Insets[] insetsArray = this.getMargins(list);
                double d2 = -1.0;
                boolean bl = false;
                for (Node node : list) {
                    if (node.getContentBias() != Orientation.HORIZONTAL) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    d2 = this.computeMaxPrefAreaWidth(list, insetsArray, -1.0, this.getTileAlignment().getHpos());
                }
                this.computedTileHeight = this.computeMaxPrefAreaHeight(list, this.getMargins(list), d2, this.getTileAlignment().getVpos());
            }
            return this.snapSize(this.computedTileHeight);
        }
        return this.snapSize(d);
    }

    private int computeOther(int n, int n2) {
        double d = (double)n / (double)Math.max(1, n2);
        return (int)Math.ceil(d);
    }

    private int computeColumns(double d, double d2) {
        return Math.max(1, (int)((d + this.snapSpace(this.getHgap())) / (d2 + this.snapSpace(this.getHgap()))));
    }

    private int computeRows(double d, double d2) {
        return Math.max(1, (int)((d + this.snapSpace(this.getVgap())) / (d2 + this.snapSpace(this.getVgap()))));
    }

    private double computeContentWidth(int n, double d) {
        return (double)n * d + (double)(n - 1) * this.snapSpace(this.getHgap());
    }

    private double computeContentHeight(int n, double d) {
        return (double)n * d + (double)(n - 1) * this.snapSpace(this.getVgap());
    }

    @Override
    protected void layoutChildren() {
        List<Node> list = this.getManagedChildren();
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.snapSpace(this.getInsets().getTop());
        double d4 = this.snapSpace(this.getInsets().getLeft());
        double d5 = this.snapSpace(this.getInsets().getBottom());
        double d6 = this.snapSpace(this.getInsets().getRight());
        double d7 = this.snapSpace(this.getVgap());
        double d8 = this.snapSpace(this.getHgap());
        double d9 = d - d4 - d6;
        double d10 = d2 - d3 - d5;
        this.setTileWidth(this.computeTileWidth(list));
        this.setTileHeight(this.computeTileHeight(list));
        int n = 0;
        int n2 = 0;
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            this.actualColumns = this.computeColumns(d9, this.getTileWidth());
            this.actualRows = this.computeOther(list.size(), this.actualColumns);
            n = this.getAlignment().getHpos() != HPos.LEFT ? this.actualColumns - (this.actualColumns * this.actualRows - list.size()) : 0;
        } else {
            this.actualRows = this.computeRows(d10, this.getTileHeight());
            this.actualColumns = this.computeOther(list.size(), this.actualRows);
            n2 = this.getAlignment().getVpos() != VPos.TOP ? this.actualRows - (this.actualColumns * this.actualRows - list.size()) : 0;
        }
        double d11 = d4 + TilePane.computeXOffset(d9, this.computeContentWidth(this.actualColumns, this.getTileWidth()), this.getAlignment().getHpos());
        double d12 = d3 + TilePane.computeYOffset(d10, this.computeContentHeight(this.actualRows, this.getTileHeight()), this.getAlignment().getVpos());
        double d13 = n > 0 ? d4 + TilePane.computeXOffset(d9, this.computeContentWidth(n, this.getTileWidth()), this.getAlignment().getHpos()) : d11;
        double d14 = n2 > 0 ? d3 + TilePane.computeYOffset(d10, this.computeContentHeight(n2, this.getTileHeight()), this.getAlignment().getVpos()) : d12;
        double d15 = this.getTileAlignment().getVpos() == VPos.BASELINE ? TilePane.getMaxBaselineOffset(list) : this.getTileHeight() / 2.0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            double d16 = n3 == this.actualRows - 1 ? d13 : d11;
            double d17 = n4 == this.actualColumns - 1 ? d14 : d12;
            double d18 = d16 + (double)n4 * (this.getTileWidth() + d8);
            double d19 = d17 + (double)n3 * (this.getTileHeight() + d7);
            Pos pos = TilePane.getAlignment(node);
            this.layoutInArea(node, d18, d19, this.getTileWidth(), this.getTileHeight(), d15, TilePane.getMargin(node), pos != null ? pos.getHpos() : this.getTileAlignment().getHpos(), pos != null ? pos.getVpos() : this.getTileAlignment().getVpos());
            if (this.getOrientation() == Orientation.HORIZONTAL) {
                if (++n4 != this.actualColumns) continue;
                n4 = 0;
                ++n3;
                continue;
            }
            if (++n3 != this.actualRows) continue;
            n3 = 0;
            ++n4;
        }
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return TilePane.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<TilePane, Pos> ALIGNMENT = new StyleableProperty<TilePane, Pos>("-fx-alignment", new EnumConverter(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(TilePane tilePane) {
                return tilePane.alignment == null || !tilePane.alignment.isBound();
            }

            @Override
            public WritableValue<Pos> getWritableValue(TilePane tilePane) {
                return tilePane.alignmentProperty();
            }
        };
        private static final StyleableProperty<TilePane, Number> PREF_COLUMNS = new StyleableProperty<TilePane, Number>("-fx-pref-columns", (StyleConverter)SizeConverter.getInstance(), (Number)5.0){

            @Override
            public void set(TilePane tilePane, Number number, Stylesheet.Origin origin) {
                super.set(tilePane, number.intValue(), origin);
            }

            @Override
            public boolean isSettable(TilePane tilePane) {
                return tilePane.prefColumns == null || !tilePane.prefColumns.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(TilePane tilePane) {
                return tilePane.prefColumnsProperty();
            }
        };
        private static final StyleableProperty<TilePane, Number> HGAP = new StyleableProperty<TilePane, Number>("-fx-hgap", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(TilePane tilePane) {
                return tilePane.hgap == null || !tilePane.hgap.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(TilePane tilePane) {
                return tilePane.hgapProperty();
            }
        };
        private static final StyleableProperty<TilePane, Number> PREF_ROWS = new StyleableProperty<TilePane, Number>("-fx-pref-rows", (StyleConverter)SizeConverter.getInstance(), (Number)5.0){

            @Override
            public void set(TilePane tilePane, Number number, Stylesheet.Origin origin) {
                super.set(tilePane, number.intValue(), origin);
            }

            @Override
            public boolean isSettable(TilePane tilePane) {
                return tilePane.prefRows == null || !tilePane.prefRows.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(TilePane tilePane) {
                return tilePane.prefRowsProperty();
            }
        };
        private static final StyleableProperty<TilePane, Pos> TILE_ALIGNMENT = new StyleableProperty<TilePane, Pos>("-fx-tile-alignment", new EnumConverter(Pos.class), Pos.CENTER){

            @Override
            public boolean isSettable(TilePane tilePane) {
                return tilePane.tileAlignment == null || !tilePane.tileAlignment.isBound();
            }

            @Override
            public WritableValue<Pos> getWritableValue(TilePane tilePane) {
                return tilePane.tileAlignmentProperty();
            }
        };
        private static final StyleableProperty<TilePane, Number> PREF_TILE_WIDTH = new StyleableProperty<TilePane, Number>("-fx-pref-tile-width", (StyleConverter)SizeConverter.getInstance(), (Number)-1.0){

            @Override
            public boolean isSettable(TilePane tilePane) {
                return tilePane.prefTileWidth == null || !tilePane.prefTileWidth.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(TilePane tilePane) {
                return tilePane.prefTileWidthProperty();
            }
        };
        private static final StyleableProperty<TilePane, Number> PREF_TILE_HEIGHT = new StyleableProperty<TilePane, Number>("-fx-pref-tile-height", (StyleConverter)SizeConverter.getInstance(), (Number)-1.0){

            @Override
            public boolean isSettable(TilePane tilePane) {
                return tilePane.prefTileHeight == null || !tilePane.prefTileHeight.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(TilePane tilePane) {
                return tilePane.prefTileHeightProperty();
            }
        };
        private static final StyleableProperty<TilePane, Orientation> ORIENTATION = new StyleableProperty<TilePane, Orientation>("-fx-orientation", new EnumConverter(Orientation.class), Orientation.HORIZONTAL){

            @Override
            public Orientation getInitialValue(TilePane tilePane) {
                return tilePane.getOrientation();
            }

            @Override
            public boolean isSettable(TilePane tilePane) {
                return tilePane.orientation == null || !tilePane.orientation.isBound();
            }

            @Override
            public WritableValue<Orientation> getWritableValue(TilePane tilePane) {
                return tilePane.orientationProperty();
            }
        };
        private static final StyleableProperty<TilePane, Number> VGAP = new StyleableProperty<TilePane, Number>("-fx-vgap", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(TilePane tilePane) {
                return tilePane.vgap == null || !tilePane.vgap.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(TilePane tilePane) {
                return tilePane.vgapProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Region.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ALIGNMENT, HGAP, ORIENTATION, PREF_COLUMNS, PREF_ROWS, PREF_TILE_WIDTH, PREF_TILE_HEIGHT, TILE_ALIGNMENT, VGAP);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

