/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.osgi;

import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

class OSGiRepository
extends Repository {
    private static final Logger LOG = Logger.getLogger(OSGiRepository.class.getName());
    public static final OSGiRepository DEFAULT = new OSGiRepository();
    private final SFS fs;

    private OSGiRepository() {
        this(new SFS());
    }

    private OSGiRepository(SFS fs) {
        super((FileSystem)fs);
        this.fs = fs;
    }

    private static URL[] layersFor(List<Bundle> bundles) {
        ArrayList<URL> layers = new ArrayList<URL>(2);
        for (Bundle b : bundles) {
            URL generated;
            if (b.getSymbolicName().equals("org.netbeans.modules.autoupdate.ui")) continue;
            String explicit = (String)b.getHeaders().get("OpenIDE-Module-Layer");
            if (explicit != null) {
                String ext;
                String base;
                int idx = explicit.lastIndexOf(46);
                if (idx == -1) {
                    base = explicit;
                    ext = "";
                } else {
                    base = explicit.substring(0, idx);
                    ext = explicit.substring(idx);
                }
                for (String suffix : NbCollections.iterable((Iterator)NbBundle.getLocalizingSuffixes())) {
                    URL layer = b.getResource(base + suffix + ext);
                    if (layer != null) {
                        layers.add(layer);
                        continue;
                    }
                    if (!suffix.isEmpty()) continue;
                    LOG.log(Level.WARNING, "no such layer {0} in {1} of state {2}", new Object[]{explicit, b.getSymbolicName(), b.getState()});
                }
            }
            if ((generated = b.getResource("META-INF/generated-layer.xml")) == null) continue;
            layers.add(generated);
        }
        return layers.toArray(new URL[layers.size()]);
    }

    public void addLayersFor(List<Bundle> bundles) {
        URL[] resources = OSGiRepository.layersFor(bundles);
        if (resources.length > 0) {
            this.fs.addLayers(resources);
        }
    }

    public void removeLayersFor(List<Bundle> bundles) {
        URL[] resources = OSGiRepository.layersFor(bundles);
        if (resources.length > 0) {
            this.fs.removeLayers(resources);
        }
    }

    private static final class SFS
    extends MultiFileSystem
    implements LookupListener {
        private final Map<String, FileSystem> fss = new HashMap<String, FileSystem>();
        private final FileSystem userdir;
        private final Layers layers;
        private final Lookup.Result<FileSystem> dynamic = Lookup.getDefault().lookupResult(FileSystem.class);

        SFS() {
            this.dynamic.addLookupListener((LookupListener)this);
            this.layers = new Layers();
            File config = null;
            String netbeansUser = System.getProperty("netbeans.user");
            if (netbeansUser != null) {
                config = new File(netbeansUser, "config");
            }
            if (config != null && (config.isDirectory() || config.mkdirs())) {
                LocalFileSystem lfs = new LocalFileSystem();
                try {
                    lfs.setRootDirectory(config);
                }
                catch (Exception x) {
                    LOG.log(Level.WARNING, "Could not set userdir: " + config, x);
                }
                this.userdir = lfs;
            } else {
                this.userdir = FileUtil.createMemoryFileSystem();
            }
            this.resetAll();
            try {
                this.setSystemName("SystemFileSystem");
            }
            catch (PropertyVetoException x) {
                throw new AssertionError((Object)x);
            }
        }

        private synchronized void addLayers(URL ... resources) {
            LOG.log(Level.FINE, "addLayers: {0}", Arrays.asList(resources));
            for (URL resource : resources) {
                try {
                    this.fss.put(resource.toString(), (FileSystem)new XMLFileSystem(resource));
                }
                catch (SAXException x) {
                    LOG.log(Level.WARNING, "Could not parse layer: " + resource, x);
                }
            }
            this.resetLayers();
        }

        private synchronized void removeLayers(URL ... resources) {
            for (URL resource : resources) {
                this.fss.remove(resource.toString());
            }
            this.resetLayers();
        }

        private void resetLayers() {
            this.layers._setDelegates(this.fss.values());
        }

        private void resetAll() {
            ArrayList<Object> delegates = new ArrayList<Object>();
            delegates.add(this.userdir);
            Collection dyn = this.dynamic.allInstances();
            LOG.log(Level.FINE, "dyn={0}", dyn);
            for (FileSystem fs : dyn) {
                if (Boolean.TRUE.equals(fs.getRoot().getAttribute("fallback"))) continue;
                delegates.add(fs);
            }
            delegates.add((Object)this.layers);
            for (FileSystem fs : dyn) {
                if (!Boolean.TRUE.equals(fs.getRoot().getAttribute("fallback"))) continue;
                delegates.add(fs);
            }
            this.setDelegates(delegates.toArray(new FileSystem[delegates.size()]));
            assert (this.getRoot().isValid());
            assert (!this.isReadOnly()) : delegates;
        }

        public void resultChanged(LookupEvent ev) {
            this.resetAll();
        }

        static {
            Class<FileSystem.Environment> _1 = FileSystem.Environment.class;
            Class<FileSystemCapability> _2 = FileSystemCapability.class;
            Class<FileStatusListener> _3 = FileStatusListener.class;
            Class<LookupEvent> clazz = LookupEvent.class;
        }

        private static final class Layers
        extends MultiFileSystem {
            Layers() {
                this.setPropagateMasks(true);
            }

            void _setDelegates(Collection<FileSystem> delegates) {
                this.setDelegates(delegates.toArray(new FileSystem[delegates.size()]));
            }
        }
    }
}

