/*
 * Decompiled with CFR 0.152.
 */
package org.shop.tools;

import demo.Claims;
import demo.Components;
import demo.Exposure;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.shop.tools.Combohelper;
import org.shop.tools.EntityService;

public class EngineClm {
    Integer client;
    Integer version;
    Integer polnum;
    String PU;
    Claims policy;
    Exposure exposure;
    HashMap hmUnsorted = new HashMap();
    Map<String, Combohelper> hm;
    String err;
    String renewalDate;
    Integer counter = 0;
    Integer shift = 0;
    List<Component> componentList;
    private final String[][] arrCoverage = new String[][]{{"1", "Unknown", "Unknown"}, {"2", "Mandatory", "Mandatory"}, {"3", "Physical", "Physical"}, {"4", "TP", "Third Party"}, {"5", "BI", "Bodily Injury"}, {"6", "PD", "Property Damage"}, {"7", "DC", "Direct Compensation"}, {"8", "AB", "Accident Benefits"}, {"9", "UA", "Uninsured Auto"}, {"10", "UM", "Underinsured Auto"}, {"11", "CL", "Collision"}, {"12", "CM", "Comprehensive"}, {"13", "SP", "Specified Perils"}, {"14", "AP", "All Perils"}, {"15", "SA", "Section A"}, {"16", "PHPD", "PHPD"}, {"17", "PHBI", "PHBI"}};
    String[] names = new String[]{"UA", "UM", "BI", "PD", "DC", "SA", "TP", "AB", "CL", "CM", "SP", "AP", "PHPD", "PHBI"};
    private final String[][] arrPeriod = new String[][]{{"1", "0.0 - 1.0 Years Prior"}, {"2", "1.0 - 2.0 Years Prior"}, {"3", "2.0 - 3.0 Years Prior"}, {"4", "3.0 - 4.0 Years Prior"}, {"5", "4.0 - 5.0 Years Prior"}};
    private final String[][] arrComponents = new String[][]{{"JFormattedTextField", "ValuationDate"}, {"JFormattedTextField", "ClaimDate"}, {"JComboBox", "Province"}, {"JComboBox", "Vehicle"}, {"JComboBox", "Cov"}, {"JComboBox", "Periods"}, {"JTextField", "Amount"}, {"JTextField", "Counts"}};

    void setParameters(Claims rec) {
        rec.setMsl(Float.valueOf(-1.0f));
        rec.setPolnum(this.exposure.getPolnum());
        rec.setPolicynumber(this.exposure.getPolicynumber());
        rec.setVersion(this.exposure.getVersion());
        rec.setUsers(Integer.valueOf(0));
        rec.setClient(this.exposure.getClient());
        rec.setUsers(this.exposure.getUsers());
        rec.setUsersgroup(this.exposure.getUsersgroup());
        this.policy = rec;
        this.version = this.policy.getVersion();
        this.client = this.policy.getClient();
        this.polnum = this.policy.getPolnum();
        this.err = "";
    }

    void setDate(String dt) {
        this.renewalDate = dt;
    }

    void setPeriodDate(Claims rec) {
        Combohelper ch;
        Integer prd;
        Long elapse;
        SimpleDateFormat df = new SimpleDateFormat("d-MMM-yyyy");
        Date NewDateHi = null;
        Date NewDateLo = null;
        String strPeriods = "null";
        String widget = "ValuationDate";
        Date ValuationDate = new Date();
        Date ClaimDate = null;
        Integer periods = rec.getPeriods();
        String[] desarraySource = this.initSplit(rec.getDescription());
        String strClaimDate = this.SrchPair(desarraySource, "ClaimDate");
        if (strClaimDate.length() > 0) {
            try {
                ClaimDate = df.parse(strClaimDate);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        if (this.renewalDate.length() > 0) {
            try {
                ValuationDate = df.parse(this.renewalDate);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(ValuationDate);
        cal.add(1, this.shift);
        ValuationDate = cal.getTime();
        String strValuationDate = df.format(ValuationDate);
        if (widget.equals("Periods")) {
            if (ValuationDate == null && ClaimDate == null) {
                ValuationDate = new Date();
                cal.setTime(ValuationDate);
                cal.add(1, -periods.intValue());
                cal.add(2, 6);
                ClaimDate = cal.getTime();
            } else if (ValuationDate != null && ClaimDate == null) {
                cal.setTime(ValuationDate);
                cal.add(1, -periods.intValue());
                cal.add(2, 6);
                ClaimDate = cal.getTime();
            } else if (ValuationDate == null && ClaimDate != null) {
                cal.setTime(ClaimDate);
                cal.add(1, periods);
                cal.add(2, -6);
                ValuationDate = cal.getTime();
            } else if (ValuationDate != null && ClaimDate != null) {
                cal.setTime(ClaimDate);
                cal.add(1, periods - 1);
                NewDateLo = cal.getTime();
                cal.add(1, 1);
                NewDateHi = cal.getTime();
                if (ValuationDate.after(NewDateHi) || ValuationDate.equals(NewDateHi)) {
                    cal.add(5, -1);
                    ValuationDate = cal.getTime();
                } else if (ValuationDate.before(NewDateLo)) {
                    ValuationDate = NewDateLo;
                }
            }
            strValuationDate = df.format(ValuationDate);
            strClaimDate = df.format(ClaimDate);
        } else if (widget.equals("ValuationDate") && ValuationDate != null) {
            if (periods == null && ClaimDate == null) {
                periods = 1;
                cal.setTime(ValuationDate);
                cal.add(1, -periods.intValue());
                cal.add(2, 6);
                ClaimDate = cal.getTime();
            } else if (periods != null && ClaimDate == null) {
                cal.setTime(ValuationDate);
                cal.add(1, -periods.intValue());
                cal.add(2, 6);
                ClaimDate = cal.getTime();
            } else if (ClaimDate != null) {
                elapse = (ValuationDate.getTime() - ClaimDate.getTime()) / 31536000000L;
                prd = Math.max(0, elapse.intValue());
                periods = 1 + Math.min(4, prd);
            }
            ch = this.hm.get("Periods" + periods);
            if (ch != null) {
                strPeriods = ch.getDisplay();
            }
            rec.setPeriods(periods);
            strClaimDate = df.format(ClaimDate);
        } else if (widget.equals("ClaimDate") && ClaimDate != null) {
            if (periods == null && ValuationDate == null) {
                periods = 1;
                cal.setTime(ClaimDate);
                cal.add(1, periods);
                cal.add(2, -6);
                ValuationDate = cal.getTime();
            } else if (periods != null && ValuationDate == null) {
                cal.setTime(ClaimDate);
                cal.add(1, periods);
                cal.add(2, -6);
                ValuationDate = cal.getTime();
            } else if (ValuationDate != null) {
                elapse = (ValuationDate.getTime() - ClaimDate.getTime()) / 31536000000L;
                prd = Math.max(0, elapse.intValue());
                periods = 1 + Math.min(4, prd);
            }
            ch = this.hm.get("Periods" + periods);
            if (ch != null) {
                strPeriods = ch.getDisplay();
            }
            rec.setPeriods(periods);
            strValuationDate = df.format(ValuationDate);
        }
        String hold = this.SetPair(desarraySource, "ValuationDate", strValuationDate);
        desarraySource = this.initSplit(hold);
        hold = this.SetPair(desarraySource, "ClaimDate", strClaimDate);
        desarraySource = this.initSplit(hold);
        hold = this.SetPair(desarraySource, "Periods", strPeriods);
        Integer in = hold.length() > 250 ? 250 : hold.length();
        rec.setDescription(hold.substring(0, in));
    }

    String[] initSplit(String str) {
        String[] blank = new String[]{};
        String[] lineSplit = new String[]{};
        if (str == null || str.length() == 0) {
            lineSplit = blank;
        } else {
            lineSplit = str.substring(1).split(":", -99);
            if (lineSplit.length < 2) {
                lineSplit = blank;
            }
        }
        return lineSplit;
    }

    String SrchPair(String[] arr, String srch) {
        String found = "";
        for (int i = 1; i < arr.length; i += 2) {
            if (!srch.equals(arr[i - 1])) continue;
            return arr[i];
        }
        return found;
    }

    String SetPair(String[] arr, String srch, String set) {
        int i;
        String desc = "";
        Boolean found = false;
        for (i = 1; i < arr.length; i += 2) {
            if (srch.equals(arr[i - 1])) {
                found = true;
                arr[i] = set;
                if (set.isEmpty()) continue;
            }
            desc = desc + ":" + arr[i - 1] + ":" + arr[i];
        }
        desc = found == false ? desc + ":" + srch + ":" + set : desc;
        desc = i == arr.length ? desc + ":" + arr[i - 1] : desc;
        return desc;
    }

    void init(String pu, Exposure expo, Integer shft) {
        this.exposure = expo;
        this.PU = pu;
        this.shift = shft;
    }

    void setPolicy(Claims pol) {
        this.policy = pol;
    }

    void startProcess() throws IllegalArgumentException {
        try {
            this.process(this.policy);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    void process(Claims rec) {
        this.counter = this.counter + 1;
        System.out.println("STARTING NEW BATCH PROCESS " + this.counter);
        this.setParameters(rec);
        this.hmUnsorted.clear();
        this.hm = null;
        if (this.hm == null) {
            System.out.println("Compiling rates for Claims Rate Table");
            this.hm = new TreeMap<String, Combohelper>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            this.initPrimary();
            this.initSecondary();
            this.hm.putAll(this.hmUnsorted);
        }
        if (this.hm.isEmpty()) {
            this.err = this.err + "\nClaims Rate Table cannot be loaded";
        }
        this.populatePrimary(rec);
        this.setPeriodDate(rec);
        if (!this.err.isEmpty()) {
            this.err = "CLAIMS ERROR LIST:" + this.err;
            throw new IllegalArgumentException(this.err);
        }
        rec.setNumber(null);
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        entityManager.getTransaction().begin();
        entityManager.merge((Object)rec);
        entityManager.persist((Object)rec);
        entityManager.getTransaction().commit();
    }

    void initPrimary() {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList2 = entityManager.createNamedQuery("Components.groupname2").setParameter("client", (Object)this.client).setParameter("version", (Object)this.version).getResultList();
        for (String c2 : resultList2) {
            Combohelper ch;
            String name = c2;
            if (name.equals("Limitall")) continue;
            List resultList3 = entityManager.createNamedQuery("Components.series.province.vehicle.name.all").setParameter("client", (Object)this.client).setParameter("version", (Object)this.version).setParameter("province", (Object)0).setParameter("vehicle", (Object)0).setParameter("series", (Object)1).setParameter("name", (Object)name).getResultList();
            String type = "";
            Object cb = null;
            Integer index = -1;
            Components c32 = null;
            for (Components c32 : resultList3) {
                type = c32.getTyped();
                index = c32.getInitindex();
                if (!type.equals("JComboBox")) continue;
            }
            if (!type.equals("JComboBox")) continue;
            Integer count = 0;
            System.out.println("ClaimsCode:initPrimary " + name);
            for (Components c32 : resultList3) {
                if (!this.i2b(c32.getInitread()).booleanValue() || !c32.getCoverage().equals("Display")) continue;
                ch = new Combohelper(c32.getCode() - 1, c32.getDisplay());
                this.hmUnsorted.put(name + "," + c32.getCode(), ch);
            }
            for (Components c32 : resultList3) {
                if (this.i2b(c32.getInitread()).booleanValue() && c32.getCoverage().equals("Code")) {
                    ch = (Combohelper)this.hmUnsorted.get(name + "," + c32.getCode());
                    ch.setCode(c32.getFactor().intValue());
                    this.hmUnsorted.put(name + ch.getCode(), ch);
                    count = count + 1;
                    continue;
                }
                if (!this.i2b(c32.getInitread()).booleanValue() || !c32.getCoverage().equals("Info")) continue;
                ch = (Combohelper)this.hmUnsorted.get(name + "," + c32.getCode());
                ch.setDesc(c32.getDisplay());
            }
            if (count.equals(2)) {
                this.hmUnsorted.remove(name + "0");
            } else {
                Combohelper ch2 = new Combohelper();
                this.hmUnsorted.put(name + "0", ch2);
                ch2.setCode(0);
                ch2.setDisplay("Unknown");
                ch2.setDesc("UNK");
            }
            for (Components c32 : resultList3) {
                if (!this.i2b(c32.getInitread()).booleanValue() || !"Code".equals(c32.getCoverage())) continue;
                this.hmUnsorted.remove(name + "," + c32.getCode());
            }
        }
    }

    void initSecondary() {
        Combohelper ch;
        int i;
        for (i = 0; i < this.arrCoverage.length; ++i) {
            ch = new Combohelper(Integer.parseInt(this.arrCoverage[i][0]), this.arrCoverage[i][2]);
            this.hmUnsorted.put("Cov" + this.arrCoverage[i][0], ch);
        }
        for (i = 0; i < this.arrPeriod.length; ++i) {
            ch = new Combohelper(Integer.parseInt(this.arrPeriod[i][0]), this.arrPeriod[i][1]);
            this.hmUnsorted.put("Periods" + this.arrPeriod[i][0], ch);
        }
    }

    void populatePrimary(Claims rec) {
        String str = "";
        String hold = "";
        Combohelper ch = null;
        SimpleDateFormat df = new SimpleDateFormat("d-MMM-yyyy");
        String[] desarraySource = this.initSplit(rec.getDescription());
        for (int i = 0; i < this.arrComponents.length; ++i) {
            String type = this.arrComponents[i][0];
            String name = this.arrComponents[i][1];
            if (type.equals("JComboBox")) {
                ch = this.hm.get(name + this.getInteger(rec, name));
                hold = ch != null ? ch.getDisplay() : "null";
            } else if (type.equals("JTextField")) {
                Float flt = this.getFloatnull(this.policy, name);
                if (flt == null) {
                    hold = "null";
                    ch = null;
                } else {
                    hold = flt.toString();
                    ch = new Combohelper();
                }
            } else if (type.equals("JFormattedTextField")) {
                hold = this.SrchPair(desarraySource, name);
                ch = new Combohelper();
                if (hold.length() > 0) {
                    try {
                        Date aDate = df.parse(hold);
                    }
                    catch (ParseException ex) {
                        ch = null;
                    }
                }
            }
            if (ch == null) {
                this.err = this.err + "\nerroneous value [" + hold + "] for field = " + name + " of type = " + type;
                continue;
            }
            str = str + ":" + name + ":" + hold;
        }
        Integer in = str.length() > 250 ? 250 : str.length();
        rec.setDescription(str.substring(0, in));
    }

    long elapsedtime(long start) {
        long end = System.currentTimeMillis();
        long timeelapsed = (end - start) / 1000L;
        long seconds = timeelapsed % 60L;
        long minutes = timeelapsed % 3600L / 60L;
        System.out.println("Milliseconds" + (end - start) + "Total Seconds Elapsed: " + timeelapsed + ", (minutes:" + minutes + " seconds:" + seconds + ")");
        return end;
    }

    Integer getInteger(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Integer in = 0;
        try {
            in = (Integer)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? 0 : in;
    }

    String getString(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        String in = "";
        try {
            in = (String)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? "" : in;
    }

    Float getFloatnull(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Float in = Float.valueOf(0.0f);
        try {
            in = (Float)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in;
    }

    Boolean i2b(Integer i) {
        return i == null ? false : i == 1;
    }
}

