/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.base.Throwables;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverCommandExecutor;

@Beta
public class MarionetteDriver
extends RemoteWebDriver {
    private static final int DEFAULT_PORT = 0;

    public MarionetteDriver() {
        this(null, null, 0);
    }

    public MarionetteDriver(Capabilities capabilities) {
        this(null, capabilities, 0);
    }

    public MarionetteDriver(int port) {
        this(null, null, port);
    }

    public MarionetteDriver(GeckoDriverService service) {
        this(service, null, 0);
    }

    public MarionetteDriver(GeckoDriverService service, Capabilities capabilities) {
        this(service, capabilities, 0);
    }

    public MarionetteDriver(GeckoDriverService service, Capabilities capabilities, int port) {
        if (capabilities == null) {
            capabilities = DesiredCapabilities.firefox();
        }
        if (service == null) {
            service = this.setupService(port);
        }
        this.run(service, capabilities);
    }

    private void run(GeckoDriverService service, Capabilities capabilities) {
        this.setCommandExecutor(new DriverCommandExecutor(service));
        this.startSession(capabilities);
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    private GeckoDriverService setupService(int port) {
        try {
            GeckoDriverService.Builder builder = new GeckoDriverService.Builder();
            builder.usingPort(port);
            return (GeckoDriverService)builder.build();
        }
        catch (IllegalStateException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }
}

