/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import sun.swing.plaf.synth.SynthIcon;

public class SynthToolBarUI
extends BasicToolBarUI
implements PropertyChangeListener,
SynthUI {
    private Icon handleIcon = null;
    private Rectangle contentRect = new Rectangle();
    private SynthStyle style;
    private SynthStyle contentStyle;
    private SynthStyle dragWindowStyle;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthToolBarUI();
    }

    @Override
    protected void installDefaults() {
        this.toolBar.setLayout(this.createLayout());
        this.updateStyle(this.toolBar);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.toolBar.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.toolBar.removePropertyChangeListener(this);
    }

    private void updateStyle(JToolBar jToolBar) {
        SynthContext synthContext = this.getContext(jToolBar, Region.TOOL_BAR_CONTENT, null, 1);
        this.contentStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        synthContext = this.getContext(jToolBar, Region.TOOL_BAR_DRAG_WINDOW, null, 1);
        this.dragWindowStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        synthContext = this.getContext(jToolBar, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (synthStyle != this.style) {
            this.handleIcon = this.style.getIcon(synthContext, "ToolBar.handleIcon");
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.toolBar, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        this.handleIcon = null;
        synthContext = this.getContext(this.toolBar, Region.TOOL_BAR_CONTENT, this.contentStyle, 1);
        this.contentStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.contentStyle = null;
        synthContext = this.getContext(this.toolBar, Region.TOOL_BAR_DRAG_WINDOW, this.dragWindowStyle, 1);
        this.dragWindowStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.dragWindowStyle = null;
        this.toolBar.setLayout(null);
    }

    @Override
    protected void installComponents() {
    }

    @Override
    protected void uninstallComponents() {
    }

    protected LayoutManager createLayout() {
        return new SynthToolBarLayoutManager();
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, SynthLookAndFeel.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private SynthContext getContext(JComponent jComponent, Region region, SynthStyle synthStyle) {
        return SynthContext.getContext(SynthContext.class, jComponent, region, synthStyle, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, SynthStyle synthStyle, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, region, synthStyle, n);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintToolBarBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), this.toolBar.getOrientation());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintToolBarBorder(synthContext, graphics, n, n2, n3, n4, this.toolBar.getOrientation());
    }

    @Override
    protected void setBorderToNonRollover(Component component) {
    }

    @Override
    protected void setBorderToRollover(Component component) {
    }

    @Override
    protected void setBorderToNormal(Component component) {
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        if (this.handleIcon != null && this.toolBar.isFloatable()) {
            int n = this.toolBar.getComponentOrientation().isLeftToRight() ? 0 : this.toolBar.getWidth() - SynthIcon.getIconWidth(this.handleIcon, synthContext);
            SynthIcon.paintIcon(this.handleIcon, synthContext, graphics, n, 0, SynthIcon.getIconWidth(this.handleIcon, synthContext), SynthIcon.getIconHeight(this.handleIcon, synthContext));
        }
        SynthContext synthContext2 = this.getContext(this.toolBar, Region.TOOL_BAR_CONTENT, this.contentStyle);
        this.paintContent(synthContext2, graphics, this.contentRect);
        synthContext2.dispose();
    }

    protected void paintContent(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        synthContext.getPainter().paintToolBarContentBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.toolBar.getOrientation());
        synthContext.getPainter().paintToolBarContentBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.toolBar.getOrientation());
    }

    @Override
    protected void paintDragWindow(Graphics graphics) {
        int n = this.dragWindow.getWidth();
        int n2 = this.dragWindow.getHeight();
        SynthContext synthContext = this.getContext(this.toolBar, Region.TOOL_BAR_DRAG_WINDOW, this.dragWindowStyle);
        SynthLookAndFeel.updateSubregion(synthContext, graphics, new Rectangle(0, 0, n, n2));
        synthContext.getPainter().paintToolBarDragWindowBackground(synthContext, graphics, 0, 0, n, n2, this.dragWindow.getOrientation());
        synthContext.getPainter().paintToolBarDragWindowBorder(synthContext, graphics, 0, 0, n, n2, this.dragWindow.getOrientation());
        synthContext.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JToolBar)propertyChangeEvent.getSource());
        }
    }

    class SynthToolBarLayoutManager
    implements LayoutManager {
        SynthToolBarLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            JToolBar jToolBar = (JToolBar)container;
            Insets insets = jToolBar.getInsets();
            Dimension dimension = new Dimension();
            SynthContext synthContext = SynthToolBarUI.this.getContext(jToolBar);
            if (jToolBar.getOrientation() == 0) {
                dimension.width = jToolBar.isFloatable() ? SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, synthContext) : 0;
                for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
                    Component component = jToolBar.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension dimension2 = component.getMinimumSize();
                    dimension.width += dimension2.width;
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
            } else {
                dimension.height = jToolBar.isFloatable() ? SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, synthContext) : 0;
                for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
                    Component component = jToolBar.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension dimension3 = component.getMinimumSize();
                    dimension.width = Math.max(dimension.width, dimension3.width);
                    dimension.height += dimension3.height;
                }
            }
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            synthContext.dispose();
            return dimension;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            JToolBar jToolBar = (JToolBar)container;
            Insets insets = jToolBar.getInsets();
            Dimension dimension = new Dimension();
            SynthContext synthContext = SynthToolBarUI.this.getContext(jToolBar);
            if (jToolBar.getOrientation() == 0) {
                dimension.width = jToolBar.isFloatable() ? SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, synthContext) : 0;
                for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
                    Component component = jToolBar.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension dimension2 = component.getPreferredSize();
                    dimension.width += dimension2.width;
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
            } else {
                dimension.height = jToolBar.isFloatable() ? SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, synthContext) : 0;
                for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
                    Component component = jToolBar.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension dimension3 = component.getPreferredSize();
                    dimension.width = Math.max(dimension.width, dimension3.width);
                    dimension.height += dimension3.height;
                }
            }
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            synthContext.dispose();
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            JToolBar jToolBar = (JToolBar)container;
            Insets insets = jToolBar.getInsets();
            boolean bl = jToolBar.getComponentOrientation().isLeftToRight();
            SynthContext synthContext = SynthToolBarUI.this.getContext(jToolBar);
            int n2 = 0;
            for (n = 0; n < jToolBar.getComponentCount(); ++n) {
                if (!this.isGlue(jToolBar.getComponent(n))) continue;
                ++n2;
            }
            if (jToolBar.getOrientation() == 0) {
                int n3;
                n = jToolBar.isFloatable() ? SynthIcon.getIconWidth(SynthToolBarUI.this.handleIcon, synthContext) : 0;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.x = bl ? n : 0;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.y = 0;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.width = jToolBar.getWidth() - n;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.height = jToolBar.getHeight();
                int n4 = bl ? n + insets.left : jToolBar.getWidth() - n - insets.right;
                int n5 = insets.top;
                int n6 = jToolBar.getHeight() - insets.top - insets.bottom;
                int n7 = 0;
                if (n2 > 0) {
                    n3 = this.minimumLayoutSize((Container)container).width;
                    n7 = (jToolBar.getWidth() - n3) / n2;
                    if (n7 < 0) {
                        n7 = 0;
                    }
                }
                for (n3 = 0; n3 < jToolBar.getComponentCount(); ++n3) {
                    int n8;
                    int n9;
                    Component component = jToolBar.getComponent(n3);
                    if (!component.isVisible()) continue;
                    Dimension dimension = component.getPreferredSize();
                    if (dimension.height >= n6 || component instanceof JSeparator) {
                        n9 = n5;
                        n8 = n6;
                    } else {
                        n9 = n5 + n6 / 2 - dimension.height / 2;
                        n8 = dimension.height;
                    }
                    if (this.isGlue(component)) {
                        dimension.width += n7;
                    }
                    component.setBounds(bl ? n4 : n4 - dimension.width, n9, dimension.width, n8);
                    n4 = bl ? n4 + dimension.width : n4 - dimension.width;
                }
            } else {
                int n10;
                n = jToolBar.isFloatable() ? SynthIcon.getIconHeight(SynthToolBarUI.this.handleIcon, synthContext) : 0;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.x = 0;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.y = n;
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.width = jToolBar.getWidth();
                ((SynthToolBarUI)SynthToolBarUI.this).contentRect.height = jToolBar.getHeight() - n;
                int n11 = insets.left;
                int n12 = jToolBar.getWidth() - insets.left - insets.right;
                int n13 = n + insets.top;
                int n14 = 0;
                if (n2 > 0) {
                    n10 = this.minimumLayoutSize((Container)container).height;
                    n14 = (jToolBar.getHeight() - n10) / n2;
                    if (n14 < 0) {
                        n14 = 0;
                    }
                }
                for (n10 = 0; n10 < jToolBar.getComponentCount(); ++n10) {
                    int n15;
                    int n16;
                    Component component = jToolBar.getComponent(n10);
                    if (!component.isVisible()) continue;
                    Dimension dimension = component.getPreferredSize();
                    if (dimension.width >= n12 || component instanceof JSeparator) {
                        n16 = n11;
                        n15 = n12;
                    } else {
                        n16 = n11 + n12 / 2 - dimension.width / 2;
                        n15 = dimension.width;
                    }
                    if (this.isGlue(component)) {
                        dimension.height += n14;
                    }
                    component.setBounds(n16, n13, n15, dimension.height);
                    n13 += dimension.height;
                }
            }
            synthContext.dispose();
        }

        private boolean isGlue(Component component) {
            if (component.isVisible() && component instanceof Box.Filler) {
                Box.Filler filler = (Box.Filler)component;
                Dimension dimension = filler.getMinimumSize();
                Dimension dimension2 = filler.getPreferredSize();
                return dimension.width == 0 && dimension.height == 0 && dimension2.width == 0 && dimension2.height == 0;
            }
            return false;
        }
    }
}

