/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.fallback;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.keyring.impl.Utils;
import org.netbeans.modules.keyring.spi.EncryptionProvider;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class FallbackProvider
implements KeyringProvider,
Callable<Void> {
    private static final Logger LOG = Logger.getLogger(FallbackProvider.class.getName());
    private static final String DESCRIPTION = ".description";
    private static final String SAMPLE_KEY = "__sample__";
    private EncryptionProvider encryption;

    public boolean enabled() {
        for (EncryptionProvider p : Lookup.getDefault().lookupAll(EncryptionProvider.class)) {
            if (!p.enabled()) continue;
            this.encryption = p;
            Preferences prefs = this.prefs();
            Utils.goMinusR(prefs);
            p.encryptionChangingCallback(this);
            if (!this.testSampleKey(prefs)) continue;
            LOG.log(Level.FINE, "Using provider: {0}", p);
            return true;
        }
        LOG.fine("No provider");
        return false;
    }

    private boolean testSampleKey(Preferences prefs) {
        byte[] ciphertext = prefs.getByteArray(SAMPLE_KEY, null);
        if (ciphertext == null) {
            this.encryption.freshKeyring(true);
            if (this._save(SAMPLE_KEY, (SAMPLE_KEY + UUID.randomUUID()).toCharArray(), NbBundle.getMessage(FallbackProvider.class, (String)"FallbackProvider.sample_key.description"))) {
                LOG.fine("saved sample key");
                return true;
            }
            LOG.fine("could not save sample key");
            return false;
        }
        this.encryption.freshKeyring(false);
        while (true) {
            try {
                if (new String(this.encryption.decrypt(ciphertext)).startsWith(SAMPLE_KEY)) {
                    LOG.fine("succeeded in decrypting sample key");
                    return true;
                }
                LOG.fine("wrong result decrypting sample key");
            }
            catch (Exception x) {
                LOG.log(Level.FINE, "failed to decrypt sample key", x);
            }
            if (!this.encryption.decryptionFailed()) {
                LOG.fine("sample key decryption failed");
                return this.promptToDelete(prefs);
            }
            LOG.fine("will retry decryption of sample key");
        }
    }

    private boolean promptToDelete(Preferences prefs) {
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(FallbackProvider.class, (String)"FallbackProvider.msg_clear_keys"), NbBundle.getMessage(FallbackProvider.class, (String)"FallbackProvider.title_clear_keys"), 2));
        if (result == NotifyDescriptor.OK_OPTION) {
            try {
                LOG.log(Level.FINE, "agreed to delete stored passwords: {0}", Arrays.asList(prefs.keys()));
                prefs.clear();
                return this.testSampleKey(prefs);
            }
            catch (BackingStoreException x) {
                LOG.log(Level.INFO, null, x);
            }
        } else {
            LOG.fine("refused to delete stored passwords");
        }
        return false;
    }

    private Preferences prefs() {
        return NbPreferences.forModule(Keyring.class).node(this.encryption.id());
    }

    public char[] read(String key) {
        byte[] ciphertext = this.prefs().getByteArray(key, null);
        if (ciphertext == null) {
            return null;
        }
        try {
            return this.encryption.decrypt(ciphertext);
        }
        catch (Exception x) {
            LOG.log(Level.FINE, "failed to decrypt password for " + key, x);
            return null;
        }
    }

    public void save(String key, char[] password, String description) {
        this._save(key, password, description);
    }

    private boolean _save(String key, char[] password, String description) {
        Preferences prefs = this.prefs();
        try {
            prefs.putByteArray(key, this.encryption.encrypt(password));
        }
        catch (Exception x) {
            LOG.log(Level.FINE, "failed to encrypt password for " + key, x);
            return false;
        }
        if (description != null) {
            prefs.put(key + DESCRIPTION, description);
        }
        return true;
    }

    public void delete(String key) {
        Preferences prefs = this.prefs();
        prefs.remove(key);
        prefs.remove(key + DESCRIPTION);
    }

    @Override
    public Void call() throws Exception {
        LOG.fine("encryption changing");
        HashMap<String, char[]> saved = new HashMap<String, char[]>();
        Preferences prefs = this.prefs();
        for (String k : prefs.keys()) {
            byte[] ciphertext;
            if (k.endsWith(DESCRIPTION) || (ciphertext = prefs.getByteArray(k, null)) == null) continue;
            saved.put(k, this.encryption.decrypt(ciphertext));
        }
        LOG.log(Level.FINE, "reencrypting keys: {0}", saved.keySet());
        this.encryption.encryptionChanged();
        for (Map.Entry entry : saved.entrySet()) {
            prefs.putByteArray((String)entry.getKey(), this.encryption.encrypt((char[])entry.getValue()));
        }
        LOG.fine("encryption changing finished");
        return null;
    }
}

