/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.perf;

import com.sun.deploy.config.Config;
import com.sun.deploy.perf.PerfHelper;
import com.sun.deploy.perf.PerfLabel;
import com.sun.deploy.perf.PerfRollup;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class DeployPerfUtil {
    private static final boolean deployFirstframePerfEnabled;
    private static volatile boolean getenvSupported;
    private static final String DEPLOY_PERF_ENABLED = "DEPLOY_PERF_ENABLED";
    private static final String DEPLOY_PERF_LOG = "DEPLOY_PERF_LOG";
    private static final String DEFAULT_LOGNAME = "deploy_perf.log";
    private static final String DEFAULT_LOGFILE = "deploy_perf.log";
    private static final String INVALID_DEPLOY_PERF_LOG = "The DEPLOY_PERF_LOG variable must point to a file path, not a directory!";
    private static final String MISSING_PARENTS = "Failed to create the parent directories for the file specified by DEPLOY_PERF_LOG!";
    private static final File perfLog;
    private static PerfHelper helper;

    private static String getenv(String string) {
        if (getenvSupported) {
            try {
                return System.getenv(string);
            }
            catch (Error error) {
                getenvSupported = false;
            }
        }
        return null;
    }

    public static boolean isDeployFirstframePerfEnabled() {
        return deployFirstframePerfEnabled;
    }

    public static boolean isEnabled() {
        return perfLog != null;
    }

    public static void put(String string) {
        if (DeployPerfUtil.isEnabled() && helper != null) {
            helper.put(string);
        }
    }

    public static long put(long l, String string) {
        if (DeployPerfUtil.isEnabled() && helper != null) {
            return helper.put(l, string);
        }
        return 0L;
    }

    public static void setInitTime(long l) {
        if (DeployPerfUtil.isEnabled() && helper != null) {
            helper.setInitTime(l);
        }
    }

    public static void clear() {
        if (DeployPerfUtil.isEnabled() && helper != null) {
            helper.clear();
        }
    }

    public static void write() throws IOException {
        DeployPerfUtil.write(null);
    }

    public static synchronized void write(PerfRollup perfRollup) throws IOException {
        if (DeployPerfUtil.isEnabled() && helper != null) {
            if (perfLog.isDirectory()) {
                throw new IllegalStateException(INVALID_DEPLOY_PERF_LOG);
            }
            if (!perfLog.getParentFile().exists() && !perfLog.getParentFile().mkdirs()) {
                throw new IllegalStateException(MISSING_PARENTS);
            }
            PrintStream printStream = null;
            try {
                block15: {
                    printStream = new PrintStream(new FileOutputStream(perfLog, true));
                    printStream.println("");
                    printStream.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                    printStream.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                    printStream.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                    printStream.println("");
                    PerfLabel[] perfLabelArray = helper.toArray();
                    if (perfLabelArray != null && perfLabelArray.length > 0) {
                        long l = Long.MAX_VALUE;
                        long l2 = 0L;
                        long l3 = 0L;
                        long l4 = 0L;
                        boolean bl = helper.getInitTime1() >= 0L;
                        for (int i = 0; i < perfLabelArray.length; ++i) {
                            boolean bl2 = false;
                            StringBuffer stringBuffer = new StringBuffer(256);
                            stringBuffer.append(DeployPerfUtil.pad(perfLabelArray[i].getLabel(), 65, true));
                            l2 = perfLabelArray[i].getTime();
                            if (l > l2) {
                                bl2 = true;
                                l = l2;
                                l4 = 0L;
                            }
                            l3 = l2 - l;
                            l = l2;
                            stringBuffer.append(" , ").append(DeployPerfUtil.pad("t0", l2, 11, false));
                            stringBuffer.append(" , ").append(DeployPerfUtil.pad("delta", l3, 10, false));
                            stringBuffer.append(" , ").append(DeployPerfUtil.pad("elapsed", l4 += l3, 11, false));
                            if (bl) {
                                stringBuffer.append(" , ").append(DeployPerfUtil.pad("t1", perfLabelArray[i].getTime1(), 11, false));
                            }
                            if (bl2) {
                                stringBuffer.append(" ** reset **");
                            }
                            printStream.println(stringBuffer.toString());
                        }
                    } else {
                        printStream.println("The perf label event array is empty.");
                    }
                    printStream.flush();
                    if (perfRollup == null) break block15;
                    perfRollup.doRollup(perfLabelArray, printStream);
                    printStream.flush();
                }
                Object var16_12 = null;
                if (printStream != null) {
                    printStream.close();
                }
            }
            catch (Throwable throwable) {
                Object var16_13 = null;
                if (printStream != null) {
                    printStream.close();
                }
                throw throwable;
            }
        }
    }

    public static synchronized void initialize(PerfHelper perfHelper) {
        if (helper == null) {
            helper = perfHelper;
        }
    }

    public static synchronized PerfHelper getPerfHelper() {
        return helper;
    }

    private static File getPerfLog() {
        File file = null;
        try {
            String string = System.getenv(DEPLOY_PERF_ENABLED);
            if (string != null && !string.equalsIgnoreCase("false")) {
                String string2 = System.getenv(DEPLOY_PERF_LOG);
                file = string2 != null ? new File(string2) : new File(Config.getLogDirectory(), "deploy_perf.log");
            }
        }
        catch (Error error) {
            // empty catch block
        }
        return file;
    }

    private static String pad(String string, long l, int n, boolean bl) {
        String string2 = Long.toString(l);
        return DeployPerfUtil.pad(string, string2, n, bl);
    }

    private static String pad(String string, int n, boolean bl) {
        return DeployPerfUtil.pad(null, string, n, bl);
    }

    private static String pad(String string, String string2, int n, boolean bl) {
        int n2;
        int n3 = n - string2.length();
        if (null != string) {
            n3 -= string.length() + 1;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        if (null != string) {
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        if (!bl) {
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(string2);
        if (bl) {
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    static {
        getenvSupported = true;
        deployFirstframePerfEnabled = DeployPerfUtil.getenv("DEPLOY_FIRSTFRAME_PERF_ENABLED") != null;
        perfLog = DeployPerfUtil.getPerfLog();
        helper = null;
    }
}

