/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.grid.common.CommandLineOptionHelper;
import org.openqa.grid.common.GridDocHelper;
import org.openqa.grid.common.GridRole;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.GridHubConfiguration;
import org.openqa.grid.internal.utils.SelfRegisteringRemote;
import org.openqa.grid.shared.CliUtils;
import org.openqa.grid.web.Hub;
import org.openqa.selenium.remote.server.log.LoggingOptions;
import org.openqa.selenium.remote.server.log.TerseFormatter;
import org.openqa.selenium.server.SeleniumServer;

public class GridLauncher {
    private static final Logger log = Logger.getLogger(GridLauncher.class.getName());
    private static ImmutableMap<GridRole, GridItemLauncher> launchers = new ImmutableMap.Builder().put((Object)GridRole.NOT_GRID, (Object)new GridItemLauncher(){

        @Override
        public void launch(String[] args, Logger log) throws Exception {
            log.info("Launching a standalone Selenium Server");
            SeleniumServer.main(args);
            log.info("Selenium Server is up and running");
        }

        @Override
        public void printUsage() {
            String separator = "\n-------------------------------\n";
            SeleniumServer.usage(String.valueOf(separator) + "Running as a standalone server:" + separator);
        }
    }).put((Object)GridRole.HUB, (Object)new GridItemLauncher(){

        @Override
        public void launch(String[] args, Logger log) throws Exception {
            log.info("Launching Selenium Grid hub");
            GridHubConfiguration c = GridHubConfiguration.build(args);
            Hub h = new Hub(c);
            h.start();
            log.info("Nodes should register to " + h.getRegistrationURL());
            log.info("Selenium Grid hub is up and running");
        }

        @Override
        public void printUsage() {
            String separator = "\n-------------------------------\n";
            GridDocHelper.printHubHelp(String.valueOf(separator) + "Running as a grid hub:" + separator, false);
        }
    }).put((Object)GridRole.NODE, (Object)new GridItemLauncher(){

        @Override
        public void launch(String[] args, Logger log) throws Exception {
            log.info("Launching a Selenium Grid node");
            RegistrationRequest c = RegistrationRequest.build(args);
            SelfRegisteringRemote remote = new SelfRegisteringRemote(c);
            remote.setRemoteServer(new SeleniumServer(c.getConfiguration()));
            remote.startRemoteServer();
            log.info("Selenium Grid node is up and ready to register to the hub");
            remote.startRegistrationProcess();
        }

        @Override
        public void printUsage() {
            String separator = "\n-------------------------------\n";
            GridDocHelper.printNodeHelp(String.valueOf(separator) + "Running as a grid node:" + separator, false);
        }
    }).build();

    public static void main(String[] args) throws Exception {
        CommandLineOptionHelper helper = new CommandLineOptionHelper(args);
        GridRole role = GridRole.find(args);
        if (role == null) {
            GridLauncher.printInfoAboutRoles(helper);
            return;
        }
        if (helper.isParamPresent("-help") || helper.isParamPresent("-h")) {
            if (launchers.containsKey((Object)role)) {
                ((GridItemLauncher)launchers.get((Object)role)).printUsage();
            } else {
                GridLauncher.printInfoAboutRoles(helper);
            }
            return;
        }
        GridLauncher.configureLogging(helper);
        if (launchers.containsKey((Object)role)) {
            try {
                ((GridItemLauncher)launchers.get((Object)role)).launch(args, log);
            }
            catch (Exception e) {
                ((GridItemLauncher)launchers.get((Object)role)).printUsage();
                e.printStackTrace();
            }
        } else {
            throw new GridConfigurationException("Unknown role: " + (Object)((Object)role));
        }
    }

    private static void printInfoAboutRoles(CommandLineOptionHelper helper) {
        if (helper.hasParamValue("-role")) {
            CliUtils.printWrappedLine("", "Error: the role '" + helper.getParamValue("-role") + "' does not match a recognized server role\n");
        } else {
            CliUtils.printWrappedLine("", "Error: -role option needs to be followed by the value that defines role of this component in the grid\n");
        }
        System.out.println("Selenium server can run in one of the following roles:\n  hub         as a hub of a Selenium grid\n  node        as a node of a Selenium grid\n  standalone  as a standalone server not being a part of a grid\n\nIf -role option is omitted the server runs standalone\n");
        CliUtils.printWrappedLine("", "To get help on the options available for a specific role run the server with -help option and the corresponding -role option value");
    }

    private static void configureLogging(CommandLineOptionHelper helper) {
        String logFilename;
        Level logLevel;
        Level level = logLevel = helper.isParamPresent("-debug") ? Level.FINE : LoggingOptions.getDefaultLogLevel();
        if (logLevel == null) {
            logLevel = Level.INFO;
        }
        Logger.getLogger("").setLevel(logLevel);
        Logger.getLogger("org.openqa.jetty").setLevel(Level.WARNING);
        String string = logFilename = helper.isParamPresent("-log") ? helper.getParamValue("-log") : LoggingOptions.getDefaultLogOutFile();
        if (logFilename != null) {
            Handler[] handlerArray = Logger.getLogger("").getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = handlerArray[n2];
                if (handler instanceof ConsoleHandler) {
                    Logger.getLogger("").removeHandler(handler);
                }
                ++n2;
            }
            try {
                FileHandler logFile = new FileHandler(new File(logFilename).getAbsolutePath(), true);
                logFile.setFormatter(new TerseFormatter(true));
                logFile.setLevel(logLevel);
                Logger.getLogger("").addHandler(logFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            boolean logLongForm = helper.isParamPresent("-logLongForm");
            Handler[] handlerArray = Logger.getLogger("").getHandlers();
            int n = handlerArray.length;
            int n3 = 0;
            while (n3 < n) {
                Handler handler = handlerArray[n3];
                if (handler instanceof ConsoleHandler) {
                    handler.setLevel(logLevel);
                    handler.setFormatter(new TerseFormatter(logLongForm));
                }
                ++n3;
            }
        }
    }

    public static interface GridItemLauncher {
        public void launch(String[] var1, Logger var2) throws Exception;

        public void printUsage();
    }
}

