/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.modules.options.keymap.ActionHolder;
import org.netbeans.modules.options.keymap.KeymapPanel;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutCellPanel;
import org.netbeans.modules.options.keymap.ShortcutTextField;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ButtonCellEditor
extends DefaultCellEditor {
    private Object action;
    private KeymapViewModel model;
    private String orig;
    private FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            System.err.println("Bu");
        }

        @Override
        public void focusLost(FocusEvent e) {
            Component oppositeComponent = e.getOppositeComponent();
            if (oppositeComponent == null || !SwingUtilities.isDescendingFrom(oppositeComponent, cell)) {
                ButtonCellEditor.this.cancelCellEditing();
            }
        }
    };
    private KeyAdapter escapeAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                JTable table = (JTable)cell.getParent();
                table.getCellEditor().cancelCellEditing();
                ((KeymapPanel)table.getParent().getParent().getParent()).getModel().update();
            }
        }
    };
    private static final ShortcutCellPanel cell = new ShortcutCellPanel();

    public ButtonCellEditor(KeymapViewModel model) {
        super(new ShortcutTextField());
        this.model = model;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    private void removeConflictingShortcut(ShortcutAction action, String shortcutPrefix) {
        if (shortcutPrefix.contains(" ")) {
            shortcutPrefix = shortcutPrefix.substring(0, shortcutPrefix.indexOf(32));
        }
        String[] shortcuts = this.model.getShortcuts(action);
        for (int i = 0; i < shortcuts.length; ++i) {
            if (!shortcuts[i].startsWith(shortcutPrefix)) continue;
            this.model.removeShortcut(action, shortcuts[i]);
        }
    }

    private void refocusTableCell(JTable parent) {
    }

    @Override
    public boolean stopCellEditing() {
        String s = cell.toString();
        Window ancestorWindow = SwingUtilities.getWindowAncestor(cell);
        JTable parent = (JTable)cell.getParent();
        ShortcutAction sca = (ShortcutAction)this.action;
        Set<ShortcutAction> conflictingAction = this.model.findActionForShortcutPrefix(s);
        conflictingAction.remove(sca);
        Collection<ShortcutAction> sameScopeActions = this.model.filterSameScope(conflictingAction, sca);
        if (!conflictingAction.isEmpty()) {
            Object overrride = this.overrride(conflictingAction, sameScopeActions);
            ancestorWindow.toFront();
            parent.requestFocus();
            if (overrride.equals(DialogDescriptor.YES_OPTION)) {
                for (ShortcutAction sa : conflictingAction) {
                    this.removeConflictingShortcut(sa, s);
                }
            } else if (overrride == DialogDescriptor.CANCEL_OPTION) {
                cell.getTextField().setText(this.orig);
                this.fireEditingCanceled();
                this.setBorderEmpty();
                return true;
            }
        }
        cell.getTextField().removeActionListener(this.delegate);
        cell.getTextField().removeKeyListener(this.escapeAdapter);
        cell.getTextField().removeFocusListener(this.focusListener);
        cell.getButton().removeFocusListener(this.focusListener);
        this.model.removeShortcut((ShortcutAction)this.action, this.orig);
        if (s.length() != 0) {
            this.model.addShortcut((ShortcutAction)this.action, s);
        }
        this.fireEditingStopped();
        this.setBorderEmpty();
        this.model.update();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        cell.getTextField().setText(this.orig);
        this.fireEditingCanceled();
        this.setBorderEmpty();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        cell.setText((String)value);
        this.orig = cell.getTextField().getText();
        this.action = ((ActionHolder)table.getValueAt(row, 0)).getAction();
        final JTextField textField = cell.getTextField();
        textField.addActionListener(this.delegate);
        textField.setBorder(new LineBorder(Color.BLACK));
        textField.addFocusListener(this.focusListener);
        cell.getButton().addFocusListener(this.focusListener);
        if (!Arrays.asList(textField.getKeyListeners()).contains(this.escapeAdapter)) {
            textField.addKeyListener(this.escapeAdapter);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                textField.requestFocus();
            }
        });
        return cell;
    }

    @Override
    public Object getCellEditorValue() {
        return cell.getTextField().getText();
    }

    @Override
    public Component getComponent() {
        return cell.getTextField();
    }

    private Object overrride(Set<ShortcutAction> conflictingActions, Collection<ShortcutAction> sameScope) {
        StringBuffer conflictingActionList = new StringBuffer();
        for (ShortcutAction sa : conflictingActions) {
            conflictingActionList.append("<li>'").append(sa.getDisplayName()).append("'</li>");
        }
        JPanel innerPane = new JPanel();
        innerPane.add(new JLabel(NbBundle.getMessage(ButtonCellEditor.class, (String)(sameScope.isEmpty() ? "Override_Shortcut2" : "Override_Shortcut"), (Object)conflictingActionList)));
        DialogDescriptor descriptor = new DialogDescriptor((Object)innerPane, NbBundle.getMessage(ButtonCellEditor.class, (String)"Conflicting_Shortcut_Dialog"), true, sameScope.isEmpty() ? 1 : 0, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        Object o = descriptor.getValue();
        if (!sameScope.isEmpty() && o == DialogDescriptor.NO_OPTION) {
            return DialogDescriptor.CANCEL_OPTION;
        }
        return o;
    }

    private void setBorderEmpty() {
        ((JComponent)this.getComponent()).setBorder(new EmptyBorder(0, 0, 0, 0));
    }
}

