/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.osgi;

import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.osgi.DependencyQueue;
import org.netbeans.core.osgi.OSGiMainLookup;
import org.netbeans.core.osgi.OSGiRepository;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.RunLevel;
import org.netbeans.core.startup.Splash;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.SharedClassObject;
import org.openide.util.lookup.Lookups;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.launch.Framework;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private DependencyQueue<String, Bundle> queue;
    private BundleContext context;
    private Framework framework;
    static final Map<Bundle, ModuleInstall> installers = new HashMap<Bundle, ModuleInstall>();

    public void start(final BundleContext context) throws Exception {
        if (System.getProperty("netbeans.home") != null) {
            throw new IllegalStateException("Should not be run from inside regular NetBeans module system");
        }
        String storage = context.getProperty("org.osgi.framework.storage");
        if (storage != null) {
            System.setProperty("netbeans.user", storage);
        }
        System.setProperty("TopSecurityManager.disable", "true");
        NbBundle.setBranding((String)System.getProperty("branding.token"));
        OSGiMainLookup.initialize(context);
        this.queue = new DependencyQueue();
        this.context = context;
        this.framework = (Framework)context.getBundle(0L);
        if (this.framework.getState() == 8) {
            LOG.fine("framework still starting");
            final AtomicReference<1> frameworkListener = new AtomicReference<1>();
            frameworkListener.set(new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 1) {
                        context.removeFrameworkListener((FrameworkListener)frameworkListener.get());
                        context.addBundleListener((BundleListener)Activator.this);
                        Activator.this.processLoadedBundles();
                    }
                }
            });
            context.addFrameworkListener((FrameworkListener)frameworkListener.get());
        } else {
            LOG.fine("framework already started");
            context.addBundleListener((BundleListener)this);
            this.processLoadedBundles();
        }
    }

    private void processLoadedBundles() {
        ArrayList<Bundle> toLoad = new ArrayList<Bundle>();
        for (Bundle b : this.context.getBundles()) {
            if (b.getState() != 32) continue;
            Dictionary headers = b.getHeaders();
            toLoad.addAll(this.queue.offer(b, Activator.provides(headers), Activator.requires(headers), Activator.needs(headers)));
        }
        this.load(toLoad);
    }

    public void stop(BundleContext context) throws Exception {
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 2: {
                Dictionary headers = bundle.getHeaders();
                this.load(this.queue.offer(bundle, Activator.provides(headers), Activator.requires(headers), Activator.needs(headers)));
                break;
            }
            case 4: {
                if (this.framework.getState() == 16) break;
                this.unload(this.queue.retract(bundle));
            }
        }
    }

    static Set<String> provides(Dictionary<?, ?> headers) {
        TreeSet<String> deps = new TreeSet<String>(Activator.splitTokens((String)headers.get("OpenIDE-Module-Provides")));
        String name = (String)headers.get("Bundle-SymbolicName");
        if (name != null) {
            name = name.replaceFirst(";.+", "");
            deps.add("cnb." + name);
            if (name.equals("org.openide.modules")) {
                CoreBridge.defineOsTokens(deps);
            }
        }
        return deps;
    }

    static Set<String> requires(Dictionary<?, ?> headers) {
        TreeSet<String> deps = new TreeSet<String>();
        String v = (String)headers.get("Require-Bundle");
        if (v != null) {
            for (String item : v.split(", ")) {
                deps.add("cnb." + item.replaceFirst(";.+", ""));
            }
        }
        deps.addAll(Activator.splitTokens((String)headers.get("OpenIDE-Module-Requires")));
        return deps;
    }

    static Set<String> needs(Dictionary<?, ?> headers) {
        return Activator.splitTokens((String)headers.get("OpenIDE-Module-Needs"));
    }

    private static Set<String> splitTokens(String tokens) {
        if (tokens == null) {
            return Collections.emptySet();
        }
        TreeSet<String> split = new TreeSet<String>(Arrays.asList(tokens.split("[, ]+")));
        split.remove("");
        return split;
    }

    private void load(List<Bundle> bundles) {
        if (bundles.isEmpty() || bundles.size() == 1 && bundles.iterator().next().getBundleId() == 0L) {
            return;
        }
        LOG.log(Level.FINE, "loading: {0}", bundles);
        OSGiMainLookup.bundlesAdded(bundles);
        boolean showWindowSystem = false;
        boolean loadServicesFolder = false;
        for (Bundle bundle : bundles) {
            this.registerUrlProtocolHandlers(bundle);
            if (bundle.getSymbolicName().equals("org.netbeans.core")) {
                loadServicesFolder = true;
                continue;
            }
            if (bundle.getSymbolicName().equals("org.netbeans.bootstrap")) {
                System.setProperty("netbeans.buildnumber", bundle.getVersion().getQualifier());
                continue;
            }
            if (!bundle.getSymbolicName().equals("org.netbeans.core.windows")) continue;
            showWindowSystem = true;
        }
        OSGiRepository.DEFAULT.addLayersFor(bundles);
        if (loadServicesFolder) {
            OSGiMainLookup.loadServicesFolder();
        }
        if (showWindowSystem) {
            Splash.getInstance().setRunning(true);
            Main.initUICustomizations();
        }
        for (Bundle bundle : bundles) {
            ModuleInstall mi = Activator.installerFor(bundle);
            if (mi == null) continue;
            installers.put(bundle, mi);
            LOG.log(Level.FINE, "restored: {0}", bundle.getSymbolicName());
            mi.restored();
        }
        for (Runnable r : Lookups.forPath((String)"Modules/Start").lookupAll(Runnable.class)) {
            if (!bundles.contains(FrameworkUtil.getBundle(r.getClass()))) continue;
            LOG.log(Level.FINE, "starting {0}", r.getClass().getName());
            r.run();
        }
        if (showWindowSystem) {
            ArrayList<String> bisp = new ArrayList<String>(Arrays.asList(Introspector.getBeanInfoSearchPath()));
            bisp.add("org.netbeans.beaninfo");
            Introspector.setBeanInfoSearchPath(bisp.toArray(new String[bisp.size()]));
            CoreBridge.getDefault().registerPropertyEditors();
            for (RunLevel rl : Lookup.getDefault().lookupAll(RunLevel.class)) {
                rl.run();
            }
            Splash.getInstance().setRunning(false);
        }
    }

    private void unload(List<Bundle> bundles) {
        if (bundles.isEmpty()) {
            return;
        }
        LOG.log(Level.FINE, "unloading: {0}", bundles);
        for (Object r : Lookups.forPath((String)"Modules/Stop").lookupAll(Callable.class)) {
            if (!bundles.contains(FrameworkUtil.getBundle(r.getClass()))) continue;
            try {
                if (((Boolean)r.call()).booleanValue()) continue;
                LOG.log(Level.WARNING, "ignoring false return value from {0}", r.getClass().getName());
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, null, x);
            }
        }
        for (Object r : Lookups.forPath((String)"Modules/Stop").lookupAll(Runnable.class)) {
            if (!bundles.contains(FrameworkUtil.getBundle(r.getClass()))) continue;
            r.run();
        }
        for (Bundle bundle : bundles) {
            ModuleInstall mi = installers.remove(bundle);
            if (mi == null) continue;
            LOG.log(Level.FINE, "uninstalled: {0}", bundle.getSymbolicName());
            mi.uninstalled();
        }
        OSGiRepository.DEFAULT.removeLayersFor(bundles);
        OSGiMainLookup.bundlesRemoved(bundles);
    }

    private static ModuleInstall installerFor(Bundle b) {
        if (b.getSymbolicName().equals("org.netbeans.modules.autoupdate.ui")) {
            return null;
        }
        String respath = (String)b.getHeaders().get("OpenIDE-Module-Install");
        if (respath != null) {
            String fqn = respath.replaceFirst("[.]class$", "").replace('/', '.');
            try {
                return (ModuleInstall)SharedClassObject.findObject(b.loadClass(fqn).asSubclass(ModuleInstall.class), (boolean)true);
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, "Could not load " + fqn, x);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerUrlProtocolHandlers(final Bundle bundle) {
        Enumeration e = bundle.getEntryPaths("META-INF/namedservices/URLStreamHandler/");
        if (e != null) {
            for (String path : NbCollections.iterable((Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)e, String.class, (boolean)true))) {
                URL entry = bundle.getEntry(path + "java.net.URLStreamHandler");
                if (entry == null) continue;
                String protocol = path.replaceAll("^META-INF/namedservices/URLStreamHandler/|/$", "");
                try {
                    InputStream is = entry.openStream();
                    try {
                        String line;
                        BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        while ((line = r.readLine()) != null) {
                            if (line.isEmpty() || line.startsWith("#")) continue;
                            final String fqn = line;
                            Hashtable<String, String> props = new Hashtable<String, String>();
                            ((Dictionary)props).put("url.handler.protocol", protocol);
                            BundleContext context = bundle.getBundleContext();
                            if (context != null) {
                                class Svc
                                extends AbstractURLStreamHandlerService {
                                    Svc() {
                                    }

                                    public URLConnection openConnection(URL u) throws IOException {
                                        try {
                                            URLStreamHandler handler = (URLStreamHandler)bundle.loadClass(fqn).newInstance();
                                            Method openConnection = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
                                            openConnection.setAccessible(true);
                                            return (URLConnection)openConnection.invoke((Object)handler, u);
                                        }
                                        catch (Exception x) {
                                            throw (IOException)new IOException(x.toString()).initCause(x);
                                        }
                                    }
                                }
                                context.registerService(URLStreamHandlerService.class.getName(), (Object)new Svc(), props);
                                continue;
                            }
                            LOG.log(Level.WARNING, "no context for {0} in state {1}", new Object[]{bundle.getSymbolicName(), bundle.getState()});
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                catch (Exception x) {
                    LOG.log(Level.WARNING, "Could not load protocol handler for " + protocol + " from " + bundle.getSymbolicName(), x);
                }
            }
        }
    }
}

