/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.util.concurrent.BlockingQueue;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.openqa.selenium.safari.SafariDriverChannelHandler;
import org.openqa.selenium.safari.WebSocketConnection;

class SafariDriverPipelineFactory
implements ChannelPipelineFactory {
    private final int port;
    private final BlockingQueue<WebSocketConnection> connectionQueue;
    private final ChannelGroup channelGroup;

    SafariDriverPipelineFactory(int port, BlockingQueue<WebSocketConnection> connectionQueue, ChannelGroup channelGroup) {
        this.port = port;
        this.connectionQueue = connectionQueue;
        this.channelGroup = channelGroup;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("connection handler", (ChannelHandler)new ConnectionHandler());
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(65536));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("handler", (ChannelHandler)new SafariDriverChannelHandler(this.port, this.connectionQueue));
        return pipeline;
    }

    private class ConnectionHandler
    extends SimpleChannelUpstreamHandler {
        private ConnectionHandler() {
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
            SafariDriverPipelineFactory.this.channelGroup.add((Object)e.getChannel());
            ctx.sendUpstream((ChannelEvent)e);
        }
    }
}

