/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.management.ObjectName;
import oracle.jrockit.jfr.ChunksChannel;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.Logger;
import oracle.jrockit.jfr.MsgLevel;
import oracle.jrockit.jfr.RecordingOptions;
import oracle.jrockit.jfr.RepositoryChunk;
import oracle.jrockit.jfr.Settings;
import oracle.jrockit.jfr.settings.EventSettings;

public final class Recording
implements RecordingOptions {
    private final long id;
    private final Timer timer;
    private final String name;
    private final Logger logger;
    private final boolean isClone;
    private boolean toDisk = true;
    private boolean isStarting;
    private TimerTask startTask;
    private TimerTask stopTask;
    private Date startTime;
    private Date endTime;
    private long duration;
    private long maxSize;
    private long maxAge;
    private long size;
    private volatile boolean done;
    private volatile boolean stoppingDone;
    private boolean started;
    private volatile boolean released;
    private boolean destinationCompressed;
    private String dest;
    private final LinkedList<RepositoryChunk> chunks = new LinkedList();
    private final JFRImpl jfrImpl;
    private final Object chunkLock = new Object();
    final Settings.Aggregator settingsAggregator;
    ObjectName objectName;

    Recording(Logger logger, Timer timer, String string, long l, Settings.Aggregator aggregator, boolean bl, JFRImpl jFRImpl) {
        this.logger = logger;
        this.timer = timer;
        this.name = string;
        this.id = l;
        this.settingsAggregator = aggregator;
        this.isClone = bl;
        this.jfrImpl = jFRImpl;
    }

    private void added(RepositoryChunk repositoryChunk) {
        repositoryChunk.use();
        this.size += repositoryChunk.getSize();
        if (this.logger.isDebug()) {
            this.logger.log(MsgLevel.DEBUG, "Recording %s:%d added chunk %s, current size=%d", this.name, this.id, repositoryChunk.toString(), this.size);
        }
    }

    private void removed(RepositoryChunk repositoryChunk) {
        this.size -= repositoryChunk.getSize();
        if (this.logger.isDebug()) {
            this.logger.log(MsgLevel.DEBUG, "Recording %s:%d removed chunk %s, current size=%d", this.name, this.id, repositoryChunk.toString(), this.size);
        }
        repositoryChunk.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChunk(RepositoryChunk repositoryChunk) {
        if (!this.toDisk) {
            return;
        }
        Object object = this.chunkLock;
        synchronized (object) {
            Object object2;
            if (!this.isStarted() || this.done || this.isStarting) {
                return;
            }
            if (this.maxAge != 0L && !this.chunks.isEmpty()) {
                RepositoryChunk repositoryChunk2;
                object2 = new Date(repositoryChunk.getEndTime().getTime() - this.maxAge);
                while (!this.chunks.isEmpty() && !(repositoryChunk2 = this.chunks.peek()).getEndTime().after((Date)object2)) {
                    this.chunks.removeFirst();
                    this.removed(repositoryChunk2);
                }
            }
            this.chunks.addLast(repositoryChunk);
            this.added(repositoryChunk);
            while (this.maxSize != 0L && this.size > this.maxSize && this.chunks.size() > 1) {
                object2 = this.chunks.removeFirst();
                this.removed((RepositoryChunk)object2);
            }
        }
    }

    public long getActualDuration(TimeUnit timeUnit) {
        if (!this.isStopped()) {
            return 0L;
        }
        return timeUnit.convert(this.endTime.getTime() - this.startTime.getTime(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDataEndTime() {
        Object object = this.chunkLock;
        synchronized (object) {
            if (this.chunks.isEmpty()) {
                return null;
            }
            RepositoryChunk repositoryChunk = this.chunks.getLast();
            return repositoryChunk.getEndTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDataStartTime() {
        Object object = this.chunkLock;
        synchronized (object) {
            if (this.chunks.isEmpty()) {
                return null;
            }
            RepositoryChunk repositoryChunk = this.chunks.getFirst();
            return repositoryChunk.getStartTime();
        }
    }

    public long getDataSize() {
        return this.size;
    }

    @Override
    public long getDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.duration, TimeUnit.MILLISECONDS);
    }

    public Date getEndTime() {
        return this.endTime != null ? (Date)this.endTime.clone() : null;
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadableByteChannel getChannel() throws IOException {
        Object object = this.chunkLock;
        synchronized (object) {
            return new ChunksChannel(this.chunks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadableByteChannel getChannel(Date date, Date date2) throws IOException {
        Object object = this.chunkLock;
        synchronized (object) {
            ArrayList<RepositoryChunk> arrayList = new ArrayList<RepositoryChunk>(this.chunks.size());
            for (RepositoryChunk repositoryChunk : this.chunks) {
                Date date3 = repositoryChunk.getStartTime();
                Date date4 = repositoryChunk.getEndTime();
                if (date4.before(date)) continue;
                if (date3.compareTo(date2) > 0) break;
                arrayList.add(repositoryChunk);
            }
            return new ChunksChannel(arrayList);
        }
    }

    public InputStream getInputStream() throws IOException {
        return Channels.newInputStream(this.getChannel());
    }

    public InputStream getInputStream(Date date, Date date2) throws IOException {
        return Channels.newInputStream(this.getChannel(date, date2));
    }

    @Override
    public long getMaxAge(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxAge, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Date getStartTime() {
        return this.startTime != null ? (Date)this.startTime.clone() : null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.done;
    }

    public boolean isRunning() {
        return this.isStarted() && this.endTime == null;
    }

    boolean isStoppingDone() {
        return this.stoppingDone;
    }

    public boolean isReleased() {
        return this.released;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public boolean isBound() {
        return this.objectName != null;
    }

    public void setToDisk(boolean bl) {
        if (this.isStarted()) {
            throw new IllegalStateException("Recording is started");
        }
        this.toDisk = bl;
    }

    @Override
    public boolean isToDisk() {
        return this.toDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.chunkLock;
        synchronized (object) {
            for (RepositoryChunk repositoryChunk : this.chunks) {
                this.removed(repositoryChunk);
            }
            this.chunks.clear();
            this.released = true;
        }
    }

    public void setDuration(long l, TimeUnit timeUnit) {
        this.duration = TimeUnit.MILLISECONDS.convert(l, timeUnit);
        this.updateTimer();
    }

    public void setMaxAge(long l, TimeUnit timeUnit) {
        this.maxAge = TimeUnit.MILLISECONDS.convert(l, timeUnit);
    }

    public void setMaxSize(long l) {
        this.maxSize = l;
    }

    public boolean isClone() {
        return this.isClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.chunkLock;
        synchronized (object) {
            if (this.endTime != null) {
                throw new IllegalStateException("Recording finished");
            }
            if (this.started) {
                return;
            }
            this.started = true;
            boolean bl = this.isStarting = !this.isClone;
            if (this.startTime == null) {
                this.startTime = new Date();
            }
            this.updateTimer();
            this.logger.info("Starting recording " + this);
        }
        this.jfrImpl.started(this);
        object = this.chunkLock;
        synchronized (object) {
            this.isStarting = false;
            this.chunkLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        Object object = this.chunkLock;
        synchronized (object) {
            if (!this.started) {
                throw new IllegalStateException("Not started");
            }
            while (this.isStarting) {
                try {
                    this.chunkLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.endTime != null) {
                return;
            }
            this.endTime = new Date();
            this.updateTimer();
        }
        this.jfrImpl.stopping(this);
        this.stoppingDone = true;
        this.jfrImpl.stopped(this);
        if (this.dest != null) {
            try {
                this.copyTo(this.dest, this.destinationCompressed);
            }
            catch (IOException iOException) {
                this.dest = null;
                throw iOException;
            }
        }
        this.done = true;
        this.logger.info("Stopped recording " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyTo(String string, boolean bl) throws IOException {
        long l = 0L;
        File file = new File(string);
        try {
            int n;
            ChunksChannel chunksChannel;
            Object object = this.chunkLock;
            synchronized (object) {
                chunksChannel = new ChunksChannel(this.chunks);
                n = this.chunks.size();
            }
            this.logger.log(MsgLevel.DEBUG, "Copy %d chunks to %s", n, file.getPath());
            try {
                object = new FileOutputStream(file);
                Throwable throwable = null;
                try {
                    Closeable closeable;
                    if (!bl) {
                        closeable = ((FileOutputStream)object).getChannel();
                        l = chunksChannel.transferTo((FileChannel)closeable);
                        ((FileChannel)closeable).force(true);
                    } else {
                        closeable = new GZIPOutputStream((OutputStream)object);
                        ByteBuffer byteBuffer = ByteBuffer.allocate(5120);
                        while (true) {
                            byteBuffer.clear();
                            int n2 = chunksChannel.read(byteBuffer);
                            if (n2 == -1) break;
                            ((GZIPOutputStream)closeable).write(byteBuffer.array(), 0, byteBuffer.position());
                            l += (long)n2;
                        }
                        ((DeflaterOutputStream)closeable).flush();
                        ((GZIPOutputStream)closeable).finish();
                        ((DeflaterOutputStream)closeable).close();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((FileOutputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FileOutputStream)object).close();
                        }
                    }
                }
            }
            finally {
                chunksChannel.close();
            }
            this.logger.log(MsgLevel.INFO, "Copied %d bytes (before compression) to %s in %d chunks", l, file.getPath(), n);
        }
        catch (IOException iOException) {
            this.logger.log(MsgLevel.ERROR, iOException, "Could not copy to %s", file.getPath());
            if (!file.delete()) {
                this.logger.log(MsgLevel.ERROR, iOException, "Could not delete %s", file.getPath());
            }
            throw iOException;
        }
        return l;
    }

    @Override
    public String getDestination() {
        return this.dest;
    }

    public void setDestination(String string) throws IOException {
        if (string != null) {
            File file = new File(string);
            if (file.exists() && !file.canWrite()) {
                throw new FileNotFoundException("Could not write to file: " + file.getAbsolutePath());
            }
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.close();
        }
        this.dest = string;
    }

    @Override
    public boolean isDestinationCompressed() {
        return this.destinationCompressed;
    }

    public void setDestinationCompressed(boolean bl) {
        this.destinationCompressed = bl;
    }

    public void setOptions(RecordingOptions recordingOptions) throws IOException {
        this.setDestination(recordingOptions.getDestination());
        this.setDuration(recordingOptions.getDuration(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        this.setMaxAge(recordingOptions.getMaxAge(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        this.setMaxSize(recordingOptions.getMaxSize());
        this.setStartTime(recordingOptions.getStartTime());
        this.setDestinationCompressed(recordingOptions.isDestinationCompressed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimer() {
        if (!this.isStarted()) {
            return;
        }
        Object object = this.chunkLock;
        synchronized (object) {
            if (this.stopTask != null) {
                this.stopTask.cancel();
                this.stopTask = null;
            }
            if (this.endTime != null) {
                return;
            }
            if (this.duration != 0L) {
                this.stopTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Recording.this.stop();
                        }
                        catch (Throwable throwable) {
                            Recording.this.logger.error("Exception when stopping recording:", throwable);
                        }
                    }
                };
                this.timer.schedule(this.stopTask, new Date(this.startTime.getTime() + this.duration));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartTime(Date date) {
        Object object = this.chunkLock;
        synchronized (object) {
            if (this.isStarted()) {
                return;
            }
            if (this.startTask != null) {
                this.startTask.cancel();
                this.startTask = null;
            }
            if (date != null && !this.isClone) {
                this.startTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            Recording.this.start();
                        }
                        catch (IllegalStateException illegalStateException) {
                            assert (Recording.this.isStarted());
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            Recording.this.logger.error("Error when starting recording:", throwable);
                        }
                    }
                };
                this.timer.schedule(this.startTask, date);
            }
            this.startTime = date != null ? (Date)date.clone() : null;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[id=").append(this.id);
        if (this.name != null) {
            stringBuilder.append(", name=").append(this.name);
        }
        if (this.dest != null) {
            stringBuilder.append(", destination=").append(this.dest);
        }
        if (this.startTime != null) {
            stringBuilder.append(", start=").append(this.startTime);
        }
        if (this.endTime != null) {
            stringBuilder.append(", end=").append(this.endTime);
        }
        if (this.duration != 0L) {
            stringBuilder.append(", duration=").append(this.duration).append("ms");
        }
        if (this.maxSize != 0L) {
            stringBuilder.append(", maxSize=").append(this.maxSize);
        }
        if (this.maxAge != 0L) {
            stringBuilder.append(", maxAge=").append(this.maxAge).append("ms");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return (int)this.id;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyChunks(Recording recording) {
        ArrayList<RepositoryChunk> arrayList = new ArrayList<RepositoryChunk>();
        IdentityHashMap<RepositoryChunk, RepositoryChunk> identityHashMap = recording.chunkLock;
        synchronized (identityHashMap) {
            arrayList.addAll(recording.chunks);
        }
        identityHashMap = new IdentityHashMap<RepositoryChunk, RepositoryChunk>();
        ArrayList<RepositoryChunk> arrayList2 = new ArrayList<RepositoryChunk>();
        Object object = this.chunkLock;
        synchronized (object) {
            for (RepositoryChunk repositoryChunk : this.chunks) {
                identityHashMap.put(repositoryChunk, repositoryChunk);
                arrayList2.add(repositoryChunk);
            }
            for (RepositoryChunk repositoryChunk : arrayList) {
                if (identityHashMap.containsKey(repositoryChunk)) continue;
                this.added(repositoryChunk);
                arrayList2.add(repositoryChunk);
            }
            Collections.sort(arrayList2, new Comparator<RepositoryChunk>(){

                @Override
                public int compare(RepositoryChunk repositoryChunk, RepositoryChunk repositoryChunk2) {
                    return repositoryChunk.getStartTime().compareTo(repositoryChunk2.getStartTime());
                }
            });
            this.chunks.clear();
            this.chunks.addAll(arrayList2);
        }
    }

    public EventSettings getEventSettings() {
        return this.settingsAggregator;
    }
}

