/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.print.provider.ComponentPage;
import org.netbeans.modules.print.provider.ComponentPanel;
import org.netbeans.modules.print.util.Percent;
import org.netbeans.spi.print.PrintPage;
import org.netbeans.spi.print.PrintProvider;

public class ComponentProvider
implements PrintProvider {
    private String myName;
    private Date myLastModified;
    private JComponent myComponent;

    public ComponentProvider(List<JComponent> components, String name, Date lastModified) {
        this.myName = name;
        this.myLastModified = lastModified;
        if (components != null) {
            this.myComponent = new ComponentPanel(components);
        }
    }

    protected JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public PrintPage[][] getPages(int pageWidth, int pageHeight, double pageZoom) {
        ArrayList<ComponentPage> pages = new ArrayList<ComponentPage>();
        JComponent component = this.getComponent();
        if (component == null) {
            return new PrintPage[0][0];
        }
        int componentWidth = component.getWidth();
        int componentHeight = component.getHeight();
        double zoom = this.getZoom(pageZoom, pageWidth, pageHeight, componentWidth, componentHeight);
        componentWidth = (int)Math.floor((double)componentWidth * zoom);
        componentHeight = (int)Math.floor((double)componentHeight * zoom);
        int row = 0;
        int column = 0;
        for (int h = 0; h < componentHeight; h += pageHeight) {
            ++row;
            column = 0;
            for (int w = 0; w < componentWidth; w += pageWidth) {
                Rectangle piece = new Rectangle((++column - 1) * pageWidth, (row - 1) * pageHeight, pageWidth, pageHeight);
                pages.add(new ComponentPage(component, piece, zoom, row - 1, column - 1));
            }
        }
        PrintPage[][] printPages = new PrintPage[row][column];
        for (ComponentPage page : pages) {
            printPages[page.getRow()][page.getColumn()] = page;
        }
        return printPages;
    }

    private double getZoom(double zoom, int pageWidth, int pageHeight, int componentWidth, int componentHeight) {
        double factor = Percent.getZoomFactor(zoom, -1.0);
        if (0.0 < factor) {
            return factor;
        }
        if (Percent.isZoomPage(zoom)) {
            factor = 0.0;
        }
        int zoomWidth = Percent.getZoomWidth(zoom, -1);
        int zoomHeight = Percent.getZoomHeight(zoom, -1);
        if (factor == 0.0) {
            zoomWidth = 1;
            zoomHeight = 1;
        }
        return this.getZoom((double)(pageWidth * zoomWidth) / (double)componentWidth, (double)(pageHeight * zoomHeight) / (double)componentHeight);
    }

    private double getZoom(double widthZoom, double heightZoom) {
        if (widthZoom > 0.0 && heightZoom > 0.0) {
            return Math.min(widthZoom, heightZoom);
        }
        if (widthZoom < 0.0 && heightZoom > 0.0) {
            return heightZoom;
        }
        if (widthZoom > 0.0 && heightZoom < 0.0) {
            return widthZoom;
        }
        return 1.0;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Date lastModified() {
        return this.myLastModified;
    }
}

