/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.TouchInputSupport;
import com.sun.glass.ui.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MacTouchInputSupport
extends TouchInputSupport {
    private final Map<Long, WeakReference<View>> touchIdToView = new HashMap<Long, WeakReference<View>>();
    private int curModifiers;
    private boolean curIsDirect;
    private List<TouchPoint> curTouchPoints;

    MacTouchInputSupport(TouchInputSupport.TouchCountListener listener, boolean filterTouchCoordinates) {
        super(listener, filterTouchCoordinates);
    }

    public void notifyBeginTouchEvent(View view, int modifiers, boolean isDirect, int touchEventCount) {
        this.curModifiers = modifiers;
        this.curIsDirect = isDirect;
        this.curTouchPoints = new ArrayList<TouchPoint>(touchEventCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEndTouchEvent(View view) {
        if (this.curTouchPoints.isEmpty()) {
            return;
        }
        try {
            super.notifyBeginTouchEvent(view, this.curModifiers, this.curIsDirect, this.curTouchPoints.size());
            for (TouchPoint tp : this.curTouchPoints) {
                super.notifyNextTouchEvent(view, tp.state, tp.id, tp.x, tp.y, tp.xAbs, tp.yAbs);
            }
            super.notifyEndTouchEvent(view);
        }
        finally {
            this.curTouchPoints = null;
        }
    }

    public void notifyNextTouchEvent(View view, int state, long id, int x, int y, int xAbs, int yAbs) {
        View storedView = null;
        if (state == 811) {
            storedView = view;
            this.touchIdToView.put(id, new WeakReference<View>(view));
        } else {
            storedView = (View)this.touchIdToView.get(id).get();
            if (state == 813) {
                this.touchIdToView.remove(id);
            }
        }
        if (storedView == view) {
            this.curTouchPoints.add(new TouchPoint(state, id, x, y, xAbs, yAbs));
        } else {
            if (storedView != null && storedView.isClosed()) {
                storedView = null;
            }
            super.notifyBeginTouchEvent(storedView, this.curModifiers, this.curIsDirect, 1);
            super.notifyNextTouchEvent(storedView, state, id, x, y, xAbs, yAbs);
            super.notifyEndTouchEvent(storedView);
        }
    }

    private static class TouchPoint {
        final int state;
        final long id;
        final int x;
        final int y;
        final int xAbs;
        final int yAbs;

        TouchPoint(int state, long id, int x, int y, int xAbs, int yAbs) {
            this.state = state;
            this.id = id;
            this.x = x;
            this.y = y;
            this.xAbs = xAbs;
            this.yAbs = yAbs;
        }
    }
}

