/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.daemon.SnmpResponseHandler;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.logging.Level;

final class SnmpSocket
implements Runnable {
    private DatagramSocket _socket = null;
    private SnmpResponseHandler _dgramHdlr = null;
    private Thread _sockThread = null;
    private byte[] _buffer = null;
    private transient boolean isClosing = false;
    int _socketPort = 0;
    int responseBufSize = 1024;

    public SnmpSocket(SnmpResponseHandler snmpResponseHandler, InetAddress inetAddress, int n) throws SocketException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "constructor", "Creating new SNMP datagram socket");
        }
        this._socket = new DatagramSocket(0, inetAddress);
        this._socketPort = this._socket.getLocalPort();
        this.responseBufSize = n;
        this._buffer = new byte[this.responseBufSize];
        this._dgramHdlr = snmpResponseHandler;
        this._sockThread = new Thread((Runnable)this, "SnmpSocket");
        this._sockThread.start();
    }

    public synchronized void sendPacket(byte[] byArray, int n, InetAddress inetAddress, int n2) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, inetAddress, n2);
        this.sendPacket(datagramPacket);
    }

    public synchronized void sendPacket(DatagramPacket datagramPacket) throws IOException {
        try {
            if (this.isValid()) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "sendPacket", "Sending DatagramPacket. Length = " + datagramPacket.getLength() + " through socket = " + this._socket.toString());
                }
            } else {
                throw new IOException("Invalid state of SNMP datagram socket.");
            }
            this._socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "sendPacket", "I/O error while sending", iOException);
            }
            throw iOException;
        }
    }

    public synchronized boolean isValid() {
        return this._socket != null && this._sockThread != null && this._sockThread.isAlive();
    }

    public synchronized void close() {
        this.isClosing = true;
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "close", "Closing and destroying the SNMP datagram socket -> " + this.toString());
        }
        try {
            DatagramSocket datagramSocket = new DatagramSocket(0);
            byte[] byArray = new byte[1];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, 1, InetAddress.getLocalHost(), this._socketPort);
            datagramSocket.send(datagramPacket);
            datagramSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (this._sockThread != null && this._sockThread.isAlive()) {
            this._sockThread.interrupt();
            try {
                this._sockThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._sockThread = null;
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(8);
        block5: while (true) {
            try {
                while (true) {
                    DatagramPacket datagramPacket = new DatagramPacket(this._buffer, this._buffer.length);
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "run", "[" + Thread.currentThread().toString() + "]:" + "Blocking for receiving packet");
                    }
                    this._socket.receive(datagramPacket);
                    if (this.isClosing) break block5;
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet");
                    }
                    if (datagramPacket.getLength() <= 0) continue;
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet from : " + datagramPacket.getAddress().toString() + ", Length = " + datagramPacket.getLength());
                    }
                    this.handleDatagram(datagramPacket);
                    if (this.isClosing) break;
                }
            }
            catch (IOException iOException) {
                if (this.isClosing) break;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "run", "IOEXception while receiving datagram", iOException);
                continue;
            }
            catch (Exception exception) {
                if (this.isClosing) break;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "run", "Exception in socket thread...", exception);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "run", "Socket Thread DEAD..." + this.toString(), threadDeath);
                }
                this.close();
                throw threadDeath;
            }
            catch (Error error) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "run", "Got unexpected error", error);
                }
                this.handleJavaError(error);
                continue;
            }
            break;
        }
    }

    public synchronized void finalize() {
        this.close();
    }

    private synchronized void handleJavaError(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "handleJavaError", "OutOfMemory error", throwable);
            }
            Thread.currentThread();
            Thread.yield();
            return;
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "handleJavaError", "Global Internal error");
        }
        Thread.currentThread();
        Thread.yield();
    }

    private synchronized void handleDatagram(DatagramPacket datagramPacket) {
        this._dgramHdlr.processDatagram(datagramPacket);
    }
}

