/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.openide.util.Utilities;

class Utils {
    private static final String EMACS_CTRL = "Ctrl+";
    private static final String EMACS_ALT = "Alt+";
    private static final String EMACS_SHIFT = "Shift+";
    private static final String EMACS_META = "Meta+";
    private static final String STRING_META;
    private static final String STRING_ALT;

    Utils() {
    }

    static String getKeyStrokesAsText(KeyStroke[] keyStrokes, String delim) {
        if (keyStrokes == null) {
            return "";
        }
        if (keyStrokes.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(Utils.getKeyStrokeAsText(keyStrokes[0]));
        int k = keyStrokes.length;
        for (int i = 1; i < k; ++i) {
            sb.append(delim).append(Utils.getKeyStrokeAsText(keyStrokes[i]));
        }
        return new String(sb);
    }

    static KeyStroke getKeyStroke(String keyStroke) {
        int modifiers = 0;
        while (true) {
            if (keyStroke.startsWith(EMACS_CTRL)) {
                modifiers |= 0x80;
                keyStroke = keyStroke.substring(EMACS_CTRL.length());
                continue;
            }
            if (keyStroke.startsWith(EMACS_ALT)) {
                modifiers |= 0x200;
                keyStroke = keyStroke.substring(EMACS_ALT.length());
                continue;
            }
            if (keyStroke.startsWith(EMACS_SHIFT)) {
                modifiers |= 0x40;
                keyStroke = keyStroke.substring(EMACS_SHIFT.length());
                continue;
            }
            if (keyStroke.startsWith(EMACS_META)) {
                modifiers |= 0x100;
                keyStroke = keyStroke.substring(EMACS_META.length());
                continue;
            }
            if (keyStroke.startsWith(STRING_ALT)) {
                modifiers |= 0x200;
                keyStroke = keyStroke.substring(STRING_ALT.length());
                continue;
            }
            if (!keyStroke.startsWith(STRING_META)) break;
            modifiers |= 0x100;
            keyStroke = keyStroke.substring(STRING_META.length());
        }
        KeyStroke ks = Utilities.stringToKey((String)keyStroke);
        if (ks == null) {
            return null;
        }
        KeyStroke result = KeyStroke.getKeyStroke(ks.getKeyCode(), modifiers);
        return result;
    }

    static String getKeyStrokeAsText(KeyStroke keyStroke) {
        int modifiers = keyStroke.getModifiers();
        StringBuilder sb = new StringBuilder();
        if ((modifiers & 0x80) > 0) {
            sb.append(EMACS_CTRL);
        }
        if ((modifiers & 0x200) > 0) {
            sb.append(STRING_ALT);
        }
        if ((modifiers & 0x40) > 0) {
            sb.append(EMACS_SHIFT);
        }
        if ((modifiers & 0x100) > 0) {
            sb.append(STRING_META);
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            sb.append(Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        return sb.toString();
    }

    static {
        if (Utilities.isMac()) {
            STRING_META = KeyEvent.getKeyText(157).concat("+");
            STRING_ALT = KeyEvent.getKeyText(18).concat("+");
        } else {
            STRING_META = EMACS_META;
            STRING_ALT = EMACS_ALT;
        }
    }
}

