/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.event;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.event.Event;
import javafx.event.EventHandler;

public final class CompositeEventHandler<T extends Event> {
    private List<EventHandler<? super T>> eventHandlers;
    private List<EventHandler<? super T>> eventFilters;
    private EventHandler<? super T> eventHandler;

    public void setEventHandler(EventHandler<? super T> eventHandler) {
        this.eventHandler = eventHandler;
    }

    public EventHandler<? super T> getEventHandler() {
        return this.eventHandler;
    }

    public void addEventHandler(EventHandler<? super T> eventHandler) {
        if (this.eventHandlers == null) {
            this.eventHandlers = new CopyOnWriteArrayList<EventHandler<? super T>>();
        }
        if (!this.eventHandlers.contains(eventHandler)) {
            this.eventHandlers.add(eventHandler);
        }
    }

    public void removeEventHandler(EventHandler<? super T> eventHandler) {
        if (this.eventHandlers != null) {
            this.eventHandlers.remove(eventHandler);
        }
    }

    public void addEventFilter(EventHandler<? super T> eventHandler) {
        if (this.eventFilters == null) {
            this.eventFilters = new CopyOnWriteArrayList<EventHandler<? super T>>();
        }
        if (!this.eventFilters.contains(eventHandler)) {
            this.eventFilters.add(eventHandler);
        }
    }

    public void removeEventFilter(EventHandler<? super T> eventHandler) {
        if (this.eventFilters != null) {
            this.eventFilters.remove(eventHandler);
        }
    }

    public void dispatchBubblingEvent(Event event) {
        Event event2 = event;
        if (this.eventHandlers != null) {
            for (EventHandler<Event> eventHandler : this.eventHandlers) {
                eventHandler.handle(event2);
            }
        }
        if (this.eventHandler != null) {
            this.eventHandler.handle(event2);
        }
    }

    public void dispatchCapturingEvent(Event event) {
        Event event2 = event;
        if (this.eventFilters != null) {
            for (EventHandler<Event> eventHandler : this.eventFilters) {
                eventHandler.handle(event2);
            }
        }
    }
}

