/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven;

import com.thoughtworks.selenium.SeleniumException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public abstract class SeleneseCommand<T> {
    private long defaultTimeout;

    public T apply(WebDriver driver, String[] args) {
        try {
            switch (args.length) {
                case 0: {
                    return this.handleSeleneseCommand(driver, null, null);
                }
                case 1: {
                    return this.handleSeleneseCommand(driver, args[0], null);
                }
                case 2: {
                    return this.handleSeleneseCommand(driver, args[0], args[1]);
                }
            }
            throw new SeleniumException("Too many arguments! " + args.length);
        }
        catch (WebDriverException e) {
            throw new SeleniumException(e.getMessage(), e);
        }
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    protected long getTimeout(String timeout) {
        return "".equals(timeout) ? this.defaultTimeout : Long.valueOf(timeout);
    }

    protected abstract T handleSeleneseCommand(WebDriver var1, String var2, String var3);
}

