/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextRegexpUtil;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.matcher.MatcherUtils;
import org.netbeans.modules.search.matcher.MultiLineStreamMatcher;
import org.netbeans.modules.search.matcher.SingleLineStreamMatcher;
import org.netbeans.modules.search.matcher.TrivialFileMatcher;
import org.openide.filesystems.FileObject;

public class DefaultMatcher
extends AbstractMatcher {
    private static final int MAX_UNRECOGNIZED_FILE_SIZE = 0x500000;
    private static final Collection<String> searchableXMimeTypes = new HashSet<String>(17);
    private static final Collection<String> searchableExtensions;
    private AbstractMatcher realMatcher;
    private boolean trivial;

    public DefaultMatcher(SearchPattern searchPattern) {
        boolean multiline;
        this.trivial = MatcherUtils.isTrivialPattern(searchPattern);
        this.realMatcher = this.trivial ? new TrivialFileMatcher() : ((multiline = TextRegexpUtil.canBeMultilinePattern(searchPattern.getSearchExpression())) ? new MultiLineStreamMatcher(searchPattern) : new SingleLineStreamMatcher(searchPattern));
    }

    @Override
    public MatchingObject.Def checkMeasuredInternal(FileObject file, SearchListener listener) {
        if (this.trivial) {
            return this.realMatcher.check(file, listener);
        }
        if (DefaultMatcher.isTextFile(file)) {
            try {
                return this.realMatcher.check(file, listener);
            }
            catch (Exception e) {
                listener.fileContentMatchingError(file.getPath(), e);
                return null;
            }
        }
        listener.fileSkipped(file, null, "Not a text file");
        return null;
    }

    @Override
    public synchronized void terminate() {
        this.realMatcher.terminate();
    }

    private static boolean isTextFile(FileObject fileObj) {
        String mimeType = fileObj.getMIMEType();
        if (mimeType.equals("content/unknown")) {
            if (searchableExtensions.contains(fileObj.getExt().toLowerCase())) {
                return true;
            }
            return fileObj.getSize() <= 0x500000L;
        }
        if (mimeType.startsWith("text/")) {
            return true;
        }
        if (mimeType.startsWith("application/")) {
            String subtype = mimeType.substring(12);
            return subtype.equals("rtf") || subtype.equals("sgml") || subtype.startsWith("xml-") || subtype.endsWith("+xml") || subtype.startsWith("x-") && searchableXMimeTypes.contains(subtype.substring(2));
        }
        return false;
    }

    @Override
    public void setStrict(boolean strict) {
        super.setStrict(strict);
        this.realMatcher.setStrict(strict);
    }

    static {
        searchableXMimeTypes.add("csh");
        searchableXMimeTypes.add("httpd-eruby");
        searchableXMimeTypes.add("httpd-php");
        searchableXMimeTypes.add("httpd-php-source");
        searchableXMimeTypes.add("javascript");
        searchableXMimeTypes.add("latex");
        searchableXMimeTypes.add("php");
        searchableXMimeTypes.add("sh");
        searchableXMimeTypes.add("tcl");
        searchableXMimeTypes.add("tex");
        searchableXMimeTypes.add("texinfo");
        searchableXMimeTypes.add("troff");
        searchableExtensions = new HashSet<String>();
        searchableExtensions.add("txt");
        searchableExtensions.add("log");
    }
}

