/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario;

import com.sun.scenario.ToolkitAccessor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;

public class Settings {
    private final Map<String, String> settings = new HashMap<String, String>(5);
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(Settings.class);
    private static final Object SETTINGS_KEY = new StringBuilder("SettingsKey");

    private static synchronized Settings getInstance() {
        Map<Object, Object> map = ToolkitAccessor.getContextMap();
        Settings settings = (Settings)map.get(SETTINGS_KEY);
        if (settings == null) {
            settings = new Settings();
            map.put(SETTINGS_KEY, settings);
        }
        return settings;
    }

    public static void set(String string, String string2) {
        Settings.getInstance().setImpl(string, string2);
    }

    private void setImpl(String string, String string2) {
        this.checkKeyArg(string);
        String string3 = this.getImpl(string);
        this.settings.put(string, string2);
        String string4 = string2;
        if (string4 == null) {
            string4 = this.getImpl(string);
        }
        this.pcs.firePropertyChange(string, string3, string4);
    }

    public static String get(String string) {
        return Settings.getInstance().getImpl(string);
    }

    private String getImpl(String string) {
        this.checkKeyArg(string);
        String string2 = this.settings.get(string);
        if (string2 == null) {
            try {
                string2 = System.getProperty(string);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static boolean getBoolean(String string) {
        return Settings.getInstance().getBooleanImpl(string);
    }

    private boolean getBooleanImpl(String string) {
        String string2 = this.getImpl(string);
        return "true".equals(string2);
    }

    public static boolean getBoolean(String string, boolean bl) {
        return Settings.getInstance().getBooleanImpl(string, bl);
    }

    private boolean getBooleanImpl(String string, boolean bl) {
        String string2 = this.getImpl(string);
        boolean bl2 = bl;
        if (string2 != null) {
            if ("false".equals(string2)) {
                bl2 = false;
            } else if ("true".equals(string2)) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static int getInt(String string, int n) {
        return Settings.getInstance().getIntImpl(string, n);
    }

    private int getIntImpl(String string, int n) {
        String string2 = this.getImpl(string);
        int n2 = n;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public static void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        Settings.getInstance().addPropertyChangeListenerImpl(string, propertyChangeListener);
    }

    private void addPropertyChangeListenerImpl(String string, PropertyChangeListener propertyChangeListener) {
        this.checkKeyArg(string);
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Settings.getInstance().removePropertyChangeListenerImpl(propertyChangeListener);
    }

    private void removePropertyChangeListenerImpl(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void checkKeyArg(String string) {
        if (null == string || "".equals(string)) {
            throw new IllegalArgumentException("null key not allowed");
        }
    }

    private Settings() {
    }
}

