/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.ui;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import org.netbeans.modules.print.ui.Paper;
import org.netbeans.modules.print.util.Config;
import org.netbeans.modules.print.util.UI;

final class Printer
implements Printable {
    private List<Paper> myPapers;

    Printer() {
    }

    void print(List<Paper> papers) {
        PrinterJob job = PrinterJob.getPrinterJob();
        this.myPapers = papers;
        if (job == null) {
            return;
        }
        job.setPrintable(this, Config.getDefault().getPageFormat());
        try {
            if (job.printDialog()) {
                job.print();
            }
        }
        catch (PrinterException e) {
            UI.printError(UI.i18n(Printer.class, "ERR_Printer_Problem", e.getLocalizedMessage()));
        }
        this.myPapers = null;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int index) throws PrinterException {
        if (index == this.myPapers.size()) {
            return 1;
        }
        this.myPapers.get(index).print(g);
        return 0;
    }
}

