/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.RhinoException;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;

public final class LazilyLoadedCtor {
    private static final int STATE_BEFORE_INIT = 0;
    private static final int STATE_INITIALIZING = 1;
    private static final int STATE_WITH_VALUE = 2;
    private final ScriptableObject scope;
    private final String propertyName;
    private final String className;
    private final boolean sealed;
    private final boolean privileged;
    private Object initializedValue;
    private int state;

    public LazilyLoadedCtor(ScriptableObject scriptableObject, String string, String string2, boolean bl) {
        this(scriptableObject, string, string2, bl, false);
    }

    LazilyLoadedCtor(ScriptableObject scriptableObject, String string, String string2, boolean bl, boolean bl2) {
        this.scope = scriptableObject;
        this.propertyName = string;
        this.className = string2;
        this.sealed = bl;
        this.privileged = bl2;
        this.state = 0;
        scriptableObject.addLazilyInitializedValue(string, 0, this, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        LazilyLoadedCtor lazilyLoadedCtor = this;
        synchronized (lazilyLoadedCtor) {
            if (this.state == 1) {
                throw new IllegalStateException("Recursive initialization for " + this.propertyName);
            }
            if (this.state == 0) {
                this.state = 1;
                Object object = Scriptable.NOT_FOUND;
                try {
                    object = this.buildValue();
                }
                finally {
                    this.initializedValue = object;
                    this.state = 2;
                }
            }
        }
    }

    Object getValue() {
        if (this.state != 2) {
            throw new IllegalStateException(this.propertyName);
        }
        return this.initializedValue;
    }

    private Object buildValue() {
        if (this.privileged) {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return LazilyLoadedCtor.this.buildValue0();
                }
            });
        }
        return this.buildValue0();
    }

    private Object buildValue0() {
        Class<? extends Scriptable> clazz = this.cast(Kit.classOrNull(this.className));
        if (clazz != null) {
            try {
                Object object = ScriptableObject.buildClassCtor(this.scope, clazz, this.sealed, false);
                if (object != null) {
                    return object;
                }
                object = this.scope.get(this.propertyName, (Scriptable)this.scope);
                if (object != Scriptable.NOT_FOUND) {
                    return object;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
            }
            catch (RhinoException rhinoException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return Scriptable.NOT_FOUND;
    }

    private Class<? extends Scriptable> cast(Class<?> clazz) {
        return clazz;
    }
}

