/*
 * Decompiled with CFR 0.152.
 */
package org.shop.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;

public class BoundsPopupMenuListener
implements PopupMenuListener {
    private boolean scrollBarRequired = true;
    private boolean popupWider;
    private int maximumWidth = -1;
    private boolean popupAbove;
    private JScrollPane scrollPane;

    public BoundsPopupMenuListener() {
        this(true, false, -1, false);
    }

    public BoundsPopupMenuListener(boolean popupWider, boolean popupAbove) {
        this(true, popupWider, -1, popupAbove);
    }

    public BoundsPopupMenuListener(int maximumWidth) {
        this(true, true, maximumWidth, false);
    }

    public BoundsPopupMenuListener(boolean scrollBarRequired, boolean popupWider, int maximumWidth, boolean popupAbove) {
        this.setScrollBarRequired(scrollBarRequired);
        this.setPopupWider(popupWider);
        this.setMaximumWidth(maximumWidth);
        this.setPopupAbove(popupAbove);
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(int maximumWidth) {
        this.maximumWidth = maximumWidth;
    }

    public boolean isPopupAbove() {
        return this.popupAbove;
    }

    public void setPopupAbove(boolean popupAbove) {
        this.popupAbove = popupAbove;
    }

    public boolean isPopupWider() {
        return this.popupWider;
    }

    public void setPopupWider(boolean popupWider) {
        this.popupWider = popupWider;
    }

    public boolean isScrollBarRequired() {
        return this.scrollBarRequired;
    }

    public void setScrollBarRequired(boolean scrollBarRequired) {
        this.scrollBarRequired = scrollBarRequired;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        JComboBox comboBox = (JComboBox)e.getSource();
        if (comboBox.getItemCount() == 0) {
            return;
        }
        final Accessible child = comboBox.getAccessibleContext().getAccessibleChild(0);
        if (child instanceof BasicComboPopup) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BoundsPopupMenuListener.this.customizePopup((BasicComboPopup)child);
                }
            });
        }
    }

    protected void customizePopup(BasicComboPopup popup) {
        this.scrollPane = this.getScrollPane(popup);
        if (this.popupWider) {
            this.popupWider(popup);
        }
        this.checkHorizontalScrollBar(popup);
        Component comboBox = popup.getInvoker();
        Point location = comboBox.getLocationOnScreen();
        if (this.popupAbove) {
            int height = popup.getPreferredSize().height;
            popup.setLocation(location.x, location.y - height);
        } else {
            int height = comboBox.getPreferredSize().height;
            popup.setLocation(location.x, location.y + height - 1);
            popup.setLocation(location.x, location.y + height);
        }
    }

    protected void popupWider(BasicComboPopup popup) {
        JList<Object> list = popup.getList();
        int popupWidth = list.getPreferredSize().width + 5 + this.getScrollBarWidth(popup, this.scrollPane);
        if (this.maximumWidth != -1) {
            popupWidth = Math.min(popupWidth, this.maximumWidth);
        }
        Dimension scrollPaneSize = this.scrollPane.getPreferredSize();
        scrollPaneSize.width = popupWidth = Math.max(popupWidth, scrollPaneSize.width);
        this.scrollPane.setPreferredSize(scrollPaneSize);
        this.scrollPane.setMaximumSize(scrollPaneSize);
    }

    private void checkHorizontalScrollBar(BasicComboPopup popup) {
        JViewport viewport = this.scrollPane.getViewport();
        Point p = viewport.getViewPosition();
        p.x = 0;
        viewport.setViewPosition(p);
        if (!this.scrollBarRequired) {
            this.scrollPane.setHorizontalScrollBar(null);
            return;
        }
        JScrollBar horizontal = this.scrollPane.getHorizontalScrollBar();
        if (horizontal == null) {
            horizontal = new JScrollBar(0);
            this.scrollPane.setHorizontalScrollBar(horizontal);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
        }
        if (this.horizontalScrollBarWillBeVisible(popup, this.scrollPane)) {
            Dimension scrollPaneSize = this.scrollPane.getPreferredSize();
            scrollPaneSize.height += horizontal.getPreferredSize().height;
            this.scrollPane.setPreferredSize(scrollPaneSize);
            this.scrollPane.setMaximumSize(scrollPaneSize);
            this.scrollPane.revalidate();
        }
    }

    protected JScrollPane getScrollPane(BasicComboPopup popup) {
        JList<Object> list = popup.getList();
        Container c = SwingUtilities.getAncestorOfClass(JScrollPane.class, list);
        return (JScrollPane)c;
    }

    protected int getScrollBarWidth(BasicComboPopup popup, JScrollPane scrollPane) {
        int scrollBarWidth = 0;
        JComboBox comboBox = (JComboBox)popup.getInvoker();
        if (comboBox.getItemCount() > comboBox.getMaximumRowCount()) {
            JScrollBar vertical = scrollPane.getVerticalScrollBar();
            scrollBarWidth = vertical.getPreferredSize().width;
        }
        return scrollBarWidth;
    }

    protected boolean horizontalScrollBarWillBeVisible(BasicComboPopup popup, JScrollPane scrollPane) {
        JList<Object> list = popup.getList();
        int scrollBarWidth = this.getScrollBarWidth(popup, scrollPane);
        int popupWidth = list.getPreferredSize().width + scrollBarWidth;
        return popupWidth > scrollPane.getPreferredSize().width;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.scrollPane != null) {
            this.scrollPane.setHorizontalScrollBar(null);
        }
    }
}

