/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupByClause
extends AbstractExpression {
    private AbstractExpression groupByItems;
    private boolean hasSpace;

    GroupByClause(AbstractExpression parent) {
        super(parent, "GROUP BY");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getGroupByItems().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getGroupByItems());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression(this.getText()));
        if (this.hasSpace) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.groupByItems != null) {
            children.add(this.groupByItems);
        }
    }

    public CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getGroupByItems());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    public Expression getGroupByItems() {
        if (this.groupByItems == null) {
            this.groupByItems = this.buildNullExpression();
        }
        return this.groupByItems;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return GroupByClause.queryBNF("groupby_clause");
    }

    public boolean hasGroupByItems() {
        return this.groupByItems != null && !this.groupByItems.isNull();
    }

    public boolean hasSpaceAfterGroupBy() {
        return this.hasSpace;
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward("GROUP BY");
        this.hasSpace = wordParser.skipLeadingWhitespace() > 0;
        this.groupByItems = this.parse(wordParser, (JPQLQueryBNF)GroupByClause.queryBNF("groupby_item"), tolerant);
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append(this.getText());
        if (this.hasSpace) {
            writer.append(' ');
        }
        if (this.groupByItems != null) {
            this.groupByItems.toParsedText(writer, includeVirtual);
        }
    }
}

