/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.server.LogStream;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

public final class Util {
    static final int logLevel = LogStream.parseLevel(AccessController.doPrivileged(new GetPropertyAction("sun.rmi.server.logLevel")));
    public static final Log serverRefLog = Log.getLog("sun.rmi.server.ref", "transport", logLevel);
    private static final boolean ignoreStubClasses = AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.ignoreStubClasses"));
    private static final Map<Class<?>, Void> withoutStubs = Collections.synchronizedMap(new WeakHashMap(11));
    private static final Class[] stubConsParamTypes = new Class[]{RemoteRef.class};

    private Util() {
    }

    public static Remote createProxy(Class<?> clazz, RemoteRef remoteRef, boolean bl) throws StubNotFoundException {
        Class<?> clazz2;
        try {
            clazz2 = Util.getRemoteClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StubNotFoundException("object does not implement a remote interface: " + clazz.getName());
        }
        if (bl || !ignoreStubClasses && Util.stubClassExists(clazz2)) {
            return Util.createStub(clazz2, remoteRef);
        }
        ClassLoader classLoader = clazz.getClassLoader();
        Class<?>[] classArray = Util.getRemoteInterfaces(clazz);
        RemoteObjectInvocationHandler remoteObjectInvocationHandler = new RemoteObjectInvocationHandler(remoteRef);
        try {
            return (Remote)Proxy.newProxyInstance(classLoader, classArray, remoteObjectInvocationHandler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new StubNotFoundException("unable to create proxy", illegalArgumentException);
        }
    }

    private static boolean stubClassExists(Class<?> clazz) {
        if (!withoutStubs.containsKey(clazz)) {
            try {
                Class.forName(clazz.getName() + "_Stub", false, clazz.getClassLoader());
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                withoutStubs.put(clazz, null);
            }
        }
        return false;
    }

    private static Class<?> getRemoteClass(Class<?> clazz) throws ClassNotFoundException {
        while (clazz != null) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = classArray.length - 1; i >= 0; --i) {
                if (!Remote.class.isAssignableFrom(classArray[i])) continue;
                return clazz;
            }
            clazz = clazz.getSuperclass();
        }
        throw new ClassNotFoundException("class does not implement java.rmi.Remote");
    }

    private static Class<?>[] getRemoteInterfaces(Class<?> clazz) {
        ArrayList arrayList = new ArrayList();
        Util.getRemoteInterfaces(arrayList, clazz);
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private static void getRemoteInterfaces(ArrayList<Class<?>> arrayList, Class<?> clazz) {
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            Util.getRemoteInterfaces(arrayList, clazz2);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz3 = classArray[i];
            if (!Remote.class.isAssignableFrom(clazz3) || arrayList.contains(clazz3)) continue;
            Method[] methodArray = clazz3.getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                Util.checkMethod(methodArray[j]);
            }
            arrayList.add(clazz3);
        }
    }

    private static void checkMethod(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(RemoteException.class)) continue;
            return;
        }
        throw new IllegalArgumentException("illegal remote method encountered: " + method);
    }

    private static RemoteStub createStub(Class<?> clazz, RemoteRef remoteRef) throws StubNotFoundException {
        String string = clazz.getName() + "_Stub";
        try {
            Class<?> clazz2 = Class.forName(string, false, clazz.getClassLoader());
            Constructor<?> constructor = clazz2.getConstructor(stubConsParamTypes);
            return (RemoteStub)constructor.newInstance(remoteRef);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StubNotFoundException("Stub class not found: " + string, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new StubNotFoundException("Stub class missing constructor: " + string, noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new StubNotFoundException("Can't create instance of stub class: " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new StubNotFoundException("Stub class constructor not public: " + string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new StubNotFoundException("Exception creating instance of stub class: " + string, invocationTargetException);
        }
        catch (ClassCastException classCastException) {
            throw new StubNotFoundException("Stub class not instance of RemoteStub: " + string, classCastException);
        }
    }

    static Skeleton createSkeleton(Remote remote) throws SkeletonNotFoundException {
        Class<?> clazz;
        try {
            clazz = Util.getRemoteClass(remote.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SkeletonNotFoundException("object does not implement a remote interface: " + remote.getClass().getName());
        }
        String string = clazz.getName() + "_Skel";
        try {
            Class<?> clazz2 = Class.forName(string, false, clazz.getClassLoader());
            return (Skeleton)clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SkeletonNotFoundException("Skeleton class not found: " + string, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new SkeletonNotFoundException("Can't create skeleton: " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SkeletonNotFoundException("No public constructor: " + string, illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw new SkeletonNotFoundException("Skeleton not of correct class: " + string, classCastException);
        }
    }

    public static long computeMethodHash(Method method) {
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(127);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
            String string = Util.getMethodNameAndDescriptor(method);
            if (serverRefLog.isLoggable(Log.VERBOSE)) {
                serverRefLog.log(Log.VERBOSE, "string used for method hash: \"" + string + "\"");
            }
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                l += (long)(byArray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    private static String getMethodNameAndDescriptor(Method method) {
        StringBuffer stringBuffer = new StringBuffer(method.getName());
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(Util.getTypeDescriptor(classArray[i]));
        }
        stringBuffer.append(')');
        Class<?> clazz = method.getReturnType();
        if (clazz == Void.TYPE) {
            stringBuffer.append('V');
        } else {
            stringBuffer.append(Util.getTypeDescriptor(clazz));
        }
        return stringBuffer.toString();
    }

    private static String getTypeDescriptor(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new Error("unrecognized primitive type: " + clazz);
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    public static String getUnqualifiedName(Class<?> clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }
}

