/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.ObjToIntMap;
import sun.org.mozilla.javascript.internal.ast.Jump;
import sun.org.mozilla.javascript.internal.ast.Name;
import sun.org.mozilla.javascript.internal.ast.NumberLiteral;
import sun.org.mozilla.javascript.internal.ast.Scope;
import sun.org.mozilla.javascript.internal.ast.ScriptNode;

public class Node
implements Iterable<Node> {
    public static final int FUNCTION_PROP = 1;
    public static final int LOCAL_PROP = 2;
    public static final int LOCAL_BLOCK_PROP = 3;
    public static final int REGEXP_PROP = 4;
    public static final int CASEARRAY_PROP = 5;
    public static final int TARGETBLOCK_PROP = 6;
    public static final int VARIABLE_PROP = 7;
    public static final int ISNUMBER_PROP = 8;
    public static final int DIRECTCALL_PROP = 9;
    public static final int SPECIALCALL_PROP = 10;
    public static final int SKIP_INDEXES_PROP = 11;
    public static final int OBJECT_IDS_PROP = 12;
    public static final int INCRDECR_PROP = 13;
    public static final int CATCH_SCOPE_PROP = 14;
    public static final int LABEL_ID_PROP = 15;
    public static final int MEMBER_TYPE_PROP = 16;
    public static final int NAME_PROP = 17;
    public static final int CONTROL_BLOCK_PROP = 18;
    public static final int PARENTHESIZED_PROP = 19;
    public static final int GENERATOR_END_PROP = 20;
    public static final int DESTRUCTURING_ARRAY_LENGTH = 21;
    public static final int DESTRUCTURING_NAMES = 22;
    public static final int DESTRUCTURING_PARAMS = 23;
    public static final int JSDOC_PROP = 24;
    public static final int EXPRESSION_CLOSURE_PROP = 25;
    public static final int DESTRUCTURING_SHORTHAND = 26;
    public static final int LAST_PROP = 26;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int NON_SPECIALCALL = 0;
    public static final int SPECIALCALL_EVAL = 1;
    public static final int SPECIALCALL_WITH = 2;
    public static final int DECR_FLAG = 1;
    public static final int POST_FLAG = 2;
    public static final int PROPERTY_FLAG = 1;
    public static final int ATTRIBUTE_FLAG = 2;
    public static final int DESCENDANTS_FLAG = 4;
    private static final Node NOT_SET = new Node(-1);
    public static final int END_UNREACHED = 0;
    public static final int END_DROPS_OFF = 1;
    public static final int END_RETURNS = 2;
    public static final int END_RETURNS_VALUE = 4;
    public static final int END_YIELDS = 8;
    protected int type = -1;
    protected Node next;
    protected Node first;
    protected Node last;
    protected int lineno = -1;
    protected PropListItem propListHead;

    public Node(int n) {
        this.type = n;
    }

    public Node(int n, Node node) {
        this.type = n;
        this.first = this.last = node;
        node.next = null;
    }

    public Node(int n, Node node, Node node2) {
        this.type = n;
        this.first = node;
        this.last = node2;
        node.next = node2;
        node2.next = null;
    }

    public Node(int n, Node node, Node node2, Node node3) {
        this.type = n;
        this.first = node;
        this.last = node3;
        node.next = node2;
        node2.next = node3;
        node3.next = null;
    }

    public Node(int n, int n2) {
        this.type = n;
        this.lineno = n2;
    }

    public Node(int n, Node node, int n2) {
        this(n, node);
        this.lineno = n2;
    }

    public Node(int n, Node node, Node node2, int n2) {
        this(n, node, node2);
        this.lineno = n2;
    }

    public Node(int n, Node node, Node node2, Node node3, int n2) {
        this(n, node, node2, node3);
        this.lineno = n2;
    }

    public static Node newNumber(double d) {
        NumberLiteral numberLiteral = new NumberLiteral();
        numberLiteral.setNumber(d);
        return numberLiteral;
    }

    public static Node newString(String string) {
        return Node.newString(41, string);
    }

    public static Node newString(int n, String string) {
        Name name = new Name();
        name.setIdentifier(string);
        name.setType(n);
        return name;
    }

    public int getType() {
        return this.type;
    }

    public Node setType(int n) {
        this.type = n;
        return this;
    }

    public String getJsDoc() {
        return (String)this.getProp(24);
    }

    public void setJsDoc(String string) {
        this.putProp(24, string);
    }

    public boolean hasChildren() {
        return this.first != null;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public Node getNext() {
        return this.next;
    }

    public Node getChildBefore(Node node) {
        if (node == this.first) {
            return null;
        }
        Node node2 = this.first;
        while (node2.next != node) {
            node2 = node2.next;
            if (node2 != null) continue;
            throw new RuntimeException("node is not a child");
        }
        return node2;
    }

    public Node getLastSibling() {
        Node node = this;
        while (node.next != null) {
            node = node.next;
        }
        return node;
    }

    public void addChildToFront(Node node) {
        node.next = this.first;
        this.first = node;
        if (this.last == null) {
            this.last = node;
        }
    }

    public void addChildToBack(Node node) {
        node.next = null;
        if (this.last == null) {
            this.first = this.last = node;
            return;
        }
        this.last.next = node;
        this.last = node;
    }

    public void addChildrenToFront(Node node) {
        Node node2 = node.getLastSibling();
        node2.next = this.first;
        this.first = node;
        if (this.last == null) {
            this.last = node2;
        }
    }

    public void addChildrenToBack(Node node) {
        if (this.last != null) {
            this.last.next = node;
        }
        this.last = node.getLastSibling();
        if (this.first == null) {
            this.first = node;
        }
    }

    public void addChildBefore(Node node, Node node2) {
        if (node.next != null) {
            throw new RuntimeException("newChild had siblings in addChildBefore");
        }
        if (this.first == node2) {
            node.next = this.first;
            this.first = node;
            return;
        }
        Node node3 = this.getChildBefore(node2);
        this.addChildAfter(node, node3);
    }

    public void addChildAfter(Node node, Node node2) {
        if (node.next != null) {
            throw new RuntimeException("newChild had siblings in addChildAfter");
        }
        node.next = node2.next;
        node2.next = node;
        if (this.last == node2) {
            this.last = node;
        }
    }

    public void removeChild(Node node) {
        Node node2 = this.getChildBefore(node);
        if (node2 == null) {
            this.first = this.first.next;
        } else {
            node2.next = node.next;
        }
        if (node == this.last) {
            this.last = node2;
        }
        node.next = null;
    }

    public void replaceChild(Node node, Node node2) {
        node2.next = node.next;
        if (node == this.first) {
            this.first = node2;
        } else {
            Node node3 = this.getChildBefore(node);
            node3.next = node2;
        }
        if (node == this.last) {
            this.last = node2;
        }
        node.next = null;
    }

    public void replaceChildAfter(Node node, Node node2) {
        Node node3 = node.next;
        node2.next = node3.next;
        node.next = node2;
        if (node3 == this.last) {
            this.last = node2;
        }
        node3.next = null;
    }

    public void removeChildren() {
        this.last = null;
        this.first = null;
    }

    @Override
    public Iterator<Node> iterator() {
        return new NodeIterator();
    }

    private static final String propToString(int n) {
        return null;
    }

    private PropListItem lookupProperty(int n) {
        PropListItem propListItem = this.propListHead;
        while (propListItem != null && n != propListItem.type) {
            propListItem = propListItem.next;
        }
        return propListItem;
    }

    private PropListItem ensureProperty(int n) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            propListItem = new PropListItem();
            propListItem.type = n;
            propListItem.next = this.propListHead;
            this.propListHead = propListItem;
        }
        return propListItem;
    }

    public void removeProp(int n) {
        PropListItem propListItem = this.propListHead;
        if (propListItem != null) {
            PropListItem propListItem2 = null;
            while (propListItem.type != n) {
                propListItem2 = propListItem;
                propListItem = propListItem.next;
                if (propListItem != null) continue;
                return;
            }
            if (propListItem2 == null) {
                this.propListHead = propListItem.next;
            } else {
                propListItem2.next = propListItem.next;
            }
        }
    }

    public Object getProp(int n) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            return null;
        }
        return propListItem.objectValue;
    }

    public int getIntProp(int n, int n2) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            return n2;
        }
        return propListItem.intValue;
    }

    public int getExistingIntProp(int n) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            Kit.codeBug();
        }
        return propListItem.intValue;
    }

    public void putProp(int n, Object object) {
        if (object == null) {
            this.removeProp(n);
        } else {
            PropListItem propListItem = this.ensureProperty(n);
            propListItem.objectValue = object;
        }
    }

    public void putIntProp(int n, int n2) {
        PropListItem propListItem = this.ensureProperty(n);
        propListItem.intValue = n2;
    }

    public int getLineno() {
        return this.lineno;
    }

    public void setLineno(int n) {
        this.lineno = n;
    }

    public final double getDouble() {
        return ((NumberLiteral)this).getNumber();
    }

    public final void setDouble(double d) {
        ((NumberLiteral)this).setNumber(d);
    }

    public final String getString() {
        return ((Name)this).getIdentifier();
    }

    public final void setString(String string) {
        if (string == null) {
            Kit.codeBug();
        }
        ((Name)this).setIdentifier(string);
    }

    public Scope getScope() {
        return ((Name)this).getScope();
    }

    public void setScope(Scope scope) {
        if (scope == null) {
            Kit.codeBug();
        }
        if (!(this instanceof Name)) {
            throw Kit.codeBug();
        }
        ((Name)this).setScope(scope);
    }

    public static Node newTarget() {
        return new Node(131);
    }

    public final int labelId() {
        if (this.type != 131 && this.type != 72) {
            Kit.codeBug();
        }
        return this.getIntProp(15, -1);
    }

    public void labelId(int n) {
        if (this.type != 131 && this.type != 72) {
            Kit.codeBug();
        }
        this.putIntProp(15, n);
    }

    public boolean hasConsistentReturnUsage() {
        int n = this.endCheck();
        return (n & 4) == 0 || (n & 0xB) == 0;
    }

    private int endCheckIf() {
        int n = 0;
        Node node = this.next;
        Node node2 = ((Jump)this).target;
        n = node.endCheck();
        n = node2 != null ? (n |= node2.endCheck()) : (n |= 1);
        return n;
    }

    private int endCheckSwitch() {
        int n = 0;
        return n;
    }

    private int endCheckTry() {
        int n = 0;
        return n;
    }

    private int endCheckLoop() {
        int n = 0;
        Node node = this.first;
        while (node.next != this.last) {
            node = node.next;
        }
        if (node.type != 6) {
            return 1;
        }
        n = ((Jump)node).target.next.endCheck();
        if (node.first.type == 45) {
            n &= 0xFFFFFFFE;
        }
        return n |= this.getIntProp(18, 0);
    }

    private int endCheckBlock() {
        int n = 1;
        Node node = this.first;
        while (n & true && node != null) {
            n &= 0xFFFFFFFE;
            n |= node.endCheck();
            node = node.next;
        }
        return n;
    }

    private int endCheckLabel() {
        int n = 0;
        n = this.next.endCheck();
        return n |= this.getIntProp(18, 0);
    }

    private int endCheckBreak() {
        Jump jump = ((Jump)this).getJumpStatement();
        jump.putIntProp(18, 1);
        return 0;
    }

    private int endCheck() {
        switch (this.type) {
            case 120: {
                return this.endCheckBreak();
            }
            case 133: {
                if (this.first != null) {
                    return this.first.endCheck();
                }
                return 1;
            }
            case 72: {
                return 8;
            }
            case 50: 
            case 121: {
                return 0;
            }
            case 4: {
                if (this.first != null) {
                    return 4;
                }
                return 2;
            }
            case 131: {
                if (this.next != null) {
                    return this.next.endCheck();
                }
                return 1;
            }
            case 132: {
                return this.endCheckLoop();
            }
            case 129: 
            case 141: {
                if (this.first == null) {
                    return 1;
                }
                switch (this.first.type) {
                    case 130: {
                        return this.first.endCheckLabel();
                    }
                    case 7: {
                        return this.first.endCheckIf();
                    }
                    case 114: {
                        return this.first.endCheckSwitch();
                    }
                    case 81: {
                        return this.first.endCheckTry();
                    }
                }
                return this.endCheckBlock();
            }
        }
        return 1;
    }

    public boolean hasSideEffects() {
        switch (this.type) {
            case 89: 
            case 133: {
                if (this.last != null) {
                    return this.last.hasSideEffects();
                }
                return true;
            }
            case 102: {
                if (this.first == null || this.first.next == null || this.first.next.next == null) {
                    Kit.codeBug();
                }
                return this.first.next.hasSideEffects() && this.first.next.next.hasSideEffects();
            }
            case 104: 
            case 105: {
                if (this.first == null || this.last == null) {
                    Kit.codeBug();
                }
                return this.first.hasSideEffects() || this.last.hasSideEffects();
            }
            case -1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 30: 
            case 31: 
            case 35: 
            case 37: 
            case 38: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 64: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 81: 
            case 82: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 106: 
            case 107: 
            case 112: 
            case 113: 
            case 114: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 153: 
            case 154: 
            case 158: 
            case 159: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.type);
    }

    private void toString(ObjToIntMap objToIntMap, StringBuffer stringBuffer) {
    }

    public String toStringTree(ScriptNode scriptNode) {
        return null;
    }

    private static void toStringTreeHelper(ScriptNode scriptNode, Node node, ObjToIntMap objToIntMap, int n, StringBuffer stringBuffer) {
    }

    private static void generatePrintIds(Node node, ObjToIntMap objToIntMap) {
    }

    private static void appendPrintId(Node node, ObjToIntMap objToIntMap, StringBuffer stringBuffer) {
    }

    public class NodeIterator
    implements Iterator<Node> {
        private Node cursor;
        private Node prev = Node.access$000();
        private Node prev2;
        private boolean removed = false;

        public NodeIterator() {
            this.cursor = Node.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public Node next() {
            if (this.cursor == null) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            this.prev2 = this.prev;
            this.prev = this.cursor;
            this.cursor = this.cursor.next;
            return this.prev;
        }

        @Override
        public void remove() {
            if (this.prev == NOT_SET) {
                throw new IllegalStateException("next() has not been called");
            }
            if (this.removed) {
                throw new IllegalStateException("remove() already called for current element");
            }
            if (this.prev == Node.this.first) {
                Node.this.first = this.prev.next;
            } else if (this.prev == Node.this.last) {
                this.prev2.next = null;
                Node.this.last = this.prev2;
            } else {
                this.prev2.next = this.cursor;
            }
        }
    }

    private static class PropListItem {
        PropListItem next;
        int type;
        int intValue;
        Object objectValue;

        private PropListItem() {
        }
    }
}

