/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomPartitioningPolicy
extends PartitioningPolicy {
    protected String partitioningClasName;
    protected PartitioningPolicy policy;

    @Override
    public void initialize(AbstractSession session) {
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.getPartitioningClasName() == null) {
            this.setPartitioningClasName("");
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                Class partitioningClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getPartitioningClasName(), true, classLoader));
                this.policy = (PartitioningPolicy)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(partitioningClass));
            } else {
                Class partitioningClass = PrivilegedAccessHelper.getClassForName(this.getPartitioningClasName(), true, classLoader);
                this.policy = (PartitioningPolicy)PrivilegedAccessHelper.newInstanceFromClass(partitioningClass);
            }
        }
        catch (PrivilegedActionException exception) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getPartitioningClasName(), exception.getException());
        }
        catch (ClassNotFoundException exception) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.getPartitioningClasName(), exception);
        }
        catch (IllegalAccessException exception) {
            throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getPartitioningClasName(), exception);
        }
        catch (InstantiationException exception) {
            throw ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getPartitioningClasName(), exception);
        }
    }

    @Override
    public List<Accessor> getConnectionsForQuery(AbstractSession session, DatabaseQuery query, AbstractRecord arguments) {
        return this.policy.getConnectionsForQuery(session, query, arguments);
    }

    public String getPartitioningClasName() {
        return this.partitioningClasName;
    }

    public void setPartitioningClasName(String partitioningClasName) {
        this.partitioningClasName = partitioningClasName;
    }

    public PartitioningPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(PartitioningPolicy policy) {
        this.policy = policy;
    }
}

