/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.MenuButtonBehavior;
import com.sun.javafx.scene.control.skin.ContextMenuContent;
import com.sun.javafx.scene.control.skin.MenuButtonSkinBase;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.MenuButton;
import javafx.stage.WindowEvent;

public class MenuButtonSkin
extends MenuButtonSkinBase<MenuButton, MenuButtonBehavior> {
    static final String AUTOHIDE = "autoHide";

    public MenuButtonSkin(final MenuButton menuButton) {
        super(menuButton, new MenuButtonBehavior(menuButton));
        this.popup.setOnAutoHide(new EventHandler<Event>(){

            @Override
            public void handle(Event event) {
                MenuButton menuButton = (MenuButton)MenuButtonSkin.this.getSkinnable();
                if (!menuButton.getProperties().containsKey(MenuButtonSkin.AUTOHIDE)) {
                    menuButton.getProperties().put(MenuButtonSkin.AUTOHIDE, Boolean.TRUE);
                }
            }
        });
        this.popup.setOnShown(new EventHandler<WindowEvent>(){

            @Override
            public void handle(WindowEvent windowEvent) {
                ContextMenuContent contextMenuContent = (ContextMenuContent)MenuButtonSkin.this.popup.getSkin().getNode();
                if (contextMenuContent != null) {
                    contextMenuContent.requestFocus();
                }
            }
        });
        if (menuButton.getOnAction() == null) {
            menuButton.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    menuButton.show();
                }
            });
        }
        this.label.setLabelFor(menuButton);
    }
}

