/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ShortLookupTable
extends LookupTable {
    short[][] data;

    public ShortLookupTable(int n, short[][] sArray) {
        super(n, sArray.length);
        this.numComponents = sArray.length;
        this.numEntries = sArray[0].length;
        this.data = new short[this.numComponents][];
        for (int i = 0; i < this.numComponents; ++i) {
            this.data[i] = sArray[i];
        }
    }

    public ShortLookupTable(int n, short[] sArray) {
        super(n, sArray.length);
        this.numComponents = 1;
        this.numEntries = sArray.length;
        this.data = new short[1][];
        this.data[0] = sArray;
    }

    public final short[][] getTable() {
        return this.data;
    }

    @Override
    public int[] lookupPixel(int[] nArray, int[] nArray2) {
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        if (this.numComponents == 1) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = (nArray[i] & 0xFFFF) - this.offset;
                if (n < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                nArray2[i] = this.data[0][n];
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                int n = (nArray[i] & 0xFFFF) - this.offset;
                if (n < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                nArray2[i] = this.data[i][n];
            }
        }
        return nArray2;
    }

    public short[] lookupPixel(short[] sArray, short[] sArray2) {
        if (sArray2 == null) {
            sArray2 = new short[sArray.length];
        }
        if (this.numComponents == 1) {
            for (int i = 0; i < sArray.length; ++i) {
                int n = (sArray[i] & 0xFFFF) - this.offset;
                if (n < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                sArray2[i] = this.data[0][n];
            }
        } else {
            for (int i = 0; i < sArray.length; ++i) {
                int n = (sArray[i] & 0xFFFF) - this.offset;
                if (n < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i + "]-offset is " + "less than zero");
                }
                sArray2[i] = this.data[i][n];
            }
        }
        return sArray2;
    }
}

