/*
 * Decompiled with CFR 0.152.
 */
package org.jdatepicker;

import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JFormattedTextField;
import org.jdatepicker.AbstractDateModel;
import org.jdatepicker.DateModel;
import org.jdatepicker.JDatePanel;
import org.jdatepicker.JDatePicker;
import org.jdatepicker.impl.DateComponentFormatter;
import org.jdatepicker.impl.JDatePanelImpl;
import org.jdatepicker.impl.JDatePickerImpl;
import org.jdatepicker.impl.SqlDateModel;
import org.jdatepicker.impl.UtilCalendarModel;
import org.jdatepicker.impl.UtilDateModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDateComponentFactory {
    private Class<? extends DateModel<?>> dateModelClass;
    private JFormattedTextField.AbstractFormatter dateFormatter;
    private Properties i18nStrings;

    public JDateComponentFactory() {
        this(null, null, null);
    }

    public JDateComponentFactory(Class<? extends DateModel<?>> dateModelClass, JFormattedTextField.AbstractFormatter dateFormatter, Locale locale) {
        this.dateModelClass = dateModelClass == null ? this.getDefaultDateModelClass() : dateModelClass;
        this.dateFormatter = dateFormatter == null ? this.getDefaultDateFormatter() : dateFormatter;
        this.i18nStrings = locale == null ? this.getI18nStrings(Locale.getDefault()) : this.getI18nStrings(locale);
    }

    protected Class<? extends DateModel<?>> getDefaultDateModelClass() {
        return UtilCalendarModel.class;
    }

    protected JFormattedTextField.AbstractFormatter getDefaultDateFormatter() {
        return new DateComponentFormatter();
    }

    protected Properties getI18nStrings(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.jdatepicker.i18n.Text", locale);
        return this.convertToProperties(resourceBundle);
    }

    private Properties convertToProperties(ResourceBundle resource) {
        Properties properties = new Properties();
        Enumeration<String> keys = resource.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            properties.put(key, resource.getString(key));
        }
        return properties;
    }

    private DateModel<?> createDateModel(Class<? extends DateModel<?>> clazz) {
        AbstractDateModel result = null;
        if (clazz.equals(UtilCalendarModel.class)) {
            result = new UtilCalendarModel(Calendar.getInstance());
        }
        if (clazz.equals(UtilDateModel.class)) {
            result = new UtilDateModel(new Date());
        }
        if (clazz.equals(SqlDateModel.class)) {
            result = new SqlDateModel(new java.sql.Date(System.currentTimeMillis()));
        }
        return result;
    }

    private static DateModel<?> createDateModel(Object value) {
        Class<?> clazz = value.getClass();
        AbstractDateModel result = null;
        if (clazz.equals(Calendar.class)) {
            result = new UtilCalendarModel((Calendar)value);
        }
        if (clazz.equals(Date.class)) {
            result = new UtilDateModel((Date)value);
        }
        if (clazz.equals(java.sql.Date.class)) {
            result = new SqlDateModel((java.sql.Date)value);
        }
        return result;
    }

    public JDatePicker createJDatePicker() {
        DateModel<?> model = this.createDateModel(this.dateModelClass);
        return new JDatePickerImpl(new JDatePanelImpl(model, this.i18nStrings), this.dateFormatter);
    }

    public JDatePicker createJDatePicker(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null.");
        }
        DateModel<?> model = JDateComponentFactory.createDateModel(value);
        return new JDatePickerImpl(new JDatePanelImpl(model, this.i18nStrings), this.dateFormatter);
    }

    public JDatePanel createJDatePanel() {
        DateModel<?> model = this.createDateModel(this.dateModelClass);
        return new JDatePanelImpl(model, this.i18nStrings);
    }

    public JDatePanel createJDatePanel(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null.");
        }
        DateModel<?> model = JDateComponentFactory.createDateModel(value);
        return new JDatePanelImpl(model, this.i18nStrings);
    }
}

