/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.skin.KeyCodeUtils;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class KeystrokeUtils {
    public static String toString(KeyCombination keyCombination) {
        if (keyCombination == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (PlatformUtil.isMac()) {
            if (keyCombination.getControl() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("\u2303");
            }
            if (keyCombination.getAlt() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("\u2325");
            }
            if (keyCombination.getShift() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("\u21e7");
            }
            if (keyCombination.getMeta() == KeyCombination.ModifierValue.DOWN || keyCombination.getShortcut() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("\u2318");
            }
        } else {
            if (keyCombination.getControl() == KeyCombination.ModifierValue.DOWN || keyCombination.getShortcut() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("Ctrl+");
            }
            if (keyCombination.getAlt() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("Alt+");
            }
            if (keyCombination.getShift() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("Shift+");
            }
            if (keyCombination.getMeta() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("Meta+");
            }
        }
        if (keyCombination instanceof KeyCodeCombination) {
            stringBuilder.append(KeyCodeUtils.getAccelerator(((KeyCodeCombination)keyCombination).getCode()));
        } else if (keyCombination instanceof KeyCharacterCombination) {
            stringBuilder.append(((KeyCharacterCombination)keyCombination).getCharacter());
        }
        return stringBuilder.toString();
    }
}

